/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Date;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.impl.SolarCellImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SolarCellCustomImpl
extends SolarCellImpl {
    @Override
    public double getSurface() {
        return this.getWidth() * this.getLength();
    }

    @Override
    public double requestPower(double requestedPower) {
        double powerProvided = 0.0;
        powerProvided = requestedPower > this.getPowerAvailable() ? this.getPowerAvailable() : requestedPower;
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SOLAR_CELL__POWER, (Object)powerProvided, true);
        return powerProvided;
    }

    @Override
    public void update(Date time) {
        double currentPowerAvailable = 0.0;
        if (this.getSunIncidenceVector() != null && !this.isShadowed()) {
            Vector3d zAxis = new Vector3d(0.0, 0.0, 1.0);
            Vector3d sunV = new Vector3d(this.getSunIncidenceVector().asTuple3d());
            double sunIncidenceAngle = sunV.angle(zAxis);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SOLAR_CELL__SUN_INCIDENCE_ANGLE, (Object)sunIncidenceAngle, true);
            if (sunIncidenceAngle >= 0.0 && sunIncidenceAngle <= Math.toRadians(90.0)) {
                currentPowerAvailable = this.getSurface() * Math.cos(sunIncidenceAngle) * this.getSolarIllumination() * (this.getEfficiency() / 100.0);
            }
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_PROVIDER__POWER_AVAILABLE, (Object)currentPowerAvailable, true);
    }
}

