/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.ui.impl;

import geometry_msgs.Transform;
import org.eclipse.apogy.addons.ros.ApogyAddonsROSFacade;
import org.eclipse.apogy.addons.ros.ApogyAddonsROSFactory;
import org.eclipse.apogy.addons.ros.ROSInterface;
import org.eclipse.apogy.addons.ros.ROSNode;
import org.eclipse.apogy.addons.ros.ui.TFDisplay3DTool;
import org.eclipse.apogy.addons.ros.ui.impl.TFDisplay3DToolImpl;
import org.eclipse.apogy.addons.ros.utilities.GeometryUtils;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.ros.message.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFDisplay3DToolCustomImpl
extends TFDisplay3DToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(TFDisplay3DToolImpl.class);
    private TransformListener transformListener;
    private TransformNode transformNode;

    public void setActive(boolean newActive) {
        if (!this.isActive() && newActive) {
            this.start();
        } else if (this.isActive() && !newActive) {
            this.stop();
        }
        super.setActive(newActive);
    }

    public void setVisible(boolean newVisible) {
        super.setVisible(newVisible);
        NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)this.transformNode);
        if (nodePresentation != null) {
            nodePresentation.setVisible(this.isVisible() && this.isActive());
        }
    }

    public void setRootNode(Node newRootNode) {
        if (this.getRootNode() instanceof GroupNode) {
            GroupNode previousGroupNode = (GroupNode)this.getRootNode();
            previousGroupNode.getChildren().remove((Object)this.getTransformNode());
        }
        super.setRootNode(newRootNode);
        if (newRootNode instanceof GroupNode) {
            GroupNode newGroupNode = (GroupNode)newRootNode;
            newGroupNode.getChildren().add((Object)this.getTransformNode());
        }
    }

    public void dispose() {
        if (this.transformNode != null && this.transformNode.getParent() instanceof GroupNode) {
            ((GroupNode)this.transformNode.getParent()).getChildren().remove((Object)this.transformNode);
            this.transformNode.setParent(null);
            this.transformNode = null;
        }
        super.dispose();
    }

    @Override
    public boolean start() {
        ROSNode node = ApogyAddonsROSFactory.eINSTANCE.createROSNode();
        node.setNodeName("/TFDisplayClient" + ApogyAddonsROSFacade.INSTANCE.getNodeNamePrefix());
        node.setEnableAutoRestartOnConnectionLost(false);
        Logger.info("RosNode Initializing");
        try {
            node.initialize();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to initialize the TFDisplay3DTool ROS Client");
        }
        this.setNode(node);
        node.register((ROSInterface)this, false);
        node.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                boolean connected;
                if (msg.getFeatureID(ROSNode.class) == 6 && (connected = msg.getNewBooleanValue())) {
                    Logger.info("Connected to the topic.");
                    TFDisplay3DToolCustomImpl.this.setConnected(true);
                }
            }
        });
        node.start();
        return true;
    }

    @Override
    public boolean stop() {
        if (this.getNode() != null) {
            try {
                this.getNode().shutdown();
                this.setNode(null);
            }
            catch (Throwable t) {
                Logger.error("stop(): failed!", t);
                this.setConnected(false);
                return false;
            }
        }
        this.setConnected(false);
        return true;
    }

    @Override
    public void rosInit() {
        Logger.info("rosInit() on topic <" + this.getTopicName() + ">.");
        this.topicLauncher.createListener(this.getTopicName(), "geometry_msgs/Transform", (MessageListener)new TransformListener(this));
        if (!this.topicLauncher.isRunning()) {
            this.topicLauncher.launch();
        }
    }

    protected TransformNode getTransformNode() {
        if (this.transformNode == null) {
            this.transformNode = ApogyCommonTopologyFactory.eINSTANCE.createTransformNode();
            this.transformNode.setNodeId("TFDisplay3DTool");
            this.transformNode.setDescription("TF : <" + this.getTopicName() + ">");
            NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)this.transformNode);
            if (nodePresentation != null) {
                nodePresentation.setVisible(this.isVisible() && this.isActive());
            }
        }
        return this.transformNode;
    }

    protected TransformListener getTransformListener() {
        if (this.transformListener == null) {
            this.transformListener = new TransformListener(this);
        }
        return this.transformListener;
    }

    private class TransformListener
    implements MessageListener<Transform> {
        private final TFDisplay3DTool tfDisplay3DTool;

        public TransformListener(TFDisplay3DTool newTFDisplay3DTool) {
            this.tfDisplay3DTool = newTFDisplay3DTool;
        }

        public void onNewMessage(Transform msg) {
            if (TFDisplay3DToolCustomImpl.this.getTransformNode() != null && this.tfDisplay3DTool.isActive()) {
                Matrix4x4 matrix = GeometryUtils.rosTransformToMatrix((Transform)msg);
                TFDisplay3DToolCustomImpl.this.getTransformNode().setTransformation(matrix.asMatrix4d());
            }
        }
    }
}

