/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraFactory;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.Line2D;
import org.eclipse.apogy.addons.sensors.imaging.camera.OverlayAlignment;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.LineDrawingCameraToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;

public class LineDrawingCameraToolCustomImpl
extends LineDrawingCameraToolImpl {
    public static final long MAX_DELTA_TIME_MS = 500L;
    private ImageSnapshot imageSnapshot;
    protected Line2D activeLine;
    private long lineBufferUpdateTime = 0L;
    private List<Double> xBuffer = new ArrayList<Double>();
    private List<Double> yBuffer = new ArrayList<Double>();

    @Override
    public void initializeCamera(AbstractCamera camera) {
    }

    @Override
    public void setLineThickness(int newLineThickness) {
        if (newLineThickness >= 1) {
            super.setLineThickness(newLineThickness);
            this.updateNumberOfChanges();
        }
    }

    @Override
    public void clearAllLines() {
        ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.LINE_DRAWING_CAMERA_TOOL__LINES, true);
        this.updateNumberOfChanges();
    }

    @Override
    public void mouseMoved(AbstractEImage cameraImage, int mouseButton, int x, int y) {
        if (this.isActive()) {
            if (mouseButton == 1) {
                if (this.activeLine == null) {
                    this.activeLine = this.createNewLine();
                }
                this.xBuffer.add(new Double(x));
                this.yBuffer.add(new Double(y));
            }
            if (System.currentTimeMillis() - this.lineBufferUpdateTime > 500L && !this.xBuffer.isEmpty()) {
                if (this.xBuffer.size() == 1) {
                    this.xBuffer.add(new Double(this.xBuffer.get(0)));
                    this.yBuffer.add(new Double(this.yBuffer.get(0)));
                }
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.activeLine, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.LINE2_D__XCOORDINATES, this.xBuffer);
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.activeLine, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.LINE2_D__YCOORDINATES, this.yBuffer);
                this.lineBufferUpdateTime = System.currentTimeMillis();
                this.xBuffer.clear();
                this.yBuffer.clear();
                this.updateNumberOfChanges();
            }
        }
    }

    @Override
    public void positionSelected(AbstractEImage cameraImage, int mouseButton, int x, int y) {
        if (this.isActive()) {
            switch (mouseButton) {
                case 1: {
                    this.activeLine = this.createNewLine();
                    break;
                }
                case 3: {
                    this.activeLine = this.deleteLastLine();
                }
            }
        }
    }

    @Override
    public void updateImageSnapshot(ImageSnapshot imageSnapshot) {
        this.imageSnapshot = imageSnapshot;
    }

    @Override
    public AbstractEImage applyOverlay(AbstractCamera camera, AbstractEImage cameraImage, OverlayAlignment overlayAlignment, int overlayWidth, int overlayHeight) {
        if (camera.getLatestImageSnapshot() != null && camera.getLatestImageSnapshot().getImage() != null) {
            int width = camera.getLatestImageSnapshot().getImage().getWidth();
            int height = camera.getLatestImageSnapshot().getImage().getHeight();
            AbstractEImage userSelectedAreaImage = this.getLineDrawingImage(width, height);
            userSelectedAreaImage = EImagesUtilities.INSTANCE.resize(userSelectedAreaImage, width, height);
            AbstractEImage result = EImagesUtilities.INSTANCE.applyOverlay(cameraImage, userSelectedAreaImage, true);
            return result;
        }
        return cameraImage;
    }

    @Override
    public void setLineColor(RGBA newLineColor) {
        super.setLineColor(newLineColor);
        this.updateNumberOfChanges();
    }

    @Override
    public void keyPressed(AbstractEImage cameraImage, char key) {
    }

    @Override
    public void keyReleased(AbstractEImage cameraImage, char key) {
    }

    protected Line2D createNewLine() {
        Line2D newLine = ApogyAddonsSensorsImagingCameraFactory.eINSTANCE.createLine2D();
        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.LINE_DRAWING_CAMERA_TOOL__LINES, (Object)newLine);
        return newLine;
    }

    protected Line2D deleteLastLine() {
        if (!this.getLines().isEmpty()) {
            Line2D lineToRemove = (Line2D)this.getLines().get(this.getLines().size() - 1);
            Line2D newLastLine = null;
            if (this.getLines().size() > 1) {
                newLastLine = (Line2D)this.getLines().get(this.getLines().size() - 2);
            }
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.LINE_DRAWING_CAMERA_TOOL__LINES, (Object)lineToRemove, true);
            this.updateNumberOfChanges();
            return newLastLine;
        }
        this.updateNumberOfChanges();
        return null;
    }

    protected void updateNumberOfChanges() {
        int newChangeCount = this.getChangesCount() + 1;
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.LINE_DRAWING_CAMERA_TOOL__CHANGES_COUNT, (Object)newChangeCount, true);
    }

    protected Color getColorOfLine() {
        if (this.getLineColor() != null) {
            return new Color(this.getLineColor().rgb.red, this.getLineColor().rgb.green, this.getLineColor().rgb.blue);
        }
        return Color.BLUE;
    }

    protected AbstractEImage getLineDrawingImage(int width, int height) {
        AbstractEImage areaImage = EImagesUtilities.INSTANCE.createTransparentImage(width, height);
        try {
            BufferedImage bufferedImage = areaImage.asBufferedImage();
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.setColor(this.getColorOfLine());
            g2d.setStroke(new BasicStroke(this.getLineThickness()));
            for (Line2D line : this.getLines()) {
                Point p0 = null;
                Point p1 = null;
                int numberOfPoint = line.getXCoordinates().size();
                int i = 0;
                while (i < numberOfPoint) {
                    int y;
                    int x = (int)Math.ceil((Double)line.getXCoordinates().get(i));
                    p0 = new Point(x, y = (int)Math.ceil((Double)line.getYCoordinates().get(i)));
                    if (p0 != null && p1 != null) {
                        int x0 = p0.x;
                        int x1 = p1.x;
                        int y0 = p0.y;
                        int y1 = p1.y;
                        g2d.drawLine(x0, y0, x1, y1);
                    }
                    p1 = p0;
                    ++i;
                }
            }
            g2d.dispose();
            EImage resultImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            resultImage.setImageContent(bufferedImage);
            return resultImage;
        }
        catch (Exception e) {
            e.printStackTrace();
            return areaImage;
        }
    }
}

