/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.common.converters.FileExporterUtilities;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.converters.AbstractEImageToFileConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSnapshotToIFileConverter
implements IFileExporter {
    private static final Logger Logger = LoggerFactory.getLogger(ImageSnapshotToIFileConverter.class);

    public boolean canConvert(Object arg0) {
        if (arg0 instanceof ImageSnapshot) {
            return ((ImageSnapshot)arg0).getImage() != null;
        }
        return false;
    }

    public Object convert(Object arg0) throws Exception {
        ImageSnapshot imageSnapshot = (ImageSnapshot)arg0;
        String tmpFolder = String.valueOf(System.getProperty("user.home")) + File.separator + System.getProperty("java.io.tmpdir");
        Date now = new Date();
        String fileName = null;
        try {
            fileName = String.valueOf(tmpFolder) + File.separator + now.getTime() + "." + "jpg";
            EImagesUtilities.INSTANCE.saveImageAsJPEG(fileName, imageSnapshot.getImage());
            return new File(fileName);
        }
        catch (Exception e) {
            File toDelete = new File(fileName);
            toDelete.delete();
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Class<?> getInputType() {
        return ImageSnapshot.class;
    }

    public Class<?> getOutputType() {
        return File.class;
    }

    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        ImageSnapshot imageSnapshot = (ImageSnapshot)input;
        for (String extension : extensions) {
            String fullPathString = String.valueOf(filePath) + "." + extension;
            if (extension.equalsIgnoreCase("jpg")) {
                EImagesUtilities.INSTANCE.saveImageAsJPEG(fullPathString, imageSnapshot.getImage());
                continue;
            }
            if (extension.equalsIgnoreCase("png")) {
                EImagesUtilities.INSTANCE.saveImageAsPNG(fullPathString, imageSnapshot.getImage());
                continue;
            }
            if (!extension.equalsIgnoreCase("metadata")) continue;
            FileExporterUtilities.saveMetaDataToFile((String)fullPathString, (String)ImageSnapshotToIFileConverter.getMetaData(imageSnapshot));
        }
    }

    public List<String> getSupportedFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("jpg");
        extensions.add("png");
        extensions.add("metadata");
        return extensions;
    }

    public String getDescription(String fileExtension) {
        if (fileExtension.contains("jpg")) {
            return "The ImageSnapshot's image to file in JPEG format.";
        }
        if (fileExtension.contains("png")) {
            return "The ImageSnapshot's image to file in PNG format.";
        }
        if (fileExtension.contains("metadata")) {
            return "The ImageSnapshot metadata (FOV,time stamp).";
        }
        return null;
    }

    public static String getMetaData(ImageSnapshot imageSnapshot) {
        String metadata = "";
        if (imageSnapshot.getTime() != null) {
            metadata = String.valueOf(metadata) + "Time = " + ApogyCommonEMFFacade.INSTANCE.format(imageSnapshot.getTime()) + "\n";
        }
        if (imageSnapshot.getFieldOfView() != null) {
            metadata = String.valueOf(metadata) + "FOV Horizontal (deg) = " + Math.toDegrees(imageSnapshot.getFieldOfView().getHorizontalFieldOfViewAngle()) + "\n";
            metadata = String.valueOf(metadata) + "FOV Vertical (deg) = " + Math.toDegrees(imageSnapshot.getFieldOfView().getVerticalFieldOfViewAngle()) + "\n";
        }
        if (imageSnapshot.getImage() != null) {
            metadata = String.valueOf(metadata) + AbstractEImageToFileConverter.getMetaData((AbstractEImage)imageSnapshot.getImage());
        }
        return metadata;
    }
}

