/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.ui.composites;

import org.eclipse.apogy.addons.sensors.pose.OrientationSensor;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianOrientationCoordinates;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EditOrientationComposite
extends Composite {
    private OrientationSensor orientationSensor;
    private Text xValueText = null;
    private Text yValueText = null;
    private Text zValueText = null;

    public EditOrientationComposite(Composite parent, int style) {
        super(parent, style);
    }

    public EditOrientationComposite(Composite parent, int style, OrientationSensor orientationSensor) {
        super(parent, style);
        this.orientationSensor = orientationSensor;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label xLabel = new Label((Composite)this, 0);
        xLabel.setText("X Rotation (deg):");
        GridData gridDataX = new GridData();
        gridDataX.widthHint = 100;
        gridDataX.horizontalAlignment = 4;
        this.xValueText = new Text((Composite)this, 2048);
        this.xValueText.setLayoutData((Object)gridDataX);
        this.xValueText.setText(Double.toString(Math.toDegrees(orientationSensor.getOrientationCoordinates().getXRotation())));
        Label yLabel = new Label((Composite)this, 0);
        yLabel.setText("Y Rotation (deg):");
        GridData gridDataY = new GridData();
        gridDataY.widthHint = 100;
        gridDataY.horizontalAlignment = 4;
        this.yValueText = new Text((Composite)this, 2048);
        this.yValueText.setLayoutData((Object)gridDataY);
        this.yValueText.setText(Double.toString(Math.toDegrees(orientationSensor.getOrientationCoordinates().getYRotation())));
        Label zLabel = new Label((Composite)this, 0);
        zLabel.setText("Z Rotation (deg):");
        GridData gridDataZ = new GridData();
        gridDataZ.widthHint = 100;
        gridDataZ.horizontalAlignment = 4;
        this.zValueText = new Text((Composite)this, 2048);
        this.zValueText.setLayoutData((Object)gridDataZ);
        this.zValueText.setText(Double.toString(Math.toDegrees(orientationSensor.getOrientationCoordinates().getZRotation())));
        this.setSize(new Point(300, 200));
    }

    public CartesianOrientationCoordinates getNewValues() {
        CartesianOrientationCoordinates orientation = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianOrientationCoordinates(this.orientationSensor.getOrientationCoordinates());
        try {
            double xRotation = Math.toRadians(Double.parseDouble(this.xValueText.getText()));
            double yRotation = Math.toRadians(Double.parseDouble(this.yValueText.getText()));
            double zRotation = Math.toRadians(Double.parseDouble(this.zValueText.getText()));
            orientation = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianOrientationCoordinates(xRotation, yRotation, zRotation);
        }
        catch (Exception exception) {}
        return orientation;
    }
}

