/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.ui.composites;

import org.eclipse.apogy.addons.sensors.pose.PositionSensor;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EditPositionComposite
extends Composite {
    private PositionSensor positionSensor;
    private Text xValueText = null;
    private Text yValueText = null;
    private Text zValueText = null;

    public EditPositionComposite(Composite parent, int style) {
        super(parent, style);
    }

    public EditPositionComposite(Composite parent, int style, PositionSensor positionSensor) {
        super(parent, style);
        this.positionSensor = positionSensor;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label xLabel = new Label((Composite)this, 0);
        xLabel.setText("X:");
        GridData gridDataX = new GridData();
        gridDataX.widthHint = 100;
        gridDataX.horizontalAlignment = 4;
        this.xValueText = new Text((Composite)this, 2048);
        this.xValueText.setLayoutData((Object)gridDataX);
        this.xValueText.setText(Double.toString(positionSensor.getPosition().getX()));
        Label yLabel = new Label((Composite)this, 0);
        yLabel.setText("Y:");
        GridData gridDataY = new GridData();
        gridDataY.widthHint = 100;
        gridDataY.horizontalAlignment = 4;
        this.yValueText = new Text((Composite)this, 2048);
        this.yValueText.setLayoutData((Object)gridDataY);
        this.yValueText.setText(Double.toString(positionSensor.getPosition().getY()));
        Label zLabel = new Label((Composite)this, 0);
        zLabel.setText("Z:");
        GridData gridDataZ = new GridData();
        gridDataZ.widthHint = 100;
        gridDataZ.horizontalAlignment = 4;
        this.zValueText = new Text((Composite)this, 2048);
        this.zValueText.setLayoutData((Object)gridDataZ);
        this.zValueText.setText(Double.toString(positionSensor.getPosition().getZ()));
        this.setSize(new Point(300, 200));
    }

    public CartesianPositionCoordinates getNewValues() {
        CartesianPositionCoordinates position = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(this.positionSensor.getPositionCoordinates());
        try {
            double x = Double.parseDouble(this.xValueText.getText());
            double y = Double.parseDouble(this.yValueText.getText());
            double z = Double.parseDouble(this.zValueText.getText());
            position = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
        }
        catch (Exception exception) {}
        return position;
    }
}

