/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.Pose;
import org.eclipse.apogy.common.math.GeometricUtils;

public class PoseUtils {
    public static Matrix4d getTransformFromSensorFrameToNewPose(Pose currentPoseInSensorFrame, Pose newCurrentPose) {
        Matrix4d currentPoseMatrix = GeometricUtils.packXYZ((double)currentPoseInSensorFrame.getX(), (double)currentPoseInSensorFrame.getY(), (double)currentPoseInSensorFrame.getZ(), (double)currentPoseInSensorFrame.getXRotation(), (double)currentPoseInSensorFrame.getYRotation(), (double)currentPoseInSensorFrame.getZRotation());
        Matrix4d currentPose = new Matrix4d(currentPoseMatrix);
        Matrix4d newPoseMatrix = GeometricUtils.packXYZ((double)newCurrentPose.getX(), (double)newCurrentPose.getY(), (double)newCurrentPose.getZ(), (double)newCurrentPose.getXRotation(), (double)newCurrentPose.getYRotation(), (double)newCurrentPose.getZRotation());
        Matrix4d newPose = new Matrix4d(newPoseMatrix);
        Matrix4d invertedCurrentPose = new Matrix4d(currentPose);
        invertedCurrentPose.invert();
        newPose.mul(invertedCurrentPose);
        return newPose;
    }

    public static Pose applyTransform(Matrix4d transform, Pose initialPose) {
        Matrix4d initialPoseTransform = new Matrix4d(GeometricUtils.packXYZ((double)initialPose.getX(), (double)initialPose.getY(), (double)initialPose.getZ(), (double)initialPose.getXRotation(), (double)initialPose.getYRotation(), (double)initialPose.getZRotation()));
        Matrix4d t = new Matrix4d(transform);
        t.mul(initialPoseTransform);
        Matrix3d rot = new Matrix3d();
        t.get(rot);
        Vector3d rotation = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)rot);
        Vector3d position = new Vector3d();
        t.get(position);
        Pose pose = ApogyCommonGeometryData3DFacade.INSTANCE.createPose(position.x, position.y, position.z, rotation.x, rotation.y, rotation.z);
        return pose;
    }
}

