/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.impl;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.sensors.pose.impl.OrientationSensorImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianOrientationCoordinates;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.topology.RotationNode;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class OrientationSensorCustomImpl
extends OrientationSensorImpl {
    private Adapter orientationAdapter = null;

    protected OrientationSensorCustomImpl() {
        this.eAdapters().add((Object)this.getOrientationAdapter());
    }

    @Override
    public CartesianOrientationCoordinates getOrientationCoordinates() {
        if (this.orientationCoordinates == null) {
            this.orientationCoordinates = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianOrientationCoordinates();
        }
        return this.orientationCoordinates;
    }

    @Override
    public CartesianOrientationCoordinates extractOrientationFromMatrix(Matrix3x3 matrix) {
        Vector3d rotation = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)matrix.asMatrix3d());
        CartesianOrientationCoordinates orientation = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianOrientationCoordinates(rotation.x, rotation.y, rotation.z);
        return orientation;
    }

    private Adapter getOrientationAdapter() {
        if (this.orientationAdapter == null) {
            this.orientationAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(RotationNode.class) == 6) {
                        CartesianOrientationCoordinates newOrientation = OrientationSensorCustomImpl.this.extractOrientationFromMatrix((Matrix3x3)msg.getNewValue());
                        OrientationSensorCustomImpl.this.getOrientationCoordinates().setXRotation(newOrientation.getXRotation());
                        OrientationSensorCustomImpl.this.getOrientationCoordinates().setYRotation(newOrientation.getYRotation());
                        OrientationSensorCustomImpl.this.getOrientationCoordinates().setZRotation(newOrientation.getZRotation());
                    }
                }
            };
        }
        return this.orientationAdapter;
    }
}

