/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.range.impl;

import java.util.List;
import org.eclipse.apogy.addons.sensors.SensorStatus;
import org.eclipse.apogy.addons.sensors.range.RayData;
import org.eclipse.apogy.addons.sensors.range.impl.RangeScannerSimulatorImpl;
import org.eclipse.apogy.common.geometry.data25d.ApogyCommonGeometryData25DFactory;
import org.eclipse.apogy.common.geometry.data25d.Coordinates25D;
import org.eclipse.apogy.common.geometry.data25d.VolumetricCoordinatesSet25D;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangeScannerSimulatorCustomImpl<InputType>
extends RangeScannerSimulatorImpl<InputType> {
    private static final Logger Logger = LoggerFactory.getLogger(RangeScannerSimulatorImpl.class);

    @Override
    public abstract CartesianTriangularMesh getCroppedMesh();

    @Override
    public abstract List<RayData> getSimulatedRays();

    @Override
    public VolumetricCoordinatesSet25D doProcess(InputType input, IProgressMonitor monitor) throws Exception {
        if (this.getOutput() == null) {
            this.setOutput(ApogyCommonGeometryData25DFactory.eINSTANCE.createVolumetricCoordinatesSet25D());
        }
        if (this.getStatus() == SensorStatus.READY) {
            this.setInput(input);
            this.getOutput().getPoints().clear();
            try {
                this.acquireData();
                return this.getOutput();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void acquireData() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract RayData applyOrientationNoise(RayData var1);

    @Override
    public abstract double applyRangeNoise(double var1, RayData var3, RayData var4);

    @Override
    public abstract Coordinates25D createCoordinates25D(RayData var1, double var2);
}

