/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.telecoms.TelecomNode;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorTool;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.Named;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TelecomStatusMonitorToolsComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject extends TelecomStatusMonitorTool>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemObject> {
    private Adapter telecomNodeAdapter;

    public TelecomStatusMonitorToolsComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    public void setRootEObject(RootEObject rootEObject) {
        super.setRootEObject(rootEObject);
    }

    protected Button createDeleteButton(Composite parent, int style) {
        Button btnDelete = TelecomStatusMonitorToolsComposite.createButton((Composite)parent, (int)0, (String)"Delete", e -> {
            MessageDialog dialog;
            String message = "";
            List items = this.getCurrentSelection().toList();
            List<EObject> crossReferencers = this.getCrossReferencers(items);
            int size = items.size();
            message = "Are you sure to delete " + (size > 1 ? "these " + size + " TelecomStatusMonitorTools?" : "this TelecomStatusMonitorTool?");
            if (!crossReferencers.isEmpty()) {
                message = String.valueOf(message) + "It is referenced by the following : \n\n";
                for (EObject item : crossReferencers) {
                    String className = item.eClass().getName();
                    message = String.valueOf(message) + " - ";
                    message = item instanceof Named ? String.valueOf(message) + ((Named)item).getName() : String.valueOf(message) + item.hashCode();
                    message = String.valueOf(message) + " (" + className + ")\n";
                }
            }
            if ((dialog = new MessageDialog(null, "Delete the selected TelecomStatusMonitorTool(s)", null, message, 3, new String[]{"Yes", "No"}, 1)).open() == 0) {
                BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
                    for (TelecomStatusMonitorTool item : items) {
                        this.doDelete((ItemObject)item);
                    }
                });
            }
            this.refreshViewer();
        });
        this.createDeleteButtonBindings(btnDelete);
        return btnDelete;
    }

    protected void doDelete(ItemObject object) {
        ApogyCommonEMFFacade.INSTANCE.nullifyAllCrossReferenceToEObject(object);
        super.doDelete(object);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TelecomNode) {
                    TelecomNode telecomNode = (TelecomNode)element;
                    return telecomNode.getName();
                }
                return "?";
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn enabledColumn = new TreeViewerColumn(viewer, 0x1000000);
        enabledColumn.getColumn().setText("Enabled");
        enabledColumn.setLabelProvider((CellLabelProvider)new ColoredColumnLabelProvider(this){

            public String getText(Object element) {
                if (element instanceof TelecomStatusMonitorTool) {
                    TelecomStatusMonitorTool telecomStatusMonitorTool = (TelecomStatusMonitorTool)element;
                    return Boolean.toString(telecomStatusMonitorTool.isActive());
                }
                return "?";
            }
        });
        enabledColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn addressColumn = new TreeViewerColumn(viewer, 0x1000000);
        addressColumn.getColumn().setText("Network Address");
        addressColumn.setLabelProvider((CellLabelProvider)new ColoredColumnLabelProvider(this){

            public String getText(Object element) {
                if (element instanceof TelecomNode) {
                    TelecomNode telecomNode = (TelecomNode)element;
                    return telecomNode.getAddress();
                }
                return "?";
            }
        });
        addressColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)175);
        TreeViewerColumn statusColumn = new TreeViewerColumn(viewer, 0x1000000);
        statusColumn.getColumn().setText("Status");
        statusColumn.setLabelProvider((CellLabelProvider)new ColoredColumnLabelProvider(this){

            public String getText(Object element) {
                if (element instanceof TelecomNode) {
                    TelecomNode telecomNode = (TelecomNode)element;
                    return telecomNode.getStatus().getLiteral();
                }
                return "?";
            }
        });
        statusColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)175);
        TreeViewerColumn latencyColumn = new TreeViewerColumn(viewer, 0x1000000);
        latencyColumn.getColumn().setText("Latency (ms)");
        latencyColumn.setLabelProvider((CellLabelProvider)new ColoredColumnLabelProvider(this){
            private DecimalFormat decimalFormat;
            {
                this.decimalFormat = new DecimalFormat("0.000");
            }

            public String getText(Object element) {
                if (element instanceof TelecomNode) {
                    TelecomNode telecomNode = (TelecomNode)element;
                    return this.decimalFormat.format(telecomNode.getLatency());
                }
                return "?";
            }
        });
        latencyColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)175);
        TreeViewerColumn packetLossColumn = new TreeViewerColumn(viewer, 0x1000000);
        packetLossColumn.getColumn().setText("Packet Loss (%)");
        packetLossColumn.setLabelProvider((CellLabelProvider)new ColoredColumnLabelProvider(this){
            private DecimalFormat decimalFormat;
            {
                this.decimalFormat = new DecimalFormat("0.0");
            }

            public String getText(Object element) {
                if (element instanceof TelecomNode) {
                    TelecomNode telecomNode = (TelecomNode)element;
                    return this.decimalFormat.format(telecomNode.getPacketLoss());
                }
                return "?";
            }
        });
        packetLossColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)175);
    }

    public static Color getTelecomNodeBackground(TelecomNode telecomNode) {
        Color color = null;
        switch (telecomNode.getStatus().getValue()) {
            case 0: {
                color = Display.getCurrent().getSystemColor(16);
                break;
            }
            case 1: {
                color = Display.getCurrent().getSystemColor(15);
                break;
            }
            case 2: {
                color = Display.getCurrent().getSystemColor(3);
                break;
            }
            case 3: {
                color = Display.getCurrent().getSystemColor(5);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                color = Display.getCurrent().getSystemColor(7);
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                color = Display.getCurrent().getSystemColor(3);
            }
        }
        return color;
    }

    private Adapter getTelecomNodeAdapter() {
        if (this.telecomNodeAdapter == null) {
            this.telecomNodeAdapter = new AdapterImpl(){

                public void notifyChanged(final Notification msg) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TelecomStatusMonitorToolsComposite.this.isDisposed()) {
                                TelecomStatusMonitorToolsComposite.this.getViewer().refresh(msg.getNotifier(), true);
                            }
                        }
                    });
                }
            };
        }
        return this.telecomNodeAdapter;
    }

    protected List<EObject> getCrossReferencers(List<ItemObject> items) {
        ArrayList<EObject> crossReferencers = new ArrayList<EObject>();
        for (TelecomStatusMonitorTool item : items) {
            crossReferencers.addAll(ApogyCommonEMFFacade.INSTANCE.getCrossReferencerToEObject((EObject)item));
        }
        return crossReferencers;
    }

    private class ColoredColumnLabelProvider
    extends ColumnLabelProvider {
        private ColoredColumnLabelProvider() {
        }

        public Color getBackground(Object element) {
            if (element instanceof TelecomNode) {
                TelecomNode telecomNode = (TelecomNode)element;
                if (!telecomNode.eAdapters().contains((Object)TelecomStatusMonitorToolsComposite.this.getTelecomNodeAdapter())) {
                    telecomNode.eAdapters().add((Object)TelecomStatusMonitorToolsComposite.this.getTelecomNodeAdapter());
                }
                return TelecomStatusMonitorToolsComposite.getTelecomNodeBackground(telecomNode);
            }
            return null;
        }
    }
}

