/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.telecoms.ui.Activator;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TelecomsUIPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor abstractAntennaRadiationPatternVisibleBooleanFieldEditor;
    private RadioGroupFieldEditor abstractAntennaRadiationPatternPresentationModeFieldEditor;
    private ColorFieldEditor abstractAntennaRadiationPatternPresentationColorFieldEditor;
    private BooleanFieldEditor abstractAntennaRadiationPatternPresentationAxisVisibleBooleanFieldEditor;
    private List<FieldEditor> fieldsEditors = new ArrayList<FieldEditor>();

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        Group grpAbstractAntennaRadiationPattern = new Group(container, 0);
        grpAbstractAntennaRadiationPattern.setLayout((Layout)new GridLayout(3, false));
        grpAbstractAntennaRadiationPattern.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        grpAbstractAntennaRadiationPattern.setText("Abstract Antenna Radiation Pattern");
        this.abstractAntennaRadiationPatternVisibleBooleanFieldEditor = this.createBooleanFieldEditor((Composite)grpAbstractAntennaRadiationPattern, "ABSTRACT_ANTENNA_RADIATION_PATTERN_VISIBLE_ID", "Visibility");
        this.fieldsEditors.add((FieldEditor)this.abstractAntennaRadiationPatternVisibleBooleanFieldEditor);
        this.abstractAntennaRadiationPatternPresentationColorFieldEditor = this.createColorFieldEditor((Composite)grpAbstractAntennaRadiationPattern, "ABSTRACT_ANTENNA_RADIATION_PATTERN_COLOR_ID", "Default Color:");
        this.fieldsEditors.add((FieldEditor)this.abstractAntennaRadiationPatternPresentationColorFieldEditor);
        this.abstractAntennaRadiationPatternPresentationModeFieldEditor = this.createRadioGroupFieldEditor((Composite)grpAbstractAntennaRadiationPattern, "ABSTRACT_ANTENNA_RADIATION_PATTERN_PRESENTATION_MODE_ID", "Presentation Mode");
        this.fieldsEditors.add((FieldEditor)this.abstractAntennaRadiationPatternPresentationModeFieldEditor);
        this.abstractAntennaRadiationPatternPresentationAxisVisibleBooleanFieldEditor = this.createBooleanFieldEditor((Composite)grpAbstractAntennaRadiationPattern, "DEFAULT_ABSTRACT_ANTENNA_RADIATION_PATTERN_AXIS_VISIBLE_ID", "Axis Visibility");
        this.fieldsEditors.add((FieldEditor)this.abstractAntennaRadiationPatternPresentationAxisVisibleBooleanFieldEditor);
        this.updateControls();
        return container;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        for (FieldEditor editor : this.fieldsEditors) {
            try {
                editor.loadDefault();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        super.performDefaults();
    }

    private void updateControls() {
        for (FieldEditor editor : this.fieldsEditors) {
            try {
                editor.load();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private String[][] getModeLabelsAndValues() {
        String[][] labelAndValues = new String[MeshPresentationMode.VALUES.size()][2];
        int i = 0;
        for (MeshPresentationMode value : MeshPresentationMode.VALUES) {
            labelAndValues[i][0] = value.getName();
            labelAndValues[i][1] = Integer.toString(value.getValue());
            ++i;
        }
        return labelAndValues;
    }

    private BooleanFieldEditor createBooleanFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        BooleanFieldEditor editor = new BooleanFieldEditor(preferenceID, preferenceLabel, container);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private RadioGroupFieldEditor createRadioGroupFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        Composite editorContainer = new Composite(container, 0);
        editorContainer.setLayout((Layout)new GridLayout(1, true));
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor(preferenceID, preferenceLabel, 1, this.getModeLabelsAndValues(), editorContainer, false);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private ColorFieldEditor createColorFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        ColorFieldEditor colorEditor = new ColorFieldEditor(preferenceID, preferenceLabel, container);
        colorEditor.setPreferenceStore(this.getPreferenceStore());
        colorEditor.load();
        return colorEditor;
    }

    private void storePreferences() {
        for (FieldEditor editor : this.fieldsEditors) {
            try {
                editor.store();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

