/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.ApogyAddonsFactory;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.Trajectory3DToolNode;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.impl.Trajectory3DToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data.ApogyCommonGeometryDataPackage;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.PoseProvider;
import org.eclipse.apogy.core.invocator.AbstractTypeImplementation;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trajectory3DToolCustomImpl
extends Trajectory3DToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(Trajectory3DToolImpl.class);
    private PoseProvider poseProvider = null;
    private VariableAdapter variableAdapter = null;
    private Adapter poseProviderAdapter = null;
    private Point3d lastPoseAdded = null;
    private WayPointPath currentWayPointPath = null;

    @Override
    public void setPenDown(boolean newPenDown) {
        super.setPenDown(newPenDown);
        if (newPenDown) {
            this.penDown();
        } else {
            this.penUp();
        }
    }

    @Override
    public double getTotalDistance() {
        double newDistance;
        if (this.totalDistance == 0.0 && (newDistance = this.computeTotalDistance()) != 0.0) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__TOTAL_DISTANCE, (Object)newDistance);
        }
        return super.getTotalDistance();
    }

    protected void setPoseProvider(PoseProvider newPoseProvider) {
        if (this.poseProvider != null) {
            this.poseProvider.eAdapters().remove((Object)this.getPoseProviderAdapter());
        }
        this.poseProvider = newPoseProvider;
        if (newPoseProvider != null) {
            if (newPoseProvider.getPoseTransform() != null) {
                this.updatePose(newPoseProvider.getPoseTransform());
            }
            newPoseProvider.eAdapters().add((Object)this.getPoseProviderAdapter());
        }
    }

    protected PoseProvider getPoseProvider() {
        return this.poseProvider;
    }

    @Override
    public void clearLastPathSegment() {
        if (this.isPenDown()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PEN_DOWN, (Object)false);
            if (this.getPaths().size() > 0) {
                WayPointPath path = (WayPointPath)this.getPaths().get(this.getPaths().size() - 1);
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PATHS, (Object)path, true);
                if ((path.getPoints().size() == 0 || path.getPoints().size() == 1) && this.getPaths().size() > 0) {
                    path = (WayPointPath)this.getPaths().get(this.getPaths().size() - 1);
                    ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PATHS, (Object)path, true);
                }
            } else {
                Logger.warn("Not path segment to remove.");
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PEN_DOWN, (Object)true);
        } else if (this.getPaths().size() > 0) {
            WayPointPath path = (WayPointPath)this.getPaths().get(this.getPaths().size() - 1);
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PATHS, (Object)path, true);
            Logger.info("Last path segment cleared.");
        } else {
            Logger.warn("Not path segment to remove.");
        }
        this.getTotalDistance();
    }

    @Override
    public void clearPaths() {
        if (this.isPenDown()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PEN_DOWN, (Object)false);
            if (this.getPaths() != null) {
                EList<WayPointPath> paths = this.getPaths();
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PATHS, paths, true);
                Logger.info("Paths cleared.");
                this.getTotalDistance();
            } else {
                Logger.error("Failed to clear paths : No paths list defined.");
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PEN_DOWN, (Object)true);
        } else if (this.getPaths() != null) {
            EList<WayPointPath> paths = this.getPaths();
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PATHS, paths, true);
            Logger.info("Paths cleared.");
            this.getTotalDistance();
        } else {
            Logger.error("Failed to clear paths : No paths list defined.");
        }
    }

    @Override
    public void setActive(boolean newActive) {
        super.setActive(newActive);
        if (newActive && this.isPenDown()) {
            this.penDown();
        }
    }

    @Override
    public void setVisible(boolean newVisible) {
        super.setVisible(newVisible);
        this.setTrajectory3DToolNodeVisibility(newVisible);
    }

    @Override
    public void selectionChanged(NodeSelection nodeSelection) {
    }

    @Override
    public void initialise() {
        if (this.getTrajectory3DToolNode() == null) {
            Trajectory3DToolNode toolNode = ApogyAddonsFactory.eINSTANCE.createTrajectory3DToolNode();
            if (this.getName() != null) {
                toolNode.setDescription("Node associated with the TrajectoryTool named <" + this.getName() + ">");
                toolNode.setNodeId("TRAJECTORY_TOOL_" + this.getName().replaceAll(" ", "_"));
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__TRAJECTORY3_DTOOL_NODE, (Object)toolNode);
        }
        super.initialise();
        try {
            this.updatePoseProvider();
        }
        catch (Throwable throwable) {}
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().add((Object)this.getVariableAdapter());
        this.getVariableAdapter().setInvocatorSession(ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession());
    }

    @Override
    public void setRootNode(Node newRootNode) {
        super.setRootNode(newRootNode);
        Trajectory3DToolNode toolNode = this.getTrajectory3DToolNode();
        if (toolNode != null) {
            if (newRootNode instanceof GroupNode) {
                ((GroupNode)newRootNode).getChildren().add((Object)toolNode);
            } else if (toolNode.getParent() instanceof GroupNode) {
                ((GroupNode)toolNode.getParent()).getChildren().remove((Object)toolNode);
            }
        }
        this.setTrajectory3DToolNodeVisibility(this.isVisible());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.poseProvider != null) {
            this.poseProvider.eAdapters().remove((Object)this.getPoseProviderAdapter());
        }
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().remove((Object)this.getVariableAdapter());
        this.getVariableAdapter().setInvocatorSession(null);
        if (this.getTrajectory3DToolNode() != null) {
            if (this.getTrajectory3DToolNode().getParent() instanceof GroupNode) {
                GroupNode parent = (GroupNode)this.getTrajectory3DToolNode().getParent();
                parent.getChildren().remove((Object)this.getTrajectory3DToolNode());
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__TRAJECTORY3_DTOOL_NODE, null);
        }
    }

    private void setTrajectory3DToolNodeVisibility(boolean visible) {
        NodePresentation nodePresentation;
        if (this.getTrajectory3DToolNode() != null && (nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)this.getTrajectory3DToolNode())) != null) {
            nodePresentation.setVisible(visible);
        }
    }

    private void penUp() {
        this.currentWayPointPath = null;
    }

    private void penDown() {
        WayPointPath newWayPointPath = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        String name = String.valueOf(this.getName()) + " - " + Integer.toString(this.getPaths().size() + 1);
        newWayPointPath.setNodeId(name);
        String description = "Trajectory segment # " + Integer.toString(this.getPaths().size() + 1);
        newWayPointPath.setDescription(description);
        this.getPaths().add((Object)newWayPointPath);
        this.currentWayPointPath = newWayPointPath;
        this.lastPoseAdded = null;
    }

    private void updatePose(Matrix4x4 newPose) {
        try {
            Matrix4d m = newPose.asMatrix4d();
            Vector3d v = new Vector3d();
            m.get(v);
            Point3d position = new Point3d((Tuple3d)v);
            if (this.lastPoseAdded == null) {
                this.addPoint(position);
            } else if (this.getDistanceThreshold() > 0.0) {
                if (this.lastPoseAdded.distance(position) >= this.getDistanceThreshold()) {
                    this.addPoint(position);
                }
            } else {
                this.addPoint(position);
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private void addPoint(Point3d point) {
        CartesianPositionCoordinates coordinates = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point.x, point.y, point.z);
        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.getCurrentWayPointPath(), (EStructuralFeature)ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (Object)coordinates);
        this.lastPoseAdded = new Point3d(point);
        double distance = this.computeTotalDistance();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__TOTAL_DISTANCE, (Object)distance);
    }

    private WayPointPath getCurrentWayPointPath() {
        if (this.currentWayPointPath == null) {
            if (this.getPaths().isEmpty()) {
                this.currentWayPointPath = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__PATHS, (Object)this.currentWayPointPath);
            } else {
                this.currentWayPointPath = (WayPointPath)this.getPaths().get(this.getPaths().size() - 1);
            }
        }
        return this.currentWayPointPath;
    }

    private double computeTotalDistance() {
        double distance = 0.0;
        EList<WayPointPath> paths = this.getPaths();
        for (WayPointPath wayPointPath : paths) {
            distance += wayPointPath.getLength();
        }
        return distance;
    }

    private void updatePoseProvider() {
        ApogySystemApiAdapter apogySystemApiAdapter = this.resolveApogySystemApiAdapter(this.getVariable());
        ApogySystemApiAdapter newPoseProvider = null;
        if (apogySystemApiAdapter != null) {
            ApogySystem apogySystem = apogySystemApiAdapter.getApogySystem();
            if (apogySystem.getPoseProviderInstance() != null) {
                newPoseProvider = apogySystem.getPoseProviderInstance();
            }
        } else {
            newPoseProvider = apogySystemApiAdapter;
        }
        this.setPoseProvider((PoseProvider)newPoseProvider);
        if (this.getPoseProvider() != null) {
            this.lastPoseAdded = null;
            this.currentWayPointPath = null;
            if (this.getPoseProvider().getPoseTransform() != null) {
                this.updatePose(this.getPoseProvider().getPoseTransform());
            }
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.TRAJECTORY3_DTOOL__TOTAL_DISTANCE, (Object)this.computeTotalDistance());
    }

    protected ApogySystemApiAdapter resolveApogySystemApiAdapter(Variable variable) {
        AbstractTypeImplementation abstractTypeImplementation;
        ApogySystemApiAdapter apogySystemApiAdapter = null;
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() != null && variable != null && (abstractTypeImplementation = ApogyCoreInvocatorFacade.INSTANCE.getTypeImplementation(variable)) != null && abstractTypeImplementation.getAdapterInstance() instanceof ApogySystemApiAdapter) {
            apogySystemApiAdapter = (ApogySystemApiAdapter)abstractTypeImplementation.getAdapterInstance();
        }
        return apogySystemApiAdapter;
    }

    protected Adapter getPoseProviderAdapter() {
        if (this.poseProviderAdapter == null) {
            this.poseProviderAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (Trajectory3DToolCustomImpl.this.isActive() && !Trajectory3DToolCustomImpl.this.isDisposed() && msg.getFeatureID(PoseProvider.class) == 0 && Trajectory3DToolCustomImpl.this.isPenDown() && msg.getNewValue() instanceof Matrix4x4) {
                        Matrix4x4 newPose = (Matrix4x4)msg.getNewValue();
                        Trajectory3DToolCustomImpl.this.updatePose(newPose);
                    }
                }
            };
        }
        return this.poseProviderAdapter;
    }

    private VariableAdapter getVariableAdapter() {
        if (this.variableAdapter == null) {
            this.variableAdapter = new VariableAdapter();
        }
        return this.variableAdapter;
    }

    private class VariableAdapter
    extends AdapterImpl {
        private InvocatorSession currentInvocatorSession = null;
        private Environment currentEnvironment = null;
        private Context currentContext = null;

        private VariableAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof ApogyCoreInvocatorFacade) {
                int featureId = msg.getFeatureID(ApogyCoreInvocatorFacade.class);
                switch (featureId) {
                    case 2: {
                        this.setInvocatorSession((InvocatorSession)msg.getNewValue());
                        break;
                    }
                    case 0: {
                        Trajectory3DToolCustomImpl.this.updatePoseProvider();
                        break;
                    }
                }
            } else if (msg.getNotifier() instanceof InvocatorSession) {
                int featureId = msg.getFeatureID(InvocatorSession.class);
                switch (featureId) {
                    case 2: {
                        this.setEnvironment((Environment)msg.getNewValue());
                        break;
                    }
                }
            } else if (msg.getNotifier() instanceof Environment) {
                int featureId = msg.getFeatureID(Environment.class);
                switch (featureId) {
                    case 6: {
                        this.setContext((Context)msg.getNewValue());
                    }
                }
            } else if (msg.getNotifier() instanceof Context) {
                int featureId = msg.getFeatureID(Context.class);
                switch (featureId) {
                    case 6: {
                        Trajectory3DToolCustomImpl.this.updatePoseProvider();
                    }
                }
            }
        }

        public void setInvocatorSession(InvocatorSession newInvocatorSession) {
            if (this.currentInvocatorSession != null) {
                this.currentInvocatorSession.eAdapters().remove((Object)this);
            }
            this.currentInvocatorSession = newInvocatorSession;
            if (this.currentInvocatorSession != null) {
                this.currentInvocatorSession.eAdapters().add((Object)this);
                this.setEnvironment(this.currentInvocatorSession.getEnvironment());
            }
        }

        public void setEnvironment(Environment newEnvironment) {
            if (this.currentEnvironment != null) {
                this.currentEnvironment.eAdapters().remove((Object)this);
            }
            this.setContext(null);
            this.currentEnvironment = newEnvironment;
            if (this.currentEnvironment != null) {
                this.currentEnvironment.eAdapters().add((Object)this);
                this.setContext(this.currentEnvironment.getActiveContext());
            }
        }

        public void setContext(Context newContext) {
            if (this.currentContext != null) {
                this.currentContext.eAdapters().remove((Object)this);
            }
            this.currentContext = newContext;
            if (newContext != null) {
                newContext.eAdapters().add((Object)this);
                Trajectory3DToolCustomImpl.this.updatePoseProvider();
            }
        }
    }
}

