/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.converters.ChainedConverter;
import org.eclipse.apogy.common.converters.ConverterListConverter;
import org.eclipse.apogy.common.converters.IConverter;
import org.eclipse.apogy.common.converters.IFileExporter;

public class ChainedFileExporter
extends ChainedConverter
implements IFileExporter {
    public ChainedFileExporter(List<IConverter> converters) {
        super(converters);
        if (this.getIFileExporter() == null) {
            throw new RuntimeException("No IFileExporter at the end of the conversion chain !");
        }
    }

    @Override
    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        if (this.getIFileExporter() == null) {
            throw new RuntimeException("No IFileExporter at the end of the conversion chain !");
        }
        Object toExport = null;
        ChainedConverter upStreamConverter = this.getUpstreamConverter();
        toExport = upStreamConverter != null ? upStreamConverter.convert(input) : input;
        this.getIFileExporter().exportToFile(toExport, filePath, extensions);
    }

    @Override
    public List<String> getSupportedFileExtensions() {
        IFileExporter iFileExporter = this.getIFileExporter();
        if (iFileExporter != null) {
            return iFileExporter.getSupportedFileExtensions();
        }
        return new ArrayList<String>();
    }

    @Override
    public String getDescription(String fileExtension) {
        IFileExporter iFileExporter = this.getIFileExporter();
        if (iFileExporter != null) {
            return iFileExporter.getDescription(fileExtension);
        }
        return null;
    }

    private ChainedConverter getUpstreamConverter() {
        if (this.converters.size() > 1) {
            ArrayList<IConverter> upstreamConverters = new ArrayList<IConverter>();
            int i = 0;
            while (i < this.converters.size() - 1) {
                upstreamConverters.add((IConverter)this.converters.get(i));
                ++i;
            }
            return new ChainedConverter(upstreamConverters);
        }
        return null;
    }

    private IFileExporter getIFileExporter() {
        IFileExporter iFileExporter = null;
        if (this.converters.size() > 0) {
            IConverter lastConverter = (IConverter)this.converters.get(this.converters.size() - 1);
            if (lastConverter instanceof ConverterListConverter) {
                ConverterListConverter converterListConverter = (ConverterListConverter)lastConverter;
                if (!converterListConverter.converters.isEmpty()) {
                    lastConverter = converterListConverter.converters.get(converterListConverter.converters.size() - 1);
                }
            }
            if (lastConverter instanceof IFileExporter) {
                iFileExporter = (IFileExporter)lastConverter;
            }
        }
        return iFileExporter;
    }
}

