/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEListComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;

public class TimeIntervalListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends AbstractEListComposite<RootEObject, ResolvedEObject, TimeInterval> {
    public static long UPDATE_PERIOD_MS = 1000L;
    private static final int START_TIME_COL_MIN_WIDTH = 200;
    private static final int END_TIME_COL_MIN_WIDTH = 200;
    private static final int DURATION_COL_MIN_WIDTH = 100;
    private DecimalFormat durationFormat = new DecimalFormat("0.0");
    protected boolean currentTimeHighlightEnable = false;
    protected UIJob highlightJob = null;

    public TimeIntervalListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TimeIntervalListComposite.this.setCurrentTimeHighlightEnable(false);
            }
        });
    }

    @Override
    protected void createButtons(Composite parent, int style) {
        this.createExportButton(parent, style);
    }

    @Override
    protected Button createExportButton(Composite parent, int style) {
        Button exportButton = super.createExportButton(parent, style);
        exportButton.setToolTipText("Exports the selected Time Intervals to file.");
        return exportButton;
    }

    @Override
    protected void doExport() {
    }

    @Override
    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn startTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        startTimeTableViewerColumn.getColumn().setText("Start Time");
        startTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        startTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TimeInterval) {
                    TimeInterval timeInterval = (TimeInterval)element;
                    if (timeInterval.getFromDate() != null) {
                        return ApogyCommonEMFFacade.INSTANCE.format(timeInterval.getFromDate());
                    }
                    return "?";
                }
                return "?";
            }

            public Color getBackground(Object element) {
                if (element instanceof TimeInterval) {
                    TimeIntervalListComposite.this.getTimeIntervalBackground((TimeInterval)element);
                }
                return null;
            }
        });
        startTimeTableViewerColumn.getColumn().setWidth(200);
        startTimeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn endTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        endTimeTableViewerColumn.getColumn().setText("End Time");
        endTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        endTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TimeInterval) {
                    TimeInterval timeInterval = (TimeInterval)element;
                    if (timeInterval.getFromDate() != null) {
                        return ApogyCommonEMFFacade.INSTANCE.format(timeInterval.getToDate());
                    }
                    return "?";
                }
                return "?";
            }

            public Color getBackground(Object element) {
                if (element instanceof TimeInterval) {
                    TimeIntervalListComposite.this.getTimeIntervalBackground((TimeInterval)element);
                }
                return null;
            }
        });
        endTimeTableViewerColumn.getColumn().setWidth(200);
        endTimeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn durationTableViewerColumn = new TreeViewerColumn(viewer, 0);
        durationTableViewerColumn.getColumn().setText("Duration (s)");
        durationTableViewerColumn.getColumn().setAlignment(0x1000000);
        durationTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TimeInterval) {
                    TimeInterval timeInterval = (TimeInterval)element;
                    return TimeIntervalListComposite.this.durationFormat.format(0.001 * (double)ApogyCommonEMFFacade.INSTANCE.getDuration(timeInterval));
                }
                return "?";
            }

            public Color getBackground(Object element) {
                if (element instanceof TimeInterval) {
                    TimeIntervalListComposite.this.getTimeIntervalBackground((TimeInterval)element);
                }
                return null;
            }
        });
        durationTableViewerColumn.getColumn().setWidth(100);
        durationTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
    }

    public void setCurrentTimeHighlightEnable(boolean enable) {
        if (enable) {
            this.currentTimeHighlightEnable = true;
            this.getHighlightJob().schedule();
        } else {
            this.currentTimeHighlightEnable = false;
            if (this.highlightJob != null) {
                this.highlightJob.cancel();
                this.highlightJob = null;
            }
        }
    }

    protected Color getTimeIntervalBackground(TimeInterval timeInterval) {
        return null;
    }

    protected UIJob getHighlightJob() {
        if (this.highlightJob == null) {
            this.highlightJob = new UIJob("Active Interval Highlight"){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    while (TimeIntervalListComposite.this.currentTimeHighlightEnable) {
                        TimeIntervalListComposite.this.refreshViewer();
                        if (!TimeIntervalListComposite.this.currentTimeHighlightEnable) continue;
                        try {
                            Thread.sleep(UPDATE_PERIOD_MS);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.highlightJob;
    }
}

