/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.dialogs;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.Dimension;
import javax.measure.unit.NonSI;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.ui.ApogyCommonUiFacade;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SelectUnitDialog
extends Dialog {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private DataBindingContext dataBindingContext;
    private final TreeMap<UnitConverter, String> map;
    private final Number value;
    private final Unit<?> modelUnit;
    private final Unit<?> displayUnit;
    private final Unit<?> standardUnit;
    private final DecimalFormat currentFormat;
    private Unit<?> resultUnit;
    private DecimalFormat resultFormat;
    private TreeViewer nativeUnitsTreeViewer;
    private Text customText;
    private ComboViewer comboNativePrefix;
    private CTabItem tbtmNative;
    private CTabItem tbtmCustom;
    private CTabFolder tabEditorsFolder;
    private Text resultLabel;
    private Text formatText;
    private static final String errorResultMsg = "Unit invalid";

    public SelectUnitDialog(Shell parentShell, Number value, DecimalFormat currentFormat, Unit<?> modelUnit, Unit<?> displayUnit) {
        super(parentShell);
        this.setShellStyle(68688);
        this.currentFormat = currentFormat;
        this.resultFormat = currentFormat;
        this.value = value;
        this.modelUnit = modelUnit;
        this.displayUnit = displayUnit;
        this.standardUnit = displayUnit.getStandardUnit();
        this.map = ApogyCommonEMFUIFacade.INSTANCE.getUnitConverterMap();
    }

    protected void configureShell(Shell shell) {
        shell.setText("Select units");
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SelectUnitDialog.this.dataBindingContext != null) {
                    SelectUnitDialog.this.dataBindingContext.dispose();
                }
                if (SelectUnitDialog.this.toolkit != null) {
                    SelectUnitDialog.this.toolkit.dispose();
                }
            }
        });
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).equalWidth(true).create());
        Section sectionInitialUnit = this.toolkit.createSection(composite, 320);
        this.toolkit.adapt((Composite)sectionInitialUnit);
        sectionInitialUnit.setText("Initial");
        GridData gdData = new GridData(4, 4, true, false, 1, 1);
        sectionInitialUnit.setLayoutData((Object)gdData);
        sectionInitialUnit.setLayout((Layout)new FillLayout());
        Composite initialUnitComposite = new Composite((Composite)sectionInitialUnit, 0);
        initialUnitComposite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        GridLayout initialUnitComposite_gl = new GridLayout(2, false);
        initialUnitComposite_gl.marginHeight = 25;
        initialUnitComposite.setLayout((Layout)initialUnitComposite_gl);
        Label unitText = new Label(initialUnitComposite, 64);
        unitText.setText(String.valueOf(this.currentFormat.format(this.modelUnit.getConverterTo(this.displayUnit).convert(this.value.doubleValue()))) + " " + this.displayUnit.toString());
        unitText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        sectionInitialUnit.setClient((Control)initialUnitComposite);
        Composite unitEditorsComposite = new Composite(composite, 0);
        unitEditorsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        unitEditorsComposite.setLayout((Layout)new FillLayout(256));
        this.tabEditorsFolder = new CTabFolder(unitEditorsComposite, 2048);
        this.tabEditorsFolder.setLayout((Layout)new FillLayout());
        final UpdateResultStrategy test = new UpdateResultStrategy();
        this.tabEditorsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Unit unit = SelectUnitDialog.this.getUnits();
                SelectUnitDialog.this.resultLabel.setText((String)test.convert(unit));
            }
        });
        this.tbtmNative = new CTabItem(this.tabEditorsFolder, 0);
        this.tbtmNative.setText("Native");
        Composite nativeComposite = new Composite((Composite)this.tabEditorsFolder, 0);
        nativeComposite.setLayout((Layout)new GridLayout(2, false));
        nativeComposite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.nativeUnitsTreeViewer = new TreeViewer(nativeComposite, 67586);
        Tree tree = this.nativeUnitsTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeViewerColumn treeViewerUnitColumn = new TreeViewerColumn(this.nativeUnitsTreeViewer, 0);
        TreeColumn treeclmnUnit = treeViewerUnitColumn.getColumn();
        treeclmnUnit.setWidth(100);
        treeclmnUnit.setText("Unit");
        TreeViewerColumn treeViewerValueColumn = new TreeViewerColumn(this.nativeUnitsTreeViewer, 0);
        TreeColumn treeclmnValue = treeViewerValueColumn.getColumn();
        treeclmnValue.setWidth(100);
        treeclmnValue.setText("Value");
        this.nativeUnitsTreeViewer.setLabelProvider((IBaseLabelProvider)new NativeUnitsLabelProvider());
        this.nativeUnitsTreeViewer.setContentProvider((IContentProvider)new NativeUnitsContentProvider());
        this.nativeUnitsTreeViewer.setInput(this.modelUnit);
        ApogyCommonUiFacade.INSTANCE.addExpandOnDoubleClick(this.nativeUnitsTreeViewer);
        this.nativeUnitsTreeViewer.expandAll();
        treeclmnUnit.pack();
        treeclmnValue.pack();
        if (!this.standardUnit.getDimension().equals((Object)Dimension.NONE)) {
            Label prefixLabel = new Label(nativeComposite, 64);
            prefixLabel.setBackground(this.getShell().getDisplay().getSystemColor(37));
            prefixLabel.setText("Prefix");
            prefixLabel.setLayoutData((Object)new GridData(0x1000000, 4, false, false, 1, 1));
            this.comboNativePrefix = new ComboViewer(nativeComposite, 0);
            GridData gd_comboNativePrefix = new GridData(4, 128, false, false, 1, 1);
            this.comboNativePrefix.getCombo().setLayoutData((Object)gd_comboNativePrefix);
            this.comboNativePrefix.setLabelProvider((IBaseLabelProvider)new PrefixesLabelProvider());
            this.comboNativePrefix.setContentProvider((IContentProvider)new PrefixesContentProvider());
            this.comboNativePrefix.setInput(this.map);
        }
        this.tbtmNative.setControl((Control)nativeComposite);
        this.tbtmCustom = new CTabItem(this.tabEditorsFolder, 0);
        this.tbtmCustom.setText("Custom");
        List<Unit<?>> patternUnits = this.getPattern(this.standardUnit, null);
        Composite customComposite = new Composite((Composite)this.tabEditorsFolder, 0);
        customComposite.setBackground(Display.getCurrent().getSystemColor(1));
        customComposite.setLayout((Layout)new GridLayout(1, false));
        if (patternUnits.size() > 0) {
            Section compositeUnitSection = this.toolkit.createSection(customComposite, 320);
            this.toolkit.adapt((Composite)compositeUnitSection);
            compositeUnitSection.setText("Standard Composition");
            compositeUnitSection.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            compositeUnitSection.setLayout((Layout)new GridLayout());
            Composite compositeCompositeUnits = new Composite((Composite)compositeUnitSection, 0);
            compositeCompositeUnits.setLayoutData((Object)new GridData(0x1000000, 4, true, true, 1, 1));
            compositeCompositeUnits.setBackground(Display.getCurrent().getSystemColor(1));
            compositeCompositeUnits.setBackgroundMode(2);
            compositeCompositeUnits.setLayout((Layout)new GridLayout(patternUnits.size() * 2, false));
            for (Unit<?> patternUnit : patternUnits) {
                Composite compositeChooseUnit = new Composite(compositeCompositeUnits, 0);
                compositeChooseUnit.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true, 1, 1));
                compositeChooseUnit.setLayout((Layout)new GridLayout(2, false));
                Label standardUnitLabel = new Label(compositeChooseUnit, 0);
                standardUnitLabel.setText(patternUnit.toString());
                standardUnitLabel.setLayoutData((Object)new GridData(0x1000000, 4, false, false, 2, 1));
                if (patternUnits.indexOf(patternUnit) == patternUnits.size() - 1) continue;
                Label powerLabel = new Label(compositeCompositeUnits, 0);
                powerLabel.setText("*");
                powerLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            }
            compositeUnitSection.setClient((Control)compositeCompositeUnits);
        }
        Section customEntrySection = this.toolkit.createSection(customComposite, 320);
        this.toolkit.adapt((Composite)customEntrySection);
        customEntrySection.setText("Entry");
        customEntrySection.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        customEntrySection.setLayout((Layout)new FillLayout());
        Composite customEntryComposite = new Composite((Composite)customEntrySection, 0);
        customEntryComposite.setLayout((Layout)new GridLayout(2, false));
        customEntryComposite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.customText = new Text(customEntryComposite, 2048);
        this.customText.setText(this.displayUnit.toString());
        this.customText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Button infoButton = new Button(customEntryComposite, 0);
        infoButton.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jface", (String)"/icons/full/message_info.png");
        infoButton.setImage(image.createImage());
        infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message = "Examples of valid entries (all for meters per second squared) are:\n   - m*s-2\n   - m/s\u00b2\n   - m\u00b7s-\u00b2\n   - m*s**-2\n   - m^+1 s^-2\n\nPrefixes can only be placed in front of standard units.";
                MessageDialog.openInformation((Shell)SelectUnitDialog.this.getShell(), (String)"Synthax", (String)message);
            }
        });
        customEntrySection.setClient((Control)customEntryComposite);
        Section informationsSection = this.toolkit.createSection(customComposite, 320);
        this.toolkit.adapt((Composite)informationsSection);
        informationsSection.setText("Available units");
        informationsSection.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        informationsSection.setLayout((Layout)new GridLayout());
        Composite compositeInformations = new Composite((Composite)informationsSection, 0);
        compositeInformations.setLayout((Layout)new GridLayout(2, true));
        compositeInformations.setBackground(this.getShell().getDisplay().getSystemColor(1));
        TreeViewer prefixesTreeViewer = new TreeViewer(compositeInformations, 2048);
        Tree prefixesTree = prefixesTreeViewer.getTree();
        GridData test123 = new GridData(4, 4, true, true, 1, 1);
        test123.heightHint = 150;
        prefixesTree.setLayoutData((Object)test123);
        prefixesTree.setHeaderVisible(true);
        prefixesTree.setLinesVisible(true);
        TreeViewerColumn treeViewerPrefixColumn = new TreeViewerColumn(prefixesTreeViewer, 0);
        TreeColumn treeclmnPrefix = treeViewerPrefixColumn.getColumn();
        treeclmnPrefix.setWidth(50);
        treeclmnPrefix.setText("Prefix");
        TreeViewerColumn treeViewerPrefixFactorColumn = new TreeViewerColumn(prefixesTreeViewer, 0);
        TreeColumn treeclmnPrefixFactor = treeViewerPrefixFactorColumn.getColumn();
        treeclmnPrefixFactor.setWidth(100);
        treeclmnPrefixFactor.setText("Factor");
        prefixesTreeViewer.setLabelProvider((IBaseLabelProvider)new PrefixesTreeLabelProvider());
        prefixesTreeViewer.setContentProvider((IContentProvider)new PrefixesTreeContentProvider());
        prefixesTreeViewer.setInput(this.map);
        TreeViewer nativeUnitsTreeViewer = new TreeViewer(compositeInformations, 2560);
        Tree nativeTree = nativeUnitsTreeViewer.getTree();
        GridData gd_nativeUnits = new GridData(4, 4, true, true, 1, 1);
        gd_nativeUnits.heightHint = 150;
        nativeTree.setLayoutData((Object)gd_nativeUnits);
        nativeTree.setHeaderVisible(true);
        nativeTree.setLinesVisible(true);
        ApogyCommonUiFacade.INSTANCE.addExpandOnDoubleClick(nativeUnitsTreeViewer);
        TreeViewerColumn treeNativeUnitsColumn = new TreeViewerColumn(nativeUnitsTreeViewer, 0);
        TreeColumn treeclmnNativeUnits = treeNativeUnitsColumn.getColumn();
        treeclmnNativeUnits.setWidth(50);
        treeclmnNativeUnits.setText("Units");
        nativeUnitsTreeViewer.setLabelProvider((IBaseLabelProvider)new NativeUnitsListLabelProvider());
        nativeUnitsTreeViewer.setContentProvider((IContentProvider)new NativeUnitsListContentProvider());
        nativeUnitsTreeViewer.setInput((Object)"");
        informationsSection.setClient((Control)compositeInformations);
        this.tbtmCustom.setControl((Control)customComposite);
        CTabItem tbtmFormat = new CTabItem(this.tabEditorsFolder, 0);
        tbtmFormat.setText("Format");
        Composite formatComposite = new Composite((Composite)this.tabEditorsFolder, 0);
        GridLayout formatComposite_gl = new GridLayout(3, false);
        formatComposite_gl.marginHeight = 15;
        formatComposite.setLayout((Layout)formatComposite_gl);
        formatComposite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        formatComposite.setBackgroundMode(2);
        Label formatLabel = new Label(formatComposite, 0);
        formatLabel.setText(String.valueOf(this.value.getClass().getSimpleName()) + " : ");
        formatLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.formatText = new Text(formatComposite, 2048);
        this.formatText.setText(this.currentFormat.toPattern());
        this.formatText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.formatText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SelectUnitDialog.this.verifyFormat()) {
                    SelectUnitDialog.this.resultFormat = new DecimalFormat(SelectUnitDialog.this.formatText.getText());
                } else {
                    SelectUnitDialog.this.resultFormat = SelectUnitDialog.this.currentFormat;
                }
            }
        });
        Button infoFormatButton = new Button(formatComposite, 0);
        infoFormatButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        infoFormatButton.setImage(image.createImage());
        infoFormatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message = "0\trepresents a digit\n#\trepresents a digit, zero shows as absent\n.\trepresents a placeholder for decimal separator\n,\trepresents a placeholder for grouping separator\n\nExamples with input 123123.123:\n\t- 000000000.000000 : " + new DecimalFormat("000000000.000000").format(123123.123) + "\n\t- #########.###### : " + new DecimalFormat("#########.######").format(123123.123) + "\n\t- ###,###.### : " + new DecimalFormat("###,###.###").format(123123.123);
                MessageDialog.openInformation((Shell)SelectUnitDialog.this.getShell(), (String)"Synthax", (String)message);
            }
        });
        tbtmFormat.setControl((Control)formatComposite);
        this.tabEditorsFolder.setSelection(this.tbtmNative);
        Section sectionPreview = this.toolkit.createSection(composite, 320);
        this.toolkit.adapt((Composite)sectionPreview);
        sectionPreview.setText("Result");
        sectionPreview.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        sectionPreview.setLayout((Layout)new FillLayout());
        Composite previewComposite = new Composite((Composite)sectionPreview, 0);
        previewComposite.setBackground(Display.getCurrent().getSystemColor(1));
        previewComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout previewComposite_gl = new GridLayout(1, false);
        previewComposite_gl.marginHeight = 25;
        previewComposite.setLayout((Layout)previewComposite_gl);
        this.resultLabel = new Text(previewComposite, 0x1000040);
        this.resultLabel.setText("Preview");
        this.resultLabel.setEditable(false);
        this.resultLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.resultLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectUnitDialog.this.resultLabel.requestLayout();
            }
        });
        sectionPreview.setClient((Control)previewComposite);
        this.dataBindingContext = this.initDataBindings();
        return composite;
    }

    private DataBindingContext initDataBindings() {
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
        }
        this.dataBindingContext = new DataBindingContext();
        ISWTObservableValue observeResultLabelText = WidgetProperties.text().observe((Widget)this.resultLabel);
        IViewerObservableValue observeNativeTreeViewerSelection = ViewerProperties.singleSelection().observe((Viewer)this.nativeUnitsTreeViewer);
        ISWTObservableValue observeCustomTextText = WidgetProperties.text((int)24).observe((Widget)this.customText);
        ISWTObservableValue observeFormatTextText = WidgetProperties.text((int)24).observe((Widget)this.formatText);
        this.dataBindingContext.bindValue((IObservableValue)observeResultLabelText, (IObservableValue)observeNativeTreeViewerSelection, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new UpdateResultStrategy());
        this.dataBindingContext.bindValue((IObservableValue)observeResultLabelText, (IObservableValue)observeCustomTextText, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new UpdateResultStrategy());
        this.dataBindingContext.bindValue((IObservableValue)observeResultLabelText, (IObservableValue)observeFormatTextText, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new UpdateResultStrategy());
        if (this.comboNativePrefix != null) {
            IViewerObservableValue observeComboSelection = ViewerProperties.singleSelection().observe((Viewer)this.comboNativePrefix);
            this.dataBindingContext.bindValue((IObservableValue)observeResultLabelText, (IObservableValue)observeComboSelection, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new UpdateResultStrategy());
        }
        ISWTObservableValue observeFormatTextBackground = WidgetProperties.background().observe((Widget)this.formatText);
        this.dataBindingContext.bindValue((IObservableValue)observeFormatTextBackground, (IObservableValue)observeFormatTextText, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, Color.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return SelectUnitDialog.this.verifyFormat() ? SelectUnitDialog.this.getShell().getDisplay().getSystemColor(37) : SelectUnitDialog.this.getShell().getDisplay().getSystemColor(3);
                }
                return SelectUnitDialog.this.getShell().getDisplay().getSystemColor(3);
            }
        }));
        return this.dataBindingContext;
    }

    private boolean verifyFormat() {
        String text = this.formatText.getText();
        if ("".equals(text)) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            char character = text.charAt(i);
            if (character != '0' && character != '.' && character != '#' && character != ',') {
                return false;
            }
            ++i;
        }
        try {
            new DecimalFormat(text);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Unit<?> getUnits() {
        if (this.tabEditorsFolder.getSelection() == this.tbtmNative) {
            this.resultUnit = this.nativeUnitsTreeViewer.getSelection() != null && this.nativeUnitsTreeViewer.getStructuredSelection().getFirstElement() instanceof Unit ? (Unit)this.nativeUnitsTreeViewer.getStructuredSelection().getFirstElement() : this.displayUnit;
            if (this.comboNativePrefix != null && this.comboNativePrefix.getStructuredSelection() != null && this.comboNativePrefix.getStructuredSelection().getFirstElement() instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)this.comboNativePrefix.getStructuredSelection().getFirstElement();
                this.resultUnit = this.modelUnit.transform((UnitConverter)entry.getKey());
            }
        } else if (this.tabEditorsFolder.getSelection() == this.tbtmCustom) {
            try {
                Object object = UnitFormat.getInstance().parseObject(this.customText.getText());
                this.resultUnit = object instanceof Unit ? (Unit)object : null;
            }
            catch (Exception exception) {
                this.resultUnit = null;
            }
        }
        if (this.resultUnit != null && this.resultUnit.isCompatible(this.standardUnit)) {
            return this.resultUnit;
        }
        return null;
    }

    public Unit<?> getResultUnit() {
        return this.resultUnit;
    }

    public DecimalFormat getResultFormat() {
        return this.resultFormat;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private List<Unit<?>> getPattern(Unit<?> unit, List<Unit<?>> list) {
        Unit systemUnit;
        List<Unit<?>> objects = list;
        if (objects == null) {
            objects = new ArrayList();
        }
        if ((systemUnit = unit.getStandardUnit()) instanceof ProductUnit) {
            ProductUnit productUnit = (ProductUnit)systemUnit;
            int i = 0;
            while (i < productUnit.getUnitCount()) {
                Unit unit2 = productUnit.getUnit(i);
                if (unit2.getStandardUnit() instanceof ProductUnit) {
                    objects.addAll(this.getPattern(unit2.getStandardUnit(), list));
                } else {
                    objects.add(unit2.pow(productUnit.getUnitPow(i)).root(productUnit.getUnitRoot(i)));
                }
                ++i;
            }
        } else if (systemUnit instanceof BaseUnit) {
            objects.add(systemUnit);
        } else if (systemUnit instanceof AlternateUnit) {
            objects.addAll(this.getPattern(((AlternateUnit)systemUnit).getParent(), list));
        }
        return objects;
    }

    private List<Unit<?>> getCompatibleUnits(Unit<?> unit, Set<Unit<?>> list) {
        ArrayList units = new ArrayList();
        if (unit instanceof ProductUnit && ((ProductUnit)unit).getUnitCount() < 1) {
            return units;
        }
        Unit stdUnit = unit.getStandardUnit();
        for (Unit<?> unit2 : list) {
            int power = 1;
            if (stdUnit instanceof ProductUnit && ((ProductUnit)stdUnit).getUnitCount() > 0) {
                power = ((ProductUnit)stdUnit).getUnitPow(0);
            }
            if (unit2.getStandardUnit().equals((Object)stdUnit) && !units.contains(unit2)) {
                units.add(unit2);
                continue;
            }
            if (!unit2.getStandardUnit().pow(power).equals((Object)stdUnit) || units.contains(unit2.pow(power))) continue;
            units.add(unit2.pow(power));
        }
        return units;
    }

    private class NativeUnitsContentProvider
    implements ITreeContentProvider {
        private static final String SI_STRING = "SI";
        private static final String NON_SI_STRING = "Non-SI";
        private static final String EMPTY = "No unit available";

        private NativeUnitsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{SI_STRING, NON_SI_STRING};
        }

        public Object[] getChildren(Object parentElement) {
            List SIunits = SelectUnitDialog.this.getCompatibleUnits(SelectUnitDialog.this.standardUnit, SI.getInstance().getUnits());
            List NonSIunits = SelectUnitDialog.this.getCompatibleUnits(SelectUnitDialog.this.standardUnit, NonSI.getInstance().getUnits());
            if (SIunits.isEmpty() && NonSIunits.isEmpty()) {
                Unit stdUnit = SelectUnitDialog.this.modelUnit.getStandardUnit();
                if (SI.getInstance().getUnits().contains(stdUnit)) {
                    SIunits.add(stdUnit);
                }
                if (!SIunits.contains(SelectUnitDialog.this.modelUnit)) {
                    NonSIunits.add(SelectUnitDialog.this.modelUnit);
                }
                if (!SIunits.contains(SelectUnitDialog.this.displayUnit) && !NonSIunits.contains(SelectUnitDialog.this.displayUnit)) {
                    NonSIunits.add(SelectUnitDialog.this.displayUnit);
                }
            }
            return SI_STRING.equals(parentElement) ? SIunits.toArray() : NonSIunits.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String ? !((String)element).equals(EMPTY) : false;
        }
    }

    private class NativeUnitsLabelProvider
    extends CellLabelProvider {
        private final int UNIT_NAME_COLUMN = 0;
        private final int VALUE_COLUMN = 1;

        private NativeUnitsLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof String) {
                if (cell.getColumnIndex() == 0) {
                    cell.setText((String)element);
                } else {
                    cell.setText("");
                }
            } else if (element instanceof Unit) {
                Unit unitElement = (Unit)element;
                switch (cell.getColumnIndex()) {
                    case 0: {
                        if (unitElement.toString() == null) break;
                        cell.setText(unitElement.toString());
                        break;
                    }
                    case 1: {
                        UnitConverter converter = SelectUnitDialog.this.modelUnit.getConverterTo(unitElement);
                        if (converter == null || SelectUnitDialog.this.value == null) break;
                        cell.setText(Double.toString(converter.convert(SelectUnitDialog.this.value.doubleValue())));
                        break;
                    }
                }
            }
        }
    }

    private class NativeUnitsListContentProvider
    implements ITreeContentProvider {
        private NativeUnitsListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Unit> siUnits = new ArrayList<Unit>();
            for (Unit unit : SI.getInstance().getUnits()) {
                if (siUnits.contains(unit.getStandardUnit())) continue;
                siUnits.add(unit.getStandardUnit());
            }
            for (Unit unit : NonSI.getInstance().getUnits()) {
                if (siUnits.contains(unit.getStandardUnit())) continue;
                if (!unit.getStandardUnit().toString().equals("")) {
                    siUnits.add(unit.getStandardUnit());
                    continue;
                }
                siUnits.add(unit);
            }
            return siUnits.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (((Unit)parentElement).getStandardUnit() == parentElement) {
                HashSet units = new HashSet(SI.getInstance().getUnits());
                units.addAll(NonSI.getInstance().getUnits());
                List unitsList = SelectUnitDialog.this.getCompatibleUnits((Unit)parentElement, units);
                unitsList.remove(parentElement);
                return unitsList.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }
    }

    private class NativeUnitsListLabelProvider
    extends CellLabelProvider {
        private NativeUnitsListLabelProvider() {
        }

        public void update(ViewerCell cell) {
            cell.setText(cell.getElement().toString());
        }
    }

    private class PrefixesContentProvider
    implements IStructuredContentProvider {
        private PrefixesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return SelectUnitDialog.this.map.entrySet().toArray();
        }
    }

    private class PrefixesLabelProvider
    extends ColumnLabelProvider {
        private PrefixesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                return String.valueOf((String)entry.getValue()) + " (" + ((UnitConverter)entry.getKey()).convert(1.0) + ")";
            }
            return "";
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    private class PrefixesTreeContentProvider
    implements ITreeContentProvider {
        private PrefixesTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return SelectUnitDialog.this.map.entrySet().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class PrefixesTreeLabelProvider
    extends CellLabelProvider {
        private final int PREFIX_COLUMN = 0;
        private final int FACTOR_COLUMN = 1;

        private PrefixesTreeLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)cell.getElement();
                switch (cell.getColumnIndex()) {
                    case 0: {
                        cell.setText((String)entry.getValue());
                        break;
                    }
                    case 1: {
                        cell.setText(Double.toString(((UnitConverter)entry.getKey()).convert(1.0)));
                        break;
                    }
                }
                cell.setImage(null);
            }
        }
    }

    private class UpdateResultStrategy
    extends UpdateValueStrategy {
        public UpdateResultStrategy() {
            super(UpdateValueStrategy.POLICY_UPDATE);
            this.setConverter((IConverter)new Converter(Object.class, String.class){

                public Object convert(Object fromObject) {
                    Unit unit = SelectUnitDialog.this.getUnits();
                    if (SelectUnitDialog.this.getButton(0) != null) {
                        SelectUnitDialog.this.getButton(0).setEnabled(unit != null);
                    }
                    String label = SelectUnitDialog.errorResultMsg;
                    if (unit != null) {
                        label = unit.toString();
                        if (SelectUnitDialog.this.value != null) {
                            label = SelectUnitDialog.this.resultFormat.format(SelectUnitDialog.this.modelUnit.getConverterTo(unit).convert(SelectUnitDialog.this.value.doubleValue())).concat(" " + label);
                        }
                    }
                    return label;
                }
            });
        }
    }
}

