/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.asc.converters;

import java.io.File;
import java.net.URL;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.asc.ASC3DIO;
import org.eclipse.apogy.common.geometry.data3d.asc.AltitudeMode;
import org.eclipse.apogy.common.geometry.data3d.converters.URLToCartesianTriangularMeshConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLASCToCartesianTriangularMeshConverter
extends URLToCartesianTriangularMeshConverter {
    private static final Logger Logger = LoggerFactory.getLogger(URLASCToCartesianTriangularMeshConverter.class);
    private static String[] fileExtensions = new String[]{".asc"};

    public Class<?> getOutputType() {
        return CartesianTriangularMesh.class;
    }

    public Class<?> getInputType() {
        return URL.class;
    }

    public boolean canConvert(Object input) {
        return super.canConvert(input);
    }

    public String[] getSupportedFileExtension() {
        return fileExtensions;
    }

    public Object convert(Object input) throws Exception {
        CartesianTriangularMesh mesh = null;
        try {
            URL url = (URL)input;
            File tempFileASC = this.copyURLContent(url);
            mesh = ASC3DIO.INSTANCE.loadTriangularMesh(tempFileASC.getAbsolutePath(), AltitudeMode.ABSOLUTE);
            if (mesh != null) {
                Logger.info("Sucessfully loaded CartesianTriangularMesh from URL<" + url + ">.");
            } else {
                Logger.error("Could not load CartesianTriangularMesh from URL<" + url + ">.");
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        return mesh;
    }
}

