/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.apogy.common.geometry.data.Coordinates;
import org.eclipse.apogy.common.geometry.data.Mesh;
import org.eclipse.apogy.common.geometry.data.Polygon;
import org.eclipse.apogy.common.geometry.data.impl.MeshImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;

public class MeshCustomImpl<CoordinatesType extends Coordinates, PolygonType extends Polygon<CoordinatesType>>
extends MeshImpl<CoordinatesType, PolygonType> {
    private Map<CoordinatesType, List<PolygonType>> pointToPolygonsMap;
    private Adapter adapter;

    protected MeshCustomImpl() {
        this.eAdapters().add((Object)this.getAdapter());
    }

    @Override
    public EList<PolygonType> getPolygons() {
        if (this.polygons == null) {
            this.polygons = new EObjectContainmentEList<PolygonType>(Polygon.class, (InternalEObject)this, 2){

                protected boolean isUnique() {
                    return false;
                }
            };
        }
        return this.polygons;
    }

    @Override
    public EList<PolygonType> getPolygonNeighbours(PolygonType polygon) {
        UniqueEList neighbours = new UniqueEList();
        for (Coordinates triangleVertex : polygon.getVertices()) {
            List<PolygonType> polygons = this.getPointToPolygonsMap().get(triangleVertex);
            for (Polygon currentPolygon : polygons) {
                if (currentPolygon == polygon) continue;
                neighbours.add((Object)currentPolygon);
            }
        }
        return neighbours;
    }

    @Override
    public EList<CoordinatesType> getPointNeighbours(CoordinatesType point) {
        List<PolygonType> polygons = this.getPointToPolygonsMap().get(point);
        UniqueEList points = new UniqueEList();
        for (Polygon polygon : polygons) {
            for (Coordinates tPoint : polygon.getVertices()) {
                if (tPoint == point) continue;
                points.add((Object)tPoint);
            }
        }
        return points;
    }

    @Override
    public EList<PolygonType> getPolygonsSharingPoint(CoordinatesType point) {
        UniqueEList polygons = new UniqueEList();
        List<PolygonType> list = this.getPointToPolygonsMap().get(point);
        if (list != null) {
            polygons.addAll(list);
        }
        return polygons;
    }

    private void polygonAdded(PolygonType polygon) {
        for (Coordinates point : polygon.getVertices()) {
            List<Object> polygons = null;
            if (!this.getPointToPolygonsMap().containsKey(point)) {
                polygons = new LinkedList();
                this.getPointToPolygonsMap().put(point, polygons);
            } else {
                polygons = this.getPointToPolygonsMap().get(point);
            }
            polygons.add(polygon);
        }
    }

    private void polygonRemoved(PolygonType polygon) {
        int numberOfVertices = polygon.getVertices().size();
        int i = 0;
        while (i < numberOfVertices) {
            List<PolygonType> polygons = this.getPointToPolygonsMap().get(polygon.getVertices().get(i));
            polygons.remove(polygon);
            ++i;
        }
    }

    private void pointRemoved(CoordinatesType point) {
        List<PolygonType> polygonsAffected = this.getPointToPolygonsMap().get(point);
        for (Polygon polygon : polygonsAffected) {
            this.getPolygons().remove((Object)polygon);
        }
        this.getPointToPolygonsMap().remove(point);
    }

    protected Map<CoordinatesType, List<PolygonType>> getPointToPolygonsMap() {
        if (this.pointToPolygonsMap == null) {
            this.pointToPolygonsMap = new WeakHashMap<CoordinatesType, List<PolygonType>>();
            for (Polygon polygon : this.getPolygons()) {
                this.polygonAdded(polygon);
            }
        }
        return this.pointToPolygonsMap;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof Mesh) {
            Mesh mesh = (Mesh)obj;
            boolean bl = equals = mesh.getPolygons().size() == this.getPolygons().size();
            if (equals) {
                int i = 0;
                while (i < mesh.getPolygons().size() && equals) {
                    Polygon pSource = (Polygon)mesh.getPolygons().get(i);
                    Polygon pTarget = (Polygon)this.getPolygons().get(i);
                    boolean bl2 = equals = pSource.getVertices().size() == pTarget.getVertices().size();
                    if (equals) {
                        int j = 0;
                        while (j < pSource.getVertices().size() && equals) {
                            equals = ((Coordinates)pSource.getVertices().get(j)).equals(pTarget.getVertices().get(j));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return equals;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new Adapter(){

                public Notifier getTarget() {
                    return null;
                }

                public boolean isAdapterForType(Object type) {
                    return false;
                }

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(Mesh.class) == 2) {
                        if (notification.getEventType() == 3 || notification.getEventType() == 5) {
                            MeshCustomImpl.this.pointToPolygonsMap = null;
                        } else if ((notification.getEventType() == 4 || notification.getEventType() == 6) && notification.getOldValue() != null) {
                            if (notification.getNewValue() instanceof List) {
                                List polygons = (List)notification.getOldValue();
                                for (Polygon polygon : polygons) {
                                    MeshCustomImpl.this.polygonRemoved(polygon);
                                }
                            } else if (notification.getOldValue() instanceof Polygon) {
                                Polygon polygon = (Polygon)notification.getOldValue();
                                MeshCustomImpl.this.polygonRemoved(polygon);
                            }
                        }
                    }
                    if (notification.getFeatureID(Mesh.class) == 0 && (notification.getEventType() == 4 || notification.getEventType() == 6) && notification.getNewValue() != null && notification.getNewValue() instanceof List) {
                        List pointsRemoved = (List)notification.getNewValue();
                        for (Coordinates point : pointsRemoved) {
                            MeshCustomImpl.this.pointRemoved(point);
                        }
                    }
                }

                public void setTarget(Notifier newTarget) {
                }
            };
        }
        return this.adapter;
    }

    protected void finalize() throws Throwable {
        if (this.adapter != null) {
            this.eAdapters().remove((Object)this.adapter);
        }
        super.finalize();
    }
}

