/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.scene_objects;

import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.primitives.PointLight;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointLightJME3SceneObject
extends DefaultJME3SceneObject<PointLight> {
    private static final Logger Logger = LoggerFactory.getLogger(PointLightJME3SceneObject.class);
    private Adapter adapter;
    private UpdateAppState updateAppState = null;
    public static float DEFAULT_POINT_LIGHT_RADIUS = 10.0f;
    private final AssetManager assetManager = this.jme3Application.getAssetManager();
    private com.jme3.light.PointLight pointLight;

    public PointLightJME3SceneObject(PointLight topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)topologyNode, jme3RenderEngineDelegate);
        this.jme3Application.getStateManager().attach((AppState)this.getUpdateAppState());
        this.requestUpdate();
        topologyNode.eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.pointLight == null) {
            this.getPointLight();
        }
        if (((PointLight)this.getTopologyNode()).isEnabled()) {
            this.jme3Application.getRootNode().addLight((Light)this.pointLight);
        } else {
            this.jme3Application.getRootNode().removeLight((Light)this.pointLight);
        }
    }

    public void setVisible(final boolean visible) {
        super.setVisible(visible);
        Logger.info("PointLightJME3SceneObject.setVisible() " + ((PointLight)this.getTopologyNode()).getNodeId());
        if (this.pointLight != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (visible) {
                        if (!PointLightJME3SceneObject.this.jme3Application.getRootNode().getChildren().contains(PointLightJME3SceneObject.this.pointLight)) {
                            PointLightJME3SceneObject.this.jme3Application.getRootNode().addLight((Light)PointLightJME3SceneObject.this.pointLight);
                        }
                    } else {
                        PointLightJME3SceneObject.this.jme3Application.getRootNode().removeLight((Light)PointLightJME3SceneObject.this.pointLight);
                    }
                    return null;
                }
            });
        }
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((PointLight)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        this.jme3Application.getStateManager().detach((AppState)this.getUpdateAppState());
        if (this.pointLight != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    PointLightJME3SceneObject.this.jme3Application.getRootNode().removeLight((Light)PointLightJME3SceneObject.this.pointLight);
                    return null;
                }
            });
        }
        super.dispose();
    }

    public void setLightRadius(final float radius) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                PointLightJME3SceneObject.this.getPointLight().setRadius(radius);
                return null;
            }
        });
    }

    public void setLightColor(RGBA color) {
        final ColorRGBA lightColor = JME3Utilities.convertToColorRGBA((RGBA)color);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                PointLightJME3SceneObject.this.getPointLight().setColor(lightColor);
                return null;
            }
        });
    }

    private com.jme3.light.PointLight getPointLight() {
        if (this.pointLight == null) {
            this.pointLight = new com.jme3.light.PointLight();
            this.pointLight.setColor(ColorRGBA.White);
            this.pointLight.setRadius(((PointLight)this.getTopologyNode()).getRadius());
            Vector3f lightPosition = new Vector3f();
            if (this.getTopologyNode() != null) {
                Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(this.getTopologyNode());
                Vector3d position = new Vector3d();
                m.get(position);
                lightPosition = new Vector3f((float)position.x, (float)position.y, (float)position.z);
            }
            this.pointLight.setPosition(lightPosition);
            if (((PointLight)this.getTopologyNode()).getNodeId() != null) {
                this.pointLight.setName(((PointLight)this.getTopologyNode()).getNodeId());
            }
        }
        return this.pointLight;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof PointLight) {
                        int featureID = msg.getFeatureID(PointLight.class);
                        switch (featureID) {
                            case 4: {
                                PointLightJME3SceneObject.this.setVisible(msg.getNewBooleanValue());
                                break;
                            }
                            case 6: {
                                if (!(msg.getNewFloatValue() >= 0.0f)) break;
                                PointLightJME3SceneObject.this.setLightRadius(msg.getNewFloatValue());
                                break;
                            }
                            case 5: {
                                if (!(msg.getNewValue() instanceof RGBA)) break;
                                PointLightJME3SceneObject.this.setLightColor((RGBA)msg.getNewValue());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    protected UpdateAppState getUpdateAppState() {
        if (this.updateAppState == null) {
            this.updateAppState = new UpdateAppState();
        }
        return this.updateAppState;
    }

    private class UpdateAppState
    extends AbstractAppState {
        private final Node root;

        public UpdateAppState() {
            this.root = ApogyCommonTopologyFacade.INSTANCE.findRoot(PointLightJME3SceneObject.this.getTopologyNode());
        }

        public void update(float tpf) {
            Matrix4d newPose = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(PointLightJME3SceneObject.this.getTopologyNode(), this.root);
            if (newPose != null && newPose != null) {
                Vector3d pos = new Vector3d();
                newPose.get(pos);
                PointLightJME3SceneObject.this.getPointLight().setPosition(new Vector3f((float)pos.x, (float)pos.y, (float)pos.z));
            }
            super.update(tpf);
        }
    }
}

