/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.preferences;

import org.eclipse.apogy.common.topology.addons.primitives.ui.Activator;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TopologyPrimitivesUIPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor circularSectorFOVBooleanFieldEditor;
    private BooleanFieldEditor circularSectorFOVVisibilityBooleanFieldEditor;
    private RadioGroupFieldEditor circularSectorFOVRadioGroupFieldEditor;
    private ColorFieldEditor circularSectorFOVColorFieldEditor;
    private BooleanFieldEditor circularSectorAxisVisibleBooleanFieldEditor;

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        Group grpCircularSectorFov = new Group(container, 0);
        grpCircularSectorFov.setLayout((Layout)new GridLayout(2, true));
        grpCircularSectorFov.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        grpCircularSectorFov.setText("Spot Light");
        Label circularSectorFOVVisibilityLabel = new Label((Composite)grpCircularSectorFov, 0);
        circularSectorFOVVisibilityLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        circularSectorFOVVisibilityLabel.setText("Visibility");
        this.circularSectorFOVBooleanFieldEditor = this.createBooleanFieldEditor((Composite)grpCircularSectorFov, "DEFAULT_SPOT_LIGHT_VISIBILITY_ID", "");
        Label circularSectorFOVFOVVisibilityLabel = new Label((Composite)grpCircularSectorFov, 0);
        circularSectorFOVFOVVisibilityLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        circularSectorFOVFOVVisibilityLabel.setText("Light Cone Visibility");
        this.circularSectorFOVVisibilityBooleanFieldEditor = this.createBooleanFieldEditor((Composite)grpCircularSectorFov, "DEFAULT_SPOT_LIGHT_LIGHT_CONE_VISIBILITY_ID", "");
        Label circularSectorAxisLabel = new Label((Composite)grpCircularSectorFov, 0);
        circularSectorAxisLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        circularSectorAxisLabel.setText("Axis Visible");
        this.circularSectorAxisVisibleBooleanFieldEditor = this.createBooleanFieldEditor((Composite)grpCircularSectorFov, "DEFAULT_SPOT_LIGHT_AXIS_VISIBLE_ID", "");
        this.circularSectorFOVColorFieldEditor = this.createColorFieldEditor((Composite)grpCircularSectorFov, "DEFAULT_SPOT_LIGHT_LIGHT_CONE_COLOR_ID", "Default Color:");
        Label circularSectorFOVModeLabel = new Label((Composite)grpCircularSectorFov, 0);
        circularSectorFOVModeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        circularSectorFOVModeLabel.setText("Presentation Mode:");
        this.circularSectorFOVRadioGroupFieldEditor = this.createRadioGroupFieldEditor((Composite)grpCircularSectorFov, "DEFAULT_SPOT_LIGHT_LIGHT_CONE_PRESENTATION_MODE_ID", "");
        return container;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        this.circularSectorFOVBooleanFieldEditor.loadDefault();
        this.circularSectorFOVVisibilityBooleanFieldEditor.loadDefault();
        this.circularSectorFOVRadioGroupFieldEditor.loadDefault();
        this.circularSectorFOVColorFieldEditor.loadDefault();
        this.circularSectorAxisVisibleBooleanFieldEditor.loadDefault();
        super.performDefaults();
    }

    private String[][] getModeLabelsAndValues() {
        String[][] labelAndValues = new String[MeshPresentationMode.VALUES.size()][2];
        int i = 0;
        for (MeshPresentationMode value : MeshPresentationMode.VALUES) {
            labelAndValues[i][0] = value.getName();
            labelAndValues[i][1] = Integer.toString(value.getValue());
            ++i;
        }
        return labelAndValues;
    }

    private BooleanFieldEditor createBooleanFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        BooleanFieldEditor editor = new BooleanFieldEditor(preferenceID, preferenceLabel, container);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private RadioGroupFieldEditor createRadioGroupFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        Composite editorContainer = new Composite(container, 0);
        editorContainer.setLayout((Layout)new GridLayout(1, true));
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor(preferenceID, preferenceLabel, 1, this.getModeLabelsAndValues(), editorContainer, false);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private ColorFieldEditor createColorFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        ColorFieldEditor colorEditor = new ColorFieldEditor(preferenceID, preferenceLabel, container);
        colorEditor.setPreferenceStore(this.getPreferenceStore());
        colorEditor.load();
        return colorEditor;
    }

    private void storePreferences() {
        this.circularSectorFOVBooleanFieldEditor.store();
        this.circularSectorFOVVisibilityBooleanFieldEditor.store();
        this.circularSectorFOVRadioGroupFieldEditor.store();
        this.circularSectorFOVColorFieldEditor.store();
        this.circularSectorAxisVisibleBooleanFieldEditor.store();
    }
}

