/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.adapters;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFactory;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.GraphicsContextAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopoFileGraphicsContextAdapter
implements GraphicsContextAdapter {
    private static final Logger Logger = LoggerFactory.getLogger(TopoFileGraphicsContextAdapter.class);
    private static final String SUPPORTED_EXTENSION = ".topo";

    @Override
    public boolean isAdapterFor(Object obj) {
        boolean adapterFor = false;
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            adapterFor = file.getName().endsWith(SUPPORTED_EXTENSION);
        }
        return adapterFor;
    }

    @Override
    public GraphicsContext getAdapter(Object obj, Object context) {
        GraphicsContext ctx = null;
        if (this.isAdapterFor(obj)) {
            ctx = ApogyCommonTopologyUIFactory.eINSTANCE.createGraphicsContext();
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (context instanceof IProgressMonitor) {
                monitor = (IProgressMonitor)context;
            }
            IFile file = (IFile)obj;
            monitor.beginTask("Importing", 1);
            monitor.subTask("Loading file " + file.getName());
            XMIResourceImpl res = new XMIResourceImpl(URI.createFileURI((String)file.getLocation().toOSString()));
            try {
                res.load(Collections.EMPTY_MAP);
                EObject eObject = (EObject)res.getContents().get(0);
                monitor.worked(1);
                if (eObject instanceof GroupNode) {
                    GroupNode root = (GroupNode)eObject;
                    ctx.setTopology((Node)root);
                }
                monitor.done();
            }
            catch (IOException e) {
                monitor.done();
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return ctx;
    }

    @Override
    public Class<?> getAdaptedClass() {
        return IFile.class;
    }
}

