/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.composites;

import java.util.ArrayList;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.EditingDomainsValidity;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractECollectionContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsETreeComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyTreeComposite<RootEObject extends EObject>
extends EMFFormsETreeComposite<RootEObject, Node, Node> {
    private static final Logger Logger = LoggerFactory.getLogger(TopologyTreeComposite.class);

    public TopologyTreeComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    public TopologyTreeComposite(Composite parent, int style) {
        super(parent, style, null, null);
    }

    public void select(ISelection selection) {
        this.getViewer().setSelection(selection);
        this.getViewer().refresh();
    }

    protected void createNewButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (this.getViewer().getStructuredSelection().size() > 0) {
                return this.getViewer().getStructuredSelection().getFirstElement() instanceof GroupNode;
            }
            return true;
        });
    }

    protected void doNew() {
        Node parent = null;
        parent = !this.getSelectedItemObjects().isEmpty() ? (Node)this.getSelectedItemObjects().get(0) : (Node)this.getResolvedEObject();
        if (parent != null) {
            EObjectWizard wizard = new EObjectWizard((EObject)parent, null, ApogyCommonTopologyPackage.Literals.GROUP_NODE__CHILDREN, null);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    protected void doDelete(Node node) {
        if (node != null) {
            if (ApogyCommonTransactionFacade.INSTANCE.areEditingDomainsValid(node.eContainer(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.GROUP_NODE__CHILDREN, (Object)node, false) == EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN) {
                try {
                    ApogyCommonTransactionFacade.INSTANCE.basicRemove(node.eContainer(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.GROUP_NODE__CHILDREN, (Object)node);
                }
                catch (Exception e) {
                    Logger.error("Unable to delete the Node <" + node.getNodeId() + ">.", (Throwable)e);
                }
            } else {
                try {
                    ApogyCommonTransactionFacade.INSTANCE.basicRemove(node.eContainer(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.GROUP_NODE__CHILDREN, (Object)node, true);
                }
                catch (Exception e) {
                    Logger.error("Unable to delete the Node <" + node.getNodeId() + ">.", (Throwable)e);
                }
            }
        }
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractECollectionContentProvider(adapterFactory){

            public Object[] getChildren(Object object) {
                Object[] children = super.getChildren(object);
                ArrayList<Node> nodes = new ArrayList<Node>();
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof Node) {
                        nodes.add((Node)obj);
                    }
                    ++n2;
                }
                return nodes.toArray();
            }

            public boolean hasChildren(Object object) {
                if (object instanceof GroupNode) {
                    GroupNode groupNode = (GroupNode)object;
                    return !groupNode.getChildren().isEmpty();
                }
                return false;
            }

            public EStructuralFeature getEStructuralFeature() {
                return ApogyCommonTopologyPackage.Literals.AGGREGATE_GROUP_NODE__AGGREGATED_CHILDREN;
            }
        };
    }
}

