/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.util;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.PositionNode;
import org.eclipse.apogy.common.topology.RotationNode;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class NodeRelativePoseListener {
    private Adapter adapter = null;
    private final List<Node> nodes = new ArrayList<Node>();
    private final double minimumDistanceDeltaMeters = 1.0E-6;
    private final double minimumOrientationDeltaRad = 0.01;
    private Matrix4d previousPose = null;
    private Matrix4d newPose = null;
    private Node fromNode;
    private Node toNode;

    public void relativePoseChanged(Matrix4d newPose) {
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public void setFromNode(Node fromNode) {
        if (this.fromNode != fromNode) {
            this.fromNode = fromNode;
            this.updateNodeList();
            this.relativePoseChanged(this.computeNewPose());
        }
    }

    public Node getToNode() {
        return this.toNode;
    }

    public void setToNode(Node toNode) {
        this.toNode = toNode;
        this.updateNodeList();
        this.relativePoseChanged(this.computeNewPose());
    }

    public Matrix4d getNewPose() {
        return this.newPose;
    }

    public void dispose() {
        this.unregisterAdapter();
        this.fromNode = null;
        this.toNode = null;
        this.adapter = null;
    }

    private boolean hasPoseChanged(Matrix4d newPose, Matrix4d newPreviousPose) {
        boolean result = false;
        if (this.previousPose == null) {
            if (newPose != null) {
                this.previousPose = new Matrix4d(newPose);
            }
            result = true;
        } else if (newPose != null && this.previousPose != null) {
            if (!result) {
                Vector3d previousPosition = new Vector3d();
                Vector3d newPosition = new Vector3d();
                this.previousPose.get(previousPosition);
                newPose.get(newPosition);
                newPosition.sub((Tuple3d)previousPosition);
                if (newPosition.length() > 1.0E-6) {
                    result = true;
                }
            }
            if (!result) {
                Matrix3d previousRot = new Matrix3d();
                Matrix3d newRot = new Matrix3d();
                this.previousPose.get(previousRot);
                newPose.get(newRot);
                Vector3d previousOrientation = new Vector3d(1.0, 0.0, 0.0);
                Vector3d newOrientation = new Vector3d(1.0, 0.0, 0.0);
                previousRot.transform((Tuple3d)previousOrientation);
                newRot.transform((Tuple3d)newOrientation);
                if (Math.abs(previousOrientation.angle(newOrientation)) > 0.01) {
                    result = true;
                }
            }
        }
        if (newPose != null) {
            this.previousPose = new Matrix4d(newPose);
        } else {
            this.previousPose = new Matrix4d();
            this.previousPose.setIdentity();
        }
        return result;
    }

    private void updatePose(Matrix4d newPose) {
        if (this.hasPoseChanged(newPose, this.previousPose)) {
            this.newPose = newPose;
            this.relativePoseChanged(newPose);
        }
    }

    private void updateNodeList() {
        this.unregisterAdapter();
        this.nodes.clear();
        if (this.fromNode != null && this.toNode != null) {
            Node currentNode = this.fromNode;
            while (currentNode != null) {
                if ((currentNode instanceof PositionNode || currentNode instanceof RotationNode) && !this.nodes.contains(currentNode)) {
                    this.nodes.add(currentNode);
                }
                currentNode = currentNode.getParent();
            }
            currentNode = this.toNode;
            while (currentNode != null) {
                if ((currentNode instanceof PositionNode || currentNode instanceof RotationNode) && !this.nodes.contains(currentNode)) {
                    this.nodes.add(currentNode);
                }
                currentNode = currentNode.getParent();
            }
        }
        this.registerAdapter();
    }

    private void registerAdapter() {
        for (Node node : this.nodes) {
            node.eAdapters().add((Object)this.getAdapter());
        }
    }

    private void unregisterAdapter() {
        for (Node node : this.nodes) {
            node.eAdapters().remove((Object)this.getAdapter());
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof TransformNode) {
                        int featureId = msg.getFeatureID(TransformNode.class);
                        if (featureId == 6 || featureId == 7) {
                            NodeRelativePoseListener.this.updatePose(NodeRelativePoseListener.this.computeNewPose());
                        } else if (featureId == 2) {
                            NodeRelativePoseListener.this.updateNodeList();
                            NodeRelativePoseListener.this.updatePose(NodeRelativePoseListener.this.computeNewPose());
                        }
                    } else if (msg.getNotifier() instanceof PositionNode) {
                        int featureId = msg.getFeatureID(PositionNode.class);
                        if (featureId == 6) {
                            NodeRelativePoseListener.this.updatePose(NodeRelativePoseListener.this.computeNewPose());
                        } else if (featureId == 2) {
                            NodeRelativePoseListener.this.updateNodeList();
                            NodeRelativePoseListener.this.updatePose(NodeRelativePoseListener.this.computeNewPose());
                        }
                    } else if (msg.getNotifier() instanceof RotationNode) {
                        int featureId = msg.getFeatureID(RotationNode.class);
                        if (featureId == 6) {
                            NodeRelativePoseListener.this.updatePose(NodeRelativePoseListener.this.computeNewPose());
                        } else if (featureId == 2) {
                            NodeRelativePoseListener.this.updateNodeList();
                            NodeRelativePoseListener.this.updatePose(NodeRelativePoseListener.this.computeNewPose());
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    protected Matrix4d computeNewPose() {
        if (this.fromNode != null && this.toNode != null) {
            return ApogyCommonTopologyFacade.INSTANCE.expressInFrame(this.fromNode, this.toNode);
        }
        return null;
    }
}

