/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.birt.composites;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.apogy.common.ui.birt.composites.AbstractBIRTChartComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBIRTChartCompositeRegistry {
    public static long DEFAULT_UPDATE_PERIOD_MS = 500L;
    private static AbstractBIRTChartCompositeRegistry singleton;
    private static final Logger Logger;
    private List<AbstractBIRTChartComposite> registeredComposites = new ArrayList<AbstractBIRTChartComposite>();
    private UIJob uiJob = null;
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private Lock readLock = this.rwLock.readLock();
    private Lock writeLock = this.rwLock.writeLock();

    static {
        Logger = LoggerFactory.getLogger(AbstractBIRTChartCompositeRegistry.class);
    }

    private AbstractBIRTChartCompositeRegistry() {
        this.getUiJob().schedule();
    }

    public static AbstractBIRTChartCompositeRegistry getSingleton() {
        if (singleton == null) {
            singleton = new AbstractBIRTChartCompositeRegistry();
        }
        return singleton;
    }

    public void registerAbstractBIRTChartComposite(AbstractBIRTChartComposite composite) {
        this.writeLock.lock();
        try {
            this.registeredComposites.add(composite);
            Logger.debug("Registered a new AbstractBIRTChartComposite. Currently managing <" + this.registeredComposites.size() + "> clients.");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void unregisterAbstractBIRTChartComposite(AbstractBIRTChartComposite composite) {
        this.writeLock.lock();
        try {
            this.registeredComposites.remove((Object)composite);
            Logger.debug("Un-Registered one AbstractBIRTChartComposite. Currently managing <" + this.registeredComposites.size() + "> clients.");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private UIJob getUiJob() {
        if (this.uiJob == null) {
            this.uiJob = new UIJob("AbstractBIRTChartCompositeRegistry Update."){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    AbstractBIRTChartCompositeRegistry.this.readLock.lock();
                    try {
                        for (AbstractBIRTChartComposite composite : AbstractBIRTChartCompositeRegistry.this.registeredComposites) {
                            if (composite.isDisposed()) continue;
                            try {
                                composite.updateValuesAndChart();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    finally {
                        AbstractBIRTChartCompositeRegistry.this.readLock.unlock();
                    }
                    this.schedule(DEFAULT_UPDATE_PERIOD_MS);
                    return Status.OK_STATUS;
                }
            };
        }
        return this.uiJob;
    }
}

