/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.planner.AbstractResourceCostFunctionState;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ApogyCoreEnvironmentEarthOrbitPlannerFactory;
import org.eclipse.apogy.core.environment.earth.orbit.planner.CostFunctionState;
import org.eclipse.apogy.core.environment.earth.orbit.planner.impl.AbstractResourceCostFunctionImpl;

public abstract class AbstractResourceCostFunctionCustomImpl<State extends AbstractResourceCostFunctionState>
extends AbstractResourceCostFunctionImpl<State> {
    private OrbitAnalysisData orbitAnalysisData;

    @Override
    public void initialize(OrbitAnalysisData orbitAnalysisData) {
        this.orbitAnalysisData = orbitAnalysisData;
    }

    @Override
    public double computeCost(CostFunctionState previousState, CostFunctionState nextState, VisibilityPass pass) {
        AbstractResourceCostFunctionState before = (AbstractResourceCostFunctionState)previousState;
        AbstractResourceCostFunctionState after = (AbstractResourceCostFunctionState)nextState;
        double beforeResourceLevel = 0.0;
        beforeResourceLevel = before == null ? this.getInitialResourceValue() : before.getResourceValue();
        double afterResourceLevel = beforeResourceLevel + this.computeTargetVisibilityPassResourceImpact(pass);
        List<VisibilityPass> applicableGroundStationPasses = this.getApplicableGroundStationPasses((AbstractResourceCostFunctionState)previousState, pass);
        for (VisibilityPass groundStationPass : applicableGroundStationPasses) {
            afterResourceLevel += this.computeGroundStationVisibilityPassResourceImpact(groundStationPass);
        }
        if (afterResourceLevel > this.getMaximumResourceValue()) {
            afterResourceLevel = this.getMaximumResourceValue();
        }
        after.getProcessedGroundStationVisibilityPasses().addAll(applicableGroundStationPasses);
        after.setResourceValue(afterResourceLevel);
        if (afterResourceLevel < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public CostFunctionState createState() {
        AbstractResourceCostFunctionState state = ApogyCoreEnvironmentEarthOrbitPlannerFactory.eINSTANCE.createAbstractResourceCostFunctionState();
        return state;
    }

    protected List<VisibilityPass> getApplicableGroundStationPasses(AbstractResourceCostFunctionState previousState, VisibilityPass pass) {
        ArrayList<VisibilityPass> applicablePasses = new ArrayList<VisibilityPass>();
        for (VisibilityPass groundStationPass : this.orbitAnalysisData.getResult().getGroundStationVisibilityPasses()) {
            if (groundStationPass.getSpacecraft() != pass.getSpacecraft() || previousState != null && previousState.getProcessedGroundStationVisibilityPasses().contains((Object)groundStationPass) || groundStationPass.getFromDate().getTime() >= pass.getToDate().getTime()) continue;
            applicablePasses.add(groundStationPass);
        }
        return applicablePasses;
    }
}

