/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.apogy.common.ui.birt.composites.ValueVsTimeBIRTChartComposite;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractVisibilityPassSpacecraftPositionHistoryValueVsTimeComposite<RootEObject extends EObject>
extends AbstractEObjectComposite<RootEObject, VisibilityPassSpacecraftPositionHistory, VisibilityPassSpacecraftPositionHistory> {
    protected VisibilityPassSpacecraftPositionHistory positionHistory;
    protected ValueVsTimeBIRTChartComposite valueVsTimeBIRTChartComposite;
    private RGB plotBackgroundColor;
    private RGB plotGridColor;
    private RGB xAxisColor;
    private RGB yAxisColor;
    private RGB seriesColor;

    public AbstractVisibilityPassSpacecraftPositionHistoryValueVsTimeComposite(Composite parent, int style) {
        super(parent, style, null, null);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        this.valueVsTimeBIRTChartComposite = this.createValueVsTimeBIRTChartComposite(parent, style);
        this.valueVsTimeBIRTChartComposite.setPlotBackgroundColor(this.getPlotBackgroundColor());
        this.valueVsTimeBIRTChartComposite.setPlotGridColor(this.getPlotGridColor());
        this.valueVsTimeBIRTChartComposite.setXAxisColor(this.getxAxisColor());
        this.valueVsTimeBIRTChartComposite.setYAxisColor(this.getyAxisColor());
        this.valueVsTimeBIRTChartComposite.setHistorySize(500);
        this.valueVsTimeBIRTChartComposite.setHistoryTimeLength(-1);
        return this.valueVsTimeBIRTChartComposite;
    }

    protected void rootEObjectChanged(RootEObject rootEObject) {
        this.updateDisplayedValues((VisibilityPassSpacecraftPositionHistory)this.getResolvedEObject());
    }

    public RGB getPlotBackgroundColor() {
        if (this.plotBackgroundColor == null) {
            this.plotBackgroundColor = new RGB(0, 0, 0);
        }
        return this.plotBackgroundColor;
    }

    public RGB getPlotGridColor() {
        if (this.plotGridColor == null) {
            this.plotGridColor = new RGB(0, 255, 0);
        }
        return this.plotGridColor;
    }

    public RGB getxAxisColor() {
        if (this.xAxisColor == null) {
            this.xAxisColor = new RGB(0, 255, 0);
        }
        return this.xAxisColor;
    }

    public RGB getyAxisColor() {
        if (this.yAxisColor == null) {
            this.yAxisColor = new RGB(0, 255, 0);
        }
        return this.yAxisColor;
    }

    public RGB getSeriesColor() {
        if (this.seriesColor == null) {
            this.seriesColor = new RGB(255, 255, 0);
        }
        return this.seriesColor;
    }

    public Unit<?> getDisplayUnits() {
        ETypedElement eTypedElement = this.getDisplayedETypedElement();
        if (eTypedElement != null) {
            return ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(eTypedElement);
        }
        return null;
    }

    public Unit<?> getNativeUnits() {
        ETypedElement eTypedElement = this.getDisplayedETypedElement();
        if (eTypedElement != null) {
            return ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(eTypedElement);
        }
        return null;
    }

    protected abstract ETypedElement getDisplayedETypedElement();

    protected abstract ValueVsTimeBIRTChartComposite createValueVsTimeBIRTChartComposite(Composite var1, int var2);

    protected double convertToDisplayedValue(double nativeUnitsValue) {
        Unit<?> displayUnits = this.getDisplayUnits();
        Unit<?> nativeUnits = this.getNativeUnits();
        if (displayUnits != null && nativeUnits != null) {
            return nativeUnits.getConverterTo(displayUnits).convert(nativeUnitsValue);
        }
        return nativeUnitsValue;
    }

    protected void updateDisplayedValues(VisibilityPassSpacecraftPositionHistory positionHistory) {
        List<Date> dates = null;
        List<Double> yValues = null;
        if (positionHistory != null) {
            dates = this.createTimeAxisValues(positionHistory);
            yValues = this.createYAxisValues(positionHistory);
        } else {
            dates = new ArrayList<Date>();
            dates.add(new Date());
            yValues = new ArrayList<Double>();
            yValues.add(new Double(0.0));
        }
        this.valueVsTimeBIRTChartComposite.updateValues(dates, yValues);
    }

    protected List<Date> createTimeAxisValues(VisibilityPassSpacecraftPositionHistory positionHistory) {
        ArrayList<Date> timeValues = new ArrayList<Date>();
        for (VisibilityPassSpacecraftPosition position : positionHistory.getPositions()) {
            timeValues.add(position.getTime());
        }
        return timeValues;
    }

    protected List<Double> createYAxisValues(VisibilityPassSpacecraftPositionHistory positionHistory) {
        ArrayList<Double> rangeValues = new ArrayList<Double>();
        for (VisibilityPassSpacecraftPosition position : positionHistory.getPositions()) {
            double nativeValue = ((Number)position.eGet((EStructuralFeature)this.getDisplayedETypedElement())).doubleValue();
            double convertedValue = this.convertToDisplayedValue(nativeValue);
            rangeValues.add(convertedValue);
        }
        return rangeValues;
    }
}

