/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.FormatProvider;
import org.eclipse.apogy.common.emf.ui.SimpleFormatProvider;
import org.eclipse.apogy.common.emf.ui.SimpleUnitsProvider;
import org.eclipse.apogy.common.emf.ui.UnitsProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;

public class VisibilityPassSpacecraftPositionHistoryComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, VisibilityPassSpacecraftPositionHistory> {
    public static final String DEGREE_STRING = "\u00b0";
    private final int TIME_COL_MIN_WIDTH = 100;
    private final int AZIMUTH_COL_MIN_WIDTH = 90;
    private final int ELEVATION_COL_MIN_WIDTH = 110;
    private final int RANGE_COL_MIN_WIDTH = 90;
    private final int RANGE_RATE_COL_MIN_WIDTH = 140;
    private final int CROSS_TRACK_ANGLE_COL_MIN_WIDTH = 150;
    private final int ALONG_TRACK_ANGLE_COL_MIN_WIDTH = 130;

    public VisibilityPassSpacecraftPositionHistoryComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void configure(TreeViewer viewer) {
        viewer.getTree().setHeaderVisible(true);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn timeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        timeTableViewerColumn.getColumn().setText("Time");
        timeTableViewerColumn.getColumn().setAlignment(0x1000000);
        timeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof VisibilityPassSpacecraftPosition) {
                    VisibilityPassSpacecraftPosition position = (VisibilityPassSpacecraftPosition)element;
                    if (position.getTime() != null) {
                        return ApogyCommonEMFFacade.INSTANCE.format(position.getTime());
                    }
                    return "?";
                }
                return "";
            }
        });
        timeTableViewerColumn.getColumn().setWidth(100);
        timeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        Unit azimuthDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__AZIMUTH);
        TreeViewerColumn azimuthTableViewerColumn = new TreeViewerColumn(viewer, 0);
        azimuthTableViewerColumn.getColumn().setText("Azimuth (" + azimuthDisplayedUnits.toString() + ")");
        azimuthTableViewerColumn.getColumn().setAlignment(0x1000000);
        azimuthTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof VisibilityPassSpacecraftPosition) {
                    VisibilityPassSpacecraftPosition position = (VisibilityPassSpacecraftPosition)element;
                    return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)position.getAzimuth(), (ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__AZIMUTH);
                }
                return "";
            }
        });
        azimuthTableViewerColumn.getColumn().setWidth(90);
        azimuthTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)90);
        Unit elevationDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__ELEVATION);
        TreeViewerColumn elevationTableViewerColumn = new TreeViewerColumn(viewer, 0);
        elevationTableViewerColumn.getColumn().setText("Elevation (" + elevationDisplayedUnits.toString() + ")");
        elevationTableViewerColumn.getColumn().setAlignment(0x1000000);
        elevationTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof VisibilityPassSpacecraftPosition) {
                    VisibilityPassSpacecraftPosition position = (VisibilityPassSpacecraftPosition)element;
                    return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)position.getElevation(), (ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__ELEVATION);
                }
                return "";
            }
        });
        elevationTableViewerColumn.getColumn().setWidth(110);
        elevationTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)110);
        SimpleUnitsProvider unitsProvider = ApogyCommonEMFUIFactory.eINSTANCE.createSimpleUnitsProvider();
        unitsProvider.setUnit(Unit.valueOf((CharSequence)"km"));
        ApogyCommonEMFUIFacade.INSTANCE.addUnitsProviderToRegistry((ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__RANGE, (UnitsProvider)unitsProvider);
        SimpleFormatProvider formatProvider = ApogyCommonEMFUIFactory.eINSTANCE.createSimpleFormatProvider();
        formatProvider.setFormatPattern("0.0");
        ApogyCommonEMFUIFacade.INSTANCE.addFormatProviderToRegistry((ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__RANGE, (FormatProvider)formatProvider);
        Unit rangeDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__RANGE);
        TreeViewerColumn rangeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        rangeTableViewerColumn.getColumn().setText("Range (" + rangeDisplayedUnits.toString() + ")");
        rangeTableViewerColumn.getColumn().setAlignment(0x1000000);
        rangeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof VisibilityPassSpacecraftPosition) {
                    VisibilityPassSpacecraftPosition position = (VisibilityPassSpacecraftPosition)element;
                    return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)position.getRange(), (ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__RANGE);
                }
                return "";
            }
        });
        rangeTableViewerColumn.getColumn().setWidth(90);
        rangeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)90);
        Unit rangeRateDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__RANGE_RATE);
        TreeViewerColumn rangeRateTableViewerColumn = new TreeViewerColumn(viewer, 0);
        rangeRateTableViewerColumn.getColumn().setText("Range Rate (" + rangeRateDisplayedUnits.toString() + ")");
        rangeRateTableViewerColumn.getColumn().setAlignment(0x1000000);
        rangeRateTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof VisibilityPassSpacecraftPosition) {
                    VisibilityPassSpacecraftPosition position = (VisibilityPassSpacecraftPosition)element;
                    return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)position.getRangeRate(), (ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__RANGE_RATE);
                }
                return "";
            }
        });
        rangeRateTableViewerColumn.getColumn().setWidth(140);
        rangeRateTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)140);
        Unit crossTrackDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__CROSS_TRACK_ANGLE);
        TreeViewerColumn spacecraftCrossTrackAngleTableViewerColumn = new TreeViewerColumn(viewer, 0);
        spacecraftCrossTrackAngleTableViewerColumn.getColumn().setText("Cross Track Angle (" + crossTrackDisplayedUnits.toString() + ")");
        spacecraftCrossTrackAngleTableViewerColumn.getColumn().setAlignment(0x1000000);
        spacecraftCrossTrackAngleTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof VisibilityPassSpacecraftPosition) {
                    VisibilityPassSpacecraftPosition position = (VisibilityPassSpacecraftPosition)element;
                    return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)position.getCrossTrackAngle(), (ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__CROSS_TRACK_ANGLE);
                }
                return "";
            }
        });
        spacecraftCrossTrackAngleTableViewerColumn.getColumn().setWidth(150);
        spacecraftCrossTrackAngleTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        Unit alongTrackDisplayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__ALONG_TRACK_ANGLE);
        TreeViewerColumn spacecraftAlongTrackAngleTableViewerColumn = new TreeViewerColumn(viewer, 0);
        spacecraftAlongTrackAngleTableViewerColumn.getColumn().setText("Along Track Angle (" + alongTrackDisplayedUnits.toString() + ")");
        spacecraftAlongTrackAngleTableViewerColumn.getColumn().setAlignment(0x1000000);
        spacecraftAlongTrackAngleTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof VisibilityPassSpacecraftPosition) {
                    VisibilityPassSpacecraftPosition position = (VisibilityPassSpacecraftPosition)element;
                    return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)position.getAlongTrackAngle(), (ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION__ALONG_TRACK_ANGLE);
                }
                return "";
            }
        });
        spacecraftAlongTrackAngleTableViewerColumn.getColumn().setWidth(130);
        spacecraftAlongTrackAngleTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)130);
    }
}

