/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.ui.wizards.ExportToFileWizard;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEListComposite;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.apogy.core.environment.earth.orbit.ui.composites.VisibilityPassSpacecraftPositionHistoryComposite;
import org.eclipse.apogy.core.environment.earth.orbit.ui.composites.VisibilityPassSpacecraftPositionHistoryDetailsComposite;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class VisibilityPassesListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends AbstractEListComposite<RootEObject, ResolvedEObject, VisibilityPass> {
    private static final int ORBIT_MODEL_COL_MIN_WIDTH = 100;
    private static final int LOCATION_COL_MIN_WIDTH = 100;
    private static final int DURATION_COL_MIN_WIDTH = 100;
    private static final int START_TIME_COL_MIN_WIDTH = 200;
    private static final int END_TIME_COL_MIN_WIDTH = 200;
    private DecimalFormat durationFormat = new DecimalFormat("0.0");
    private VisibilityPassSpacecraftPositionHistoryComposite<VisibilityPass, VisibilityPass> visibilityPassSpacecraftPositionHistoryComposite;
    private VisibilityPassSpacecraftPositionHistoryDetailsComposite<VisibilityPass> visibilityPassSpacecraftPositionHistoryDetailsComposite;

    public VisibilityPassesListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createExportButton(parent, style);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            this.visibilityPassSpacecraftPositionHistoryComposite.setRootEObject((EObject)((VisibilityPass)this.getSelectedItemObjects().get(0)));
            this.visibilityPassSpacecraftPositionHistoryDetailsComposite.setRootEObject((EObject)((VisibilityPass)this.getSelectedItemObjects().get(0)));
        } else {
            this.visibilityPassSpacecraftPositionHistoryComposite.setRootEObject(null);
            this.visibilityPassSpacecraftPositionHistoryDetailsComposite.setRootEObject(null);
        }
    }

    protected Button createExportButton(Composite parent, int style) {
        Button exportButton = super.createExportButton(parent, style);
        exportButton.setToolTipText("Exports the selected Visibility pass to file.");
        return exportButton;
    }

    protected void doExport() {
        for (VisibilityPass pass : this.getSelectedItemObjects()) {
            VisibilityPassSpacecraftPositionHistory positionHistory = pass.getPositionHistory();
            if (positionHistory == null) continue;
            IFileExporter iFileExporter = ApogyCommonConvertersFacade.INSTANCE.getIFileExporter((Object)positionHistory);
            ExportToFileWizard wizard = new ExportToFileWizard(iFileExporter, (Object)positionHistory);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    protected void createColumns(TreeViewer viewer) {
        this.createOrbitModelTableColumn(viewer);
        TreeViewerColumn outlookTableViewerColumn = new TreeViewerColumn(viewer, 0);
        outlookTableViewerColumn.getColumn().setText("Location");
        outlookTableViewerColumn.getColumn().setAlignment(0x1000000);
        outlookTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                if (visibilityPass != null) {
                    if (visibilityPass.getOutlook() != null) {
                        if (visibilityPass.getOutlook().getName() != null) {
                            return visibilityPass.getOutlook().getName();
                        }
                        return "?";
                    }
                    return "?";
                }
                return "";
            }
        });
        outlookTableViewerColumn.getColumn().setWidth(100);
        outlookTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn durationTableViewerColumn = new TreeViewerColumn(viewer, 0);
        durationTableViewerColumn.getColumn().setText("Duration (s)");
        durationTableViewerColumn.getColumn().setAlignment(0x1000000);
        durationTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                return VisibilityPassesListComposite.this.durationFormat.format(0.001 * (double)ApogyCommonEMFFacade.INSTANCE.getDuration((TimeInterval)visibilityPass));
            }
        });
        durationTableViewerColumn.getColumn().setWidth(100);
        durationTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn startTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        startTimeTableViewerColumn.getColumn().setText("Start Time");
        startTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        startTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                if (visibilityPass.getFromDate() != null) {
                    return ApogyCommonEMFFacade.INSTANCE.format(visibilityPass.getFromDate());
                }
                return "?";
            }
        });
        startTimeTableViewerColumn.getColumn().setWidth(200);
        startTimeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn endTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        endTimeTableViewerColumn.getColumn().setText("End Time");
        endTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        endTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                if (visibilityPass.getFromDate() != null) {
                    return ApogyCommonEMFFacade.INSTANCE.format(visibilityPass.getToDate());
                }
                return "?";
            }
        });
        endTimeTableViewerColumn.getColumn().setWidth(200);
        endTimeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
    }

    protected Composite createDetailComposite(Composite parent, int style) {
        final FormToolkit formToolkit = new FormToolkit(Display.getCurrent());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                formToolkit.dispose();
            }
        });
        Composite top = new Composite(parent, style);
        top.setLayout((Layout)new GridLayout(1, false));
        Section sctnPositionHistory = formToolkit.createSection(top, 258);
        sctnPositionHistory.setLayout((Layout)new FillLayout());
        formToolkit.paintBordersFor((Composite)sctnPositionHistory);
        sctnPositionHistory.setText("Position History");
        sctnPositionHistory.setLayoutData((Object)new GridData(4, 4, false, false));
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setButtonsSectionDisplayed(false);
        settings.setDetailSectionDisplayed(false);
        this.visibilityPassSpacecraftPositionHistoryComposite = new VisibilityPassSpacecraftPositionHistoryComposite((Composite)sctnPositionHistory, 0, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS__POSITION_HISTORY}), (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION_HISTORY__POSITIONS, settings);
        this.visibilityPassSpacecraftPositionHistoryComposite.setLayoutData(new GridData(4, 4, false, false));
        formToolkit.adapt(this.visibilityPassSpacecraftPositionHistoryComposite);
        formToolkit.paintBordersFor(this.visibilityPassSpacecraftPositionHistoryComposite);
        sctnPositionHistory.setClient(this.visibilityPassSpacecraftPositionHistoryComposite);
        Section sctnVisibilityPassDetails = formToolkit.createSection(top, 322);
        formToolkit.paintBordersFor((Composite)sctnVisibilityPassDetails);
        sctnVisibilityPassDetails.setText("Plots");
        this.visibilityPassSpacecraftPositionHistoryDetailsComposite = new VisibilityPassSpacecraftPositionHistoryDetailsComposite((Composite)sctnVisibilityPassDetails, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS__POSITION_HISTORY}), null);
        formToolkit.adapt(this.visibilityPassSpacecraftPositionHistoryDetailsComposite);
        formToolkit.paintBordersFor(this.visibilityPassSpacecraftPositionHistoryDetailsComposite);
        sctnVisibilityPassDetails.setClient(this.visibilityPassSpacecraftPositionHistoryDetailsComposite);
        return top;
    }

    protected void createOrbitModelTableColumn(TreeViewer tableViewer) {
        TreeViewerColumn orbitModelTableViewerColumn = new TreeViewerColumn(tableViewer, 0);
        orbitModelTableViewerColumn.getColumn().setText("Spacecraft");
        orbitModelTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass visibilityPass = VisibilityPassesListComposite.this.getVisibilityPass(element);
                if (visibilityPass.getSpacecraft() != null) {
                    if (visibilityPass.getSpacecraft().getName() != null) {
                        return visibilityPass.getSpacecraft().getName();
                    }
                    return "?";
                }
                return "?";
            }
        });
        orbitModelTableViewerColumn.getColumn().setWidth(100);
        orbitModelTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
    }

    protected VisibilityPass getVisibilityPass(Object element) {
        return (VisibilityPass)element;
    }
}

