/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisResult;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIPackage;
import org.eclipse.apogy.core.environment.earth.orbit.ui.VisibilityPassWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.AllVisibilityPassesWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.swt.graphics.RGBA;

public class AllVisibilityPassesWorldWindLayerCustomImpl
extends AllVisibilityPassesWorldWindLayerImpl {
    private boolean initialized = false;
    private Adapter orbitAnalysisDataAdapter;
    private Adapter orbitAnalysisResultAdapter;

    public void initialise() {
        super.initialise();
        if (!this.initialized) {
            this.initialized = true;
            this.updateVisibilityPasses();
        }
    }

    @Override
    public void setSpacecraft(EarthSpacecraft newSpacecraft) {
        super.setSpacecraft(newSpacecraft);
        if (this.initialized) {
            this.updateVisibilityPasses();
        }
    }

    @Override
    public void setOrbitAnalysisData(OrbitAnalysisData newOrbitAnalysisData) {
        if (this.orbitAnalysisData != null) {
            this.orbitAnalysisData.eAdapters().remove((Object)this.getOrbitAnalysisDataAdapter());
            if (this.orbitAnalysisData.getResult() != null) {
                this.orbitAnalysisData.getResult().eAdapters().remove((Object)this.getOrbitAnalysisResultAdapter());
            }
        }
        super.setOrbitAnalysisData(newOrbitAnalysisData);
        if (newOrbitAnalysisData != null) {
            newOrbitAnalysisData.eAdapters().add((Object)this.getOrbitAnalysisDataAdapter());
            if (newOrbitAnalysisData.getResult() != null) {
                newOrbitAnalysisData.getResult().eAdapters().add((Object)this.getOrbitAnalysisResultAdapter());
            }
        }
        if (this.initialized) {
            this.updateVisibilityPasses();
        }
    }

    @Override
    public void setGroundStationPassesColor(RGBA newGroundStationPassescolor) {
        super.setGroundStationPassesColor(newGroundStationPassescolor);
        for (VisibilityPassWorldWindLayer layer : this.getGroundStationsPassesLayers()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.VISIBILITY_PASS_WORLD_WIND_LAYER__COLOR, (Object)newGroundStationPassescolor, true);
        }
    }

    @Override
    public void setTargetPassesColor(RGBA newTargetPassesColor) {
        super.setTargetPassesColor(newTargetPassesColor);
        for (VisibilityPassWorldWindLayer layer : this.getTargetsPassesLayers()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.VISIBILITY_PASS_WORLD_WIND_LAYER__COLOR, (Object)newTargetPassesColor, true);
        }
    }

    @Override
    public void setShowGroundStationPasses(boolean newShowGroundStationPasses) {
        super.setShowGroundStationPasses(newShowGroundStationPasses);
        for (VisibilityPassWorldWindLayer layer : this.getGroundStationsPassesLayers()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__VISIBLE, (Object)newShowGroundStationPasses, true);
        }
    }

    @Override
    public void setShowObservationTargetPasses(boolean newShowObservationTargetPasses) {
        super.setShowObservationTargetPasses(newShowObservationTargetPasses);
        for (VisibilityPassWorldWindLayer layer : this.getTargetsPassesLayers()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__VISIBLE, (Object)newShowObservationTargetPasses, true);
        }
    }

    @Override
    public VisibilityPassWorldWindLayer getVisibilityPassWorldWindLayer(VisibilityPass visibilityPass) {
        for (VisibilityPassWorldWindLayer l : this.getVisibilityPassWorldWindLayers()) {
            if (l.getVisibilityPass() != visibilityPass) continue;
            return l;
        }
        return null;
    }

    protected void updateRenderableLayer() {
    }

    protected VisibilityPassWorldWindLayer addVisibilityPassWorldWindLayer(VisibilityPass visibilityPass) {
        if (visibilityPass != null) {
            VisibilityPassWorldWindLayer layer = this.createGroundStationWorldWindLayer(visibilityPass);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, (Object)layer, true);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ALL_VISIBILITY_PASSES_WORLD_WIND_LAYER__VISIBILITY_PASS_WORLD_WIND_LAYERS, (Object)layer, true);
            return layer;
        }
        return null;
    }

    protected void removeVisibilityPassWorldWindLayer(VisibilityPass visibilityPass) {
        VisibilityPassWorldWindLayer layer;
        if (visibilityPass != null && (layer = this.getVisibilityPassWorldWindLayer(visibilityPass)) != null) {
            if (this.getTargetsPassesLayers().contains((Object)layer)) {
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ALL_VISIBILITY_PASSES_WORLD_WIND_LAYER__TARGETS_PASSES_LAYERS, (Object)layer, true);
            }
            if (this.getGroundStationsPassesLayers().contains((Object)layer)) {
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ALL_VISIBILITY_PASSES_WORLD_WIND_LAYER__GROUND_STATIONS_PASSES_LAYERS, (Object)layer, true);
            }
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ALL_VISIBILITY_PASSES_WORLD_WIND_LAYER__VISIBILITY_PASS_WORLD_WIND_LAYERS, (Object)layer, true);
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, (Object)layer, true);
        }
    }

    protected void updateVisibilityPasses() {
        ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.COMPOSITE_WORLD_WIND_LAYER__LAYERS, true);
        if (!this.getTargetsPassesLayers().isEmpty()) {
            ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ALL_VISIBILITY_PASSES_WORLD_WIND_LAYER__TARGETS_PASSES_LAYERS, true);
        }
        if (!this.getGroundStationsPassesLayers().isEmpty()) {
            ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ALL_VISIBILITY_PASSES_WORLD_WIND_LAYER__GROUND_STATIONS_PASSES_LAYERS, true);
        }
        if (!this.getVisibilityPassWorldWindLayers().isEmpty()) {
            ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ALL_VISIBILITY_PASSES_WORLD_WIND_LAYER__VISIBILITY_PASS_WORLD_WIND_LAYERS, true);
        }
        if (this.getSpacecraft() != null && this.getOrbitAnalysisData() != null && this.getOrbitAnalysisData().getResult() != null) {
            this.createAllVisibilityWorldWindLayer(this.getOrbitAnalysisData());
        }
    }

    protected void createAllVisibilityWorldWindLayer(OrbitAnalysisData newOrbitAnalysisData) {
        if (newOrbitAnalysisData != null && newOrbitAnalysisData.getResult() != null) {
            String layerName;
            VisibilityPassWorldWindLayer layer;
            int index = 1;
            for (VisibilityPass visibilityPass : newOrbitAnalysisData.getResult().getObservationTargetVisibilityPasses()) {
                if (visibilityPass.getSpacecraft() != this.getSpacecraft() || (layer = this.addVisibilityPassWorldWindLayer(visibilityPass)) == null) continue;
                layerName = String.valueOf(layer.getName()) + " - " + Integer.toString(index);
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ALL_VISIBILITY_PASSES_WORLD_WIND_LAYER__TARGETS_PASSES_LAYERS, (Object)layer, true);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.VISIBILITY_PASS_WORLD_WIND_LAYER__COLOR, (Object)this.getTargetPassesColor(), true);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)EcorePackage.Literals.ENAMED_ELEMENT__NAME, (Object)layerName, true);
                ++index;
            }
            index = 1;
            for (VisibilityPass visibilityPass : newOrbitAnalysisData.getResult().getGroundStationVisibilityPasses()) {
                if (visibilityPass.getSpacecraft() != this.getSpacecraft() || (layer = this.addVisibilityPassWorldWindLayer(visibilityPass)) == null) continue;
                layerName = String.valueOf(layer.getName()) + " - " + Integer.toString(index);
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ALL_VISIBILITY_PASSES_WORLD_WIND_LAYER__GROUND_STATIONS_PASSES_LAYERS, (Object)layer, true);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.VISIBILITY_PASS_WORLD_WIND_LAYER__COLOR, (Object)this.getGroundStationPassesColor(), true);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)EcorePackage.Literals.ENAMED_ELEMENT__NAME, (Object)layerName, true);
                ++index;
            }
        }
    }

    protected VisibilityPassWorldWindLayer createGroundStationWorldWindLayer(VisibilityPass visibilityPass) {
        VisibilityPassWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createVisibilityPassWorldWindLayer();
        layer.setAutoUpdateEnabled(true);
        layer.setVisibilityPass(visibilityPass);
        layer.setName(visibilityPass.getOutlook().getName());
        layer.setVisible(true);
        layer.setDescription("Layer representing visibility pass for <" + visibilityPass.getOutlook().getName() + ">.");
        return layer;
    }

    protected Adapter getOrbitAnalysisDataAdapter() {
        if (this.orbitAnalysisDataAdapter == null) {
            this.orbitAnalysisDataAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof OrbitAnalysisData) {
                        int featureId = msg.getFeatureID(OrbitAnalysisData.class);
                        switch (featureId) {
                            case 10: {
                                OrbitAnalysisResult oldResult = (OrbitAnalysisResult)msg.getOldValue();
                                if (oldResult != null) {
                                    oldResult.eAdapters().remove((Object)AllVisibilityPassesWorldWindLayerCustomImpl.this.getOrbitAnalysisResultAdapter());
                                }
                                AllVisibilityPassesWorldWindLayerCustomImpl.this.updateVisibilityPasses();
                                OrbitAnalysisResult newResult = (OrbitAnalysisResult)msg.getNewValue();
                                if (newResult == null) break;
                                newResult.eAdapters().add((Object)AllVisibilityPassesWorldWindLayerCustomImpl.this.getOrbitAnalysisResultAdapter());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.orbitAnalysisDataAdapter;
    }

    protected Adapter getOrbitAnalysisResultAdapter() {
        if (this.orbitAnalysisResultAdapter == null) {
            this.orbitAnalysisResultAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof OrbitAnalysisResult) {
                        int featureId = msg.getFeatureID(OrbitAnalysisResult.class);
                        switch (featureId) {
                            case 1: 
                            case 2: {
                                AllVisibilityPassesWorldWindLayerCustomImpl.this.updateVisibilityPasses();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.orbitAnalysisResultAdapter;
    }
}

