/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.Eclipse;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.EclipsesWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.orbit.ui.utils.WorldWindOrbitUtils;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipsesWorldWindLayerCustomImpl
extends EclipsesWorldWindLayerImpl {
    public static final short GROUND_TRACE_STIPPLE_PATTERN = 255;
    public static final int GROUND_TRACE_STIPPLE_FACTOR = 1;
    private static final Logger Logger = LoggerFactory.getLogger(EclipsesWorldWindLayerCustomImpl.class);
    private Adapter eclipsesAdapter;

    public void initialise() {
        super.initialise();
        this.eAdapters().add((Object)this.getEclipsesAdapter());
    }

    public void dispose() {
        this.eAdapters().remove((Object)this.getEclipsesAdapter());
        super.dispose();
    }

    @Override
    public void setSpacecraft(EarthSpacecraft newSpacecraft) {
        super.setSpacecraft(newSpacecraft);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the spacecraft.", (Throwable)e);
            }
        }
    }

    @Override
    public void setPenumbraColor(RGBA newPenumbraColor) {
        super.setPenumbraColor(newPenumbraColor);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the penumbra color.", (Throwable)e);
            }
        }
    }

    @Override
    public void setUmbraColor(RGBA newUmbraColor) {
        super.setUmbraColor(newUmbraColor);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the umbra color.", (Throwable)e);
            }
        }
    }

    @Override
    public void setShowOrbit(boolean newShowOrbit) {
        super.setShowOrbit(newShowOrbit);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the setShowOrbit.", (Throwable)e);
            }
        }
    }

    @Override
    public void setShowGroundTrace(boolean newShowGroundTrace) {
        super.setShowGroundTrace(newShowGroundTrace);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the setShowGroundTrace.", (Throwable)e);
            }
        }
    }

    @Override
    public void setMaximumNumberOfRenderedSegments(int newMaximumNumberOfRenderedSegments) {
        super.setMaximumNumberOfRenderedSegments(newMaximumNumberOfRenderedSegments);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the Maximum Number Of Rendered Segments. ", (Throwable)e);
            }
        }
    }

    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible()) {
            try {
                List applicableEclipses = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getApplicableEclipse(this.getEclipses(), this.getSpacecraft());
                if (!this.eclipses.isEmpty()) {
                    int maximumSegmentSize = (int)Math.ceil((double)this.getMaximumNumberOfRenderedSegments() / (double)applicableEclipses.size());
                    for (Eclipse eclipse : applicableEclipses) {
                        Polyline groundTrace;
                        Color color;
                        List<Polyline> polylines;
                        if (eclipse.getPenumbraFirstTrajectorySegment() != null && !eclipse.getPenumbraFirstTrajectorySegment().isEmpty()) {
                            ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.refreshOreKitBackedSpacecraftState((EarthOrbitModel)this.getSpacecraft().getOrbitModel(), (Collection)eclipse.getPenumbraFirstTrajectorySegment());
                            polylines = WorldWindOrbitUtils.createPolyLineWithNoWrapAround((Collection<SpacecraftState>)eclipse.getPenumbraFirstTrajectorySegment(), maximumSegmentSize);
                            color = WorldWindUtils.convertFrom((RGBA)this.getPenumbraColor());
                            if (this.isShowOrbit()) {
                                for (Polyline line : polylines) {
                                    line.setColor(color);
                                    layer.addRenderable((Renderable)line);
                                }
                            }
                            if (this.isShowGroundTrace()) {
                                for (Polyline line : polylines) {
                                    groundTrace = new Polyline(line.getPositions());
                                    groundTrace.setFollowTerrain(true);
                                    groundTrace.setColor(color);
                                    groundTrace.setStippleFactor(1);
                                    groundTrace.setStipplePattern((short)255);
                                    layer.addRenderable((Renderable)groundTrace);
                                }
                            }
                        }
                        if (eclipse.getUmbraTrajectorySegment() != null && !eclipse.getUmbraTrajectorySegment().isEmpty()) {
                            ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.refreshOreKitBackedSpacecraftState((EarthOrbitModel)this.getSpacecraft().getOrbitModel(), (Collection)eclipse.getUmbraTrajectorySegment());
                            polylines = WorldWindOrbitUtils.createPolyLineWithNoWrapAround((Collection<SpacecraftState>)eclipse.getUmbraTrajectorySegment(), maximumSegmentSize);
                            color = WorldWindUtils.convertFrom((RGBA)this.getUmbraColor());
                            if (this.isShowOrbit()) {
                                for (Polyline line : polylines) {
                                    line.setColor(color);
                                    layer.addRenderable((Renderable)line);
                                }
                            }
                            if (this.isShowGroundTrace()) {
                                for (Polyline line : polylines) {
                                    groundTrace = new Polyline(line.getPositions());
                                    groundTrace.setFollowTerrain(true);
                                    groundTrace.setColor(color);
                                    groundTrace.setStippleFactor(1);
                                    groundTrace.setStipplePattern((short)255);
                                    layer.addRenderable((Renderable)groundTrace);
                                }
                            }
                        }
                        if (eclipse.getPenumbraSecondTrajectorySegment() == null || eclipse.getPenumbraSecondTrajectorySegment().isEmpty()) continue;
                        ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.refreshOreKitBackedSpacecraftState((EarthOrbitModel)this.getSpacecraft().getOrbitModel(), (Collection)eclipse.getPenumbraSecondTrajectorySegment());
                        polylines = WorldWindOrbitUtils.createPolyLineWithNoWrapAround((Collection<SpacecraftState>)eclipse.getPenumbraSecondTrajectorySegment(), maximumSegmentSize);
                        color = WorldWindUtils.convertFrom((RGBA)this.getPenumbraColor());
                        if (this.isShowOrbit()) {
                            for (Polyline line : polylines) {
                                line.setColor(color);
                                layer.addRenderable((Renderable)line);
                            }
                        }
                        if (!this.isShowGroundTrace()) continue;
                        for (Polyline line : polylines) {
                            groundTrace = new Polyline(line.getPositions());
                            groundTrace.setFollowTerrain(true);
                            groundTrace.setColor(color);
                            groundTrace.setStippleFactor(1);
                            groundTrace.setStipplePattern((short)255);
                            layer.addRenderable((Renderable)groundTrace);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.error("Error occured during updateRenderableLayer().", (Throwable)e);
            }
        }
    }

    protected Adapter getEclipsesAdapter() {
        if (this.eclipsesAdapter == null) {
            this.eclipsesAdapter = new AdapterImpl(){};
        }
        return this.eclipsesAdapter;
    }
}

