/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import java.util.Collection;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIPackage;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraftOrbitHistory;
import org.eclipse.apogy.core.environment.earth.orbit.Eclipse;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIPackage;
import org.eclipse.apogy.core.environment.earth.orbit.ui.EclipsesWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.impl.AbstractWorldWindLayerCustomImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.swt.graphics.RGBA;

public abstract class EclipsesWorldWindLayerImpl
extends AbstractWorldWindLayerCustomImpl
implements EclipsesWorldWindLayer {
    protected EarthSpacecraft spacecraft;
    protected EList<Eclipse> eclipses;
    protected EarthSpacecraftOrbitHistory spacecraftOrbitHistory;
    protected static final RGBA PENUMBRA_COLOR_EDEFAULT = (RGBA)ApogyCommonEMFUIFactory.eINSTANCE.createFromString(ApogyCommonEMFUIPackage.eINSTANCE.getRGBA(), "0,255,0,255");
    protected RGBA penumbraColor = PENUMBRA_COLOR_EDEFAULT;
    protected static final RGBA UMBRA_COLOR_EDEFAULT = (RGBA)ApogyCommonEMFUIFactory.eINSTANCE.createFromString(ApogyCommonEMFUIPackage.eINSTANCE.getRGBA(), "0,255,0,255");
    protected RGBA umbraColor = UMBRA_COLOR_EDEFAULT;
    protected static final boolean SHOW_ORBIT_EDEFAULT = true;
    protected boolean showOrbit = true;
    protected static final boolean SHOW_GROUND_TRACE_EDEFAULT = false;
    protected boolean showGroundTrace = false;
    protected static final int MAXIMUM_NUMBER_OF_RENDERED_SEGMENTS_EDEFAULT = 500;
    protected int maximumNumberOfRenderedSegments = 500;

    protected EclipsesWorldWindLayerImpl() {
    }

    protected EClass eStaticClass() {
        return ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.ECLIPSES_WORLD_WIND_LAYER;
    }

    @Override
    public EarthSpacecraft getSpacecraft() {
        if (this.spacecraft != null && this.spacecraft.eIsProxy()) {
            InternalEObject oldSpacecraft = (InternalEObject)this.spacecraft;
            this.spacecraft = (EarthSpacecraft)this.eResolveProxy(oldSpacecraft);
            if (this.spacecraft != oldSpacecraft && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldSpacecraft, (Object)this.spacecraft));
            }
        }
        return this.spacecraft;
    }

    public EarthSpacecraft basicGetSpacecraft() {
        return this.spacecraft;
    }

    @Override
    public void setSpacecraft(EarthSpacecraft newSpacecraft) {
        EarthSpacecraft oldSpacecraft = this.spacecraft;
        this.spacecraft = newSpacecraft;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldSpacecraft, (Object)this.spacecraft));
        }
    }

    @Override
    public EList<Eclipse> getEclipses() {
        if (this.eclipses == null) {
            this.eclipses = new EObjectResolvingEList(Eclipse.class, (InternalEObject)this, 11);
        }
        return this.eclipses;
    }

    @Override
    public EarthSpacecraftOrbitHistory getSpacecraftOrbitHistory() {
        if (this.spacecraftOrbitHistory != null && this.spacecraftOrbitHistory.eIsProxy()) {
            InternalEObject oldSpacecraftOrbitHistory = (InternalEObject)this.spacecraftOrbitHistory;
            this.spacecraftOrbitHistory = (EarthSpacecraftOrbitHistory)this.eResolveProxy(oldSpacecraftOrbitHistory);
            if (this.spacecraftOrbitHistory != oldSpacecraftOrbitHistory && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 12, (Object)oldSpacecraftOrbitHistory, (Object)this.spacecraftOrbitHistory));
            }
        }
        return this.spacecraftOrbitHistory;
    }

    public EarthSpacecraftOrbitHistory basicGetSpacecraftOrbitHistory() {
        return this.spacecraftOrbitHistory;
    }

    @Override
    public void setSpacecraftOrbitHistory(EarthSpacecraftOrbitHistory newSpacecraftOrbitHistory) {
        EarthSpacecraftOrbitHistory oldSpacecraftOrbitHistory = this.spacecraftOrbitHistory;
        this.spacecraftOrbitHistory = newSpacecraftOrbitHistory;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldSpacecraftOrbitHistory, (Object)this.spacecraftOrbitHistory));
        }
    }

    @Override
    public RGBA getPenumbraColor() {
        return this.penumbraColor;
    }

    @Override
    public void setPenumbraColor(RGBA newPenumbraColor) {
        RGBA oldPenumbraColor = this.penumbraColor;
        this.penumbraColor = newPenumbraColor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldPenumbraColor, (Object)this.penumbraColor));
        }
    }

    @Override
    public RGBA getUmbraColor() {
        return this.umbraColor;
    }

    @Override
    public void setUmbraColor(RGBA newUmbraColor) {
        RGBA oldUmbraColor = this.umbraColor;
        this.umbraColor = newUmbraColor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldUmbraColor, (Object)this.umbraColor));
        }
    }

    @Override
    public boolean isShowOrbit() {
        return this.showOrbit;
    }

    @Override
    public void setShowOrbit(boolean newShowOrbit) {
        boolean oldShowOrbit = this.showOrbit;
        this.showOrbit = newShowOrbit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldShowOrbit, this.showOrbit));
        }
    }

    @Override
    public boolean isShowGroundTrace() {
        return this.showGroundTrace;
    }

    @Override
    public void setShowGroundTrace(boolean newShowGroundTrace) {
        boolean oldShowGroundTrace = this.showGroundTrace;
        this.showGroundTrace = newShowGroundTrace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldShowGroundTrace, this.showGroundTrace));
        }
    }

    @Override
    public int getMaximumNumberOfRenderedSegments() {
        return this.maximumNumberOfRenderedSegments;
    }

    @Override
    public void setMaximumNumberOfRenderedSegments(int newMaximumNumberOfRenderedSegments) {
        int oldMaximumNumberOfRenderedSegments = this.maximumNumberOfRenderedSegments;
        this.maximumNumberOfRenderedSegments = newMaximumNumberOfRenderedSegments;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, oldMaximumNumberOfRenderedSegments, this.maximumNumberOfRenderedSegments));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                if (resolve) {
                    return this.getSpacecraft();
                }
                return this.basicGetSpacecraft();
            }
            case 11: {
                return this.getEclipses();
            }
            case 12: {
                if (resolve) {
                    return this.getSpacecraftOrbitHistory();
                }
                return this.basicGetSpacecraftOrbitHistory();
            }
            case 13: {
                return this.getPenumbraColor();
            }
            case 14: {
                return this.getUmbraColor();
            }
            case 15: {
                return this.isShowOrbit();
            }
            case 16: {
                return this.isShowGroundTrace();
            }
            case 17: {
                return this.getMaximumNumberOfRenderedSegments();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setSpacecraft((EarthSpacecraft)newValue);
                return;
            }
            case 11: {
                this.getEclipses().clear();
                this.getEclipses().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setSpacecraftOrbitHistory((EarthSpacecraftOrbitHistory)newValue);
                return;
            }
            case 13: {
                this.setPenumbraColor((RGBA)newValue);
                return;
            }
            case 14: {
                this.setUmbraColor((RGBA)newValue);
                return;
            }
            case 15: {
                this.setShowOrbit((Boolean)newValue);
                return;
            }
            case 16: {
                this.setShowGroundTrace((Boolean)newValue);
                return;
            }
            case 17: {
                this.setMaximumNumberOfRenderedSegments((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setSpacecraft(null);
                return;
            }
            case 11: {
                this.getEclipses().clear();
                return;
            }
            case 12: {
                this.setSpacecraftOrbitHistory(null);
                return;
            }
            case 13: {
                this.setPenumbraColor(PENUMBRA_COLOR_EDEFAULT);
                return;
            }
            case 14: {
                this.setUmbraColor(UMBRA_COLOR_EDEFAULT);
                return;
            }
            case 15: {
                this.setShowOrbit(true);
                return;
            }
            case 16: {
                this.setShowGroundTrace(false);
                return;
            }
            case 17: {
                this.setMaximumNumberOfRenderedSegments(500);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.spacecraft != null;
            }
            case 11: {
                return this.eclipses != null && !this.eclipses.isEmpty();
            }
            case 12: {
                return this.spacecraftOrbitHistory != null;
            }
            case 13: {
                return PENUMBRA_COLOR_EDEFAULT == null ? this.penumbraColor != null : !PENUMBRA_COLOR_EDEFAULT.equals((Object)this.penumbraColor);
            }
            case 14: {
                return UMBRA_COLOR_EDEFAULT == null ? this.umbraColor != null : !UMBRA_COLOR_EDEFAULT.equals((Object)this.umbraColor);
            }
            case 15: {
                return !this.showOrbit;
            }
            case 16: {
                return this.showGroundTrace;
            }
            case 17: {
                return this.maximumNumberOfRenderedSegments != 500;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (penumbraColor: ");
        result.append(this.penumbraColor);
        result.append(", umbraColor: ");
        result.append(this.umbraColor);
        result.append(", showOrbit: ");
        result.append(this.showOrbit);
        result.append(", showGroundTrace: ");
        result.append(this.showGroundTrace);
        result.append(", maximumNumberOfRenderedSegments: ");
        result.append(this.maximumNumberOfRenderedSegments);
        result.append(')');
        return result.toString();
    }
}

