/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.orbit.GroundStation;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ui.GroundStationWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.SelectedGroundStationsWorldWindLayerImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectedGroundStationsWorldWindLayerCustomImpl
extends SelectedGroundStationsWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SelectedGroundStationsWorldWindLayerCustomImpl.class);
    private boolean busy = false;

    @Override
    public void selectionChanged(final List<EObject> items) {
        if (!(this.isLockSelection() || this.isUpdating() || this.busy)) {
            this.busy = true;
            TransactionalEditingDomain transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this);
            RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

                protected void doExecute() {
                    try {
                        SelectedGroundStationsWorldWindLayerCustomImpl.this.setUpdating(true);
                        ArrayList<GroundStation> groundStations = new ArrayList<GroundStation>();
                        for (EObject eObject : items) {
                            if (!(eObject instanceof GroundStation)) continue;
                            groundStations.add((GroundStation)eObject);
                        }
                        if (groundStations.size() > 0 || SelectedGroundStationsWorldWindLayerCustomImpl.this.isAllowZeroSizeSelection()) {
                            SelectedGroundStationsWorldWindLayerCustomImpl.this.getGroundStationWorldWindLayers().clear();
                            SelectedGroundStationsWorldWindLayerCustomImpl.this.getLayers().clear();
                            ArrayList<GroundStationWorldWindLayer> layers = new ArrayList<GroundStationWorldWindLayer>();
                            for (GroundStation groundStation : groundStations) {
                                if (groundStation == null) continue;
                                GroundStationWorldWindLayer layer = SelectedGroundStationsWorldWindLayerCustomImpl.this.createGroundStationWorldWindLayer(groundStation);
                                layers.add(layer);
                            }
                            SelectedGroundStationsWorldWindLayerCustomImpl.this.getGroundStationWorldWindLayers().addAll(layers);
                            SelectedGroundStationsWorldWindLayerCustomImpl.this.getLayers().addAll(layers);
                        }
                        SelectedGroundStationsWorldWindLayerCustomImpl.this.setUpdating(false);
                    }
                    catch (Exception e) {
                        Logger.error("Selection changed failed !", (Throwable)e);
                    }
                    SelectedGroundStationsWorldWindLayerCustomImpl.this.busy = false;
                }
            };
            try {
                transactionalEditingDomain.getCommandStack().execute((Command)cmd);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void setColor(RGBA newColor) {
        super.setColor(newColor);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setColor(newColor);
        }
    }

    @Override
    public void setShowOutline(boolean newShowOutline) {
        super.setShowOutline(newShowOutline);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setShowOutline(newShowOutline);
        }
    }

    @Override
    public void setDisplayBalloon(boolean newDisplayBalloon) {
        super.setDisplayBalloon(newDisplayBalloon);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setDisplayBalloon(newDisplayBalloon);
        }
    }

    @Override
    public void setDisplayLocation(boolean newDisplayLocation) {
        super.setDisplayLocation(newDisplayLocation);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setDisplayLocation(newDisplayLocation);
        }
    }

    @Override
    public void setOpacity(double newOpacity) {
        super.setOpacity(newOpacity);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setOpacity(newOpacity);
        }
    }

    @Override
    public void setShowVisibilityCircle(boolean newShowVisibilityCircle) {
        super.setShowVisibilityCircle(newShowVisibilityCircle);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setShowVisibilityCircle(newShowVisibilityCircle);
        }
    }

    @Override
    public void setShowVisibilityCone(boolean newShowVisibilityCone) {
        super.setShowVisibilityCone(newShowVisibilityCone);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setShowVisibilityCone(newShowVisibilityCone);
        }
    }

    @Override
    public void setTargetRadius(double newTargetRadius) {
        super.setTargetRadius(newTargetRadius);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setTargetRadius(newTargetRadius);
        }
    }

    public void setAutoUpdateEnabled(boolean newAutoUpdateEnabled) {
        super.setAutoUpdateEnabled(newAutoUpdateEnabled);
        for (GroundStationWorldWindLayer layer : this.getGroundStationWorldWindLayers()) {
            layer.setAutoUpdateEnabled(newAutoUpdateEnabled);
        }
    }

    protected void updateRenderableLayer() {
    }

    protected GroundStationWorldWindLayer createGroundStationWorldWindLayer(GroundStation groundStation) {
        GroundStationWorldWindLayer layer = ApogyCoreEnvironmentEarthOrbitUIFactory.eINSTANCE.createGroundStationWorldWindLayer();
        String layerName = String.valueOf(this.getName()) + " - " + groundStation.getName();
        layer.setAutoUpdateEnabled(false);
        layer.setEarthSurfaceLocation((EarthSurfaceLocation)groundStation);
        layer.setShowOutline(this.isShowOutline());
        layer.setDisplayBalloon(this.isDisplayBalloon());
        layer.setDisplayLocation(this.isDisplayLocation());
        layer.setOpacity(this.getOpacity());
        layer.setShowVisibilityCircle(this.isShowVisibilityCircle());
        layer.setShowVisibilityCone(this.isShowVisibilityCone());
        layer.setTargetRadius(this.getTargetRadius());
        layer.setName(layerName);
        layer.setDescription("Layer representing the Ground station name <" + groundStation.getName() + ">.");
        layer.setReferenceAltitude(this.getReferenceAltitude());
        layer.setAutoUpdateEnabled(true);
        layer.setVisible(true);
        return layer;
    }
}

