/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import java.util.Date;
import org.eclipse.apogy.common.emf.AbstractTimeSource;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.Timed;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.SpacecraftEarthViewPointImpl;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.SpacecraftLocationWorldWindLayerCustomImpl;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewPointNavigationType;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacecraftEarthViewPointCustomImpl
extends SpacecraftEarthViewPointImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SpacecraftLocationWorldWindLayerCustomImpl.class);
    private Adapter timeSourceAdapter;

    public void initialize() {
        if (ApogyCoreEnvironmentFacade.INSTANCE.getActiveTimeSource() != null) {
            ApogyCoreEnvironmentFacade.INSTANCE.getActiveTimeSource().eAdapters().add((Object)this.getTimeSourceAdapter());
            this.update(ApogyCoreEnvironmentFacade.INSTANCE.getActiveTimeSource().getTime());
        }
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getTimeSourceAdapter());
    }

    public void dispose() {
        if (ApogyCoreEnvironmentFacade.INSTANCE.getActiveTimeSource() != null) {
            ApogyCoreEnvironmentFacade.INSTANCE.getActiveTimeSource().eAdapters().remove((Object)this.getTimeSourceAdapter());
        }
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getTimeSourceAdapter());
    }

    @Override
    public void setSpacecraft(EarthSpacecraft newSpacecraft) {
        super.setSpacecraft(newSpacecraft);
    }

    public EarthViewPointNavigationType getNavigationType() {
        return EarthViewPointNavigationType.FLY_VIEW;
    }

    protected void update(Date date) {
        if (this.getSpacecraft() != null) {
            try {
                SpacecraftState ss = ((EarthOrbitModel)this.getSpacecraft().getOrbitModel()).propagate(date);
                GeographicCoordinates coord = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.convertToGeographicCoordinates((OreKitBackedSpacecraftState)ss);
                double newElevation = coord.getElevation() + this.getHeightAboveSpacecraft() * 1000.0;
                coord.setElevation(newElevation);
                double heading = Math.toDegrees(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getVelocityHeading(ss));
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_EARTH_VIEW_POINT__EYE_POSITION, (Object)coord, true);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_EARTH_VIEW_POINT__HEADING_ANGLE, (Object)heading, true);
            }
            catch (Exception e) {
                Logger.error("Error during time update.", (Throwable)e);
            }
        }
    }

    protected Adapter getTimeSourceAdapter() {
        if (this.timeSourceAdapter == null) {
            this.timeSourceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    block7: {
                        Timed timed;
                        Date date;
                        block6: {
                            if (!(msg.getNotifier() instanceof ApogyCoreEnvironmentFacade)) break block6;
                            int featureId = msg.getFeatureID(ApogyCoreEnvironmentFacade.class);
                            switch (featureId) {
                                case 2: {
                                    AbstractTimeSource newTimeSource;
                                    AbstractTimeSource oldTimeSource = (AbstractTimeSource)msg.getOldValue();
                                    if (oldTimeSource != null) {
                                        oldTimeSource.eAdapters().remove((Object)SpacecraftEarthViewPointCustomImpl.this.getTimeSourceAdapter());
                                    }
                                    if ((newTimeSource = (AbstractTimeSource)msg.getNewValue()) != null) {
                                        newTimeSource.eAdapters().add((Object)SpacecraftEarthViewPointCustomImpl.this.getTimeSourceAdapter());
                                        SpacecraftEarthViewPointCustomImpl.this.update(newTimeSource.getTime());
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block7;
                        }
                        if (msg.getNotifier() instanceof Timed && (date = (timed = (Timed)msg.getNotifier()).getTime()) != null) {
                            SpacecraftEarthViewPointCustomImpl.this.update(timed.getTime());
                        }
                    }
                }
            };
        }
        return this.timeSourceAdapter;
    }
}

