/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.AbstractTimeSource;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.Timed;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIPackage;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.SpacecraftLocationWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacecraftLocationWorldWindLayerCustomImpl
extends SpacecraftLocationWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SpacecraftLocationWorldWindLayerCustomImpl.class);
    public static final String DEGREE_STRING = "\u00b0";
    private AbstractTimeSource timeSource = null;
    private Adapter activeTimeSourceAdapter = null;
    private Adapter timedAdapter = null;

    @Override
    public void setShowGroundProjection(boolean newShowGroundProjection) {
        super.setShowGroundProjection(newShowGroundProjection);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setGroundProjectionRadius(double newGroundProjectionRadius) {
        super.setGroundProjectionRadius(newGroundProjectionRadius);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setShowLatLon(boolean newShowLatLon) {
        super.setShowLatLon(newShowLatLon);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setName(String newName) {
        super.setName(newName);
        this.updateRenderableLayer();
    }

    @Override
    public void setColor(RGBA newColor) {
        super.setColor(newColor);
        this.updateRenderableLayer();
    }

    @Override
    public RGBA getColor() {
        RGBA color = super.getColor();
        if (color == null) {
            color = COLOR_EDEFAULT;
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.SPACECRAFT_LOCATION_WORLD_WIND_LAYER__COLOR, (Object)color, true);
        }
        return color;
    }

    public void initialise() {
        super.initialise();
        this.timeSource = ApogyCoreEnvironmentFacade.INSTANCE.getActiveTimeSource();
        if (this.timeSource != null) {
            this.timeSource.eAdapters().add((Object)this.getTimedAdapter());
        }
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getActiveTimeSourceAdapter());
    }

    public void dispose() {
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().remove((Object)this.getActiveTimeSourceAdapter());
        if (this.timeSource != null) {
            this.timeSource.eAdapters().remove((Object)this.getTimedAdapter());
        }
        super.dispose();
    }

    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible() && this.getSpacecraft() != null && this.getSpacecraft().getOrbitModel() != null && this.timeSource != null) {
            try {
                SpacecraftState ss = ((EarthOrbitModel)this.getSpacecraft().getOrbitModel()).propagate(ApogyCoreEnvironmentFacade.INSTANCE.getActiveTimeSource().getTime());
                GeographicCoordinates coord = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.convertToGeographicCoordinates((OreKitBackedSpacecraftState)ss);
                Angle latitude = Angle.fromRadiansLatitude((double)coord.getLatitude());
                Angle longitude = Angle.fromRadiansLongitude((double)coord.getLongitude());
                double elevation = coord.getElevation();
                Position spcaecraftPosition = new Position(latitude, longitude, elevation);
                String text = this.getDisplayedText(ss, coord);
                GlobeAnnotation spacecraftAnnotation = new GlobeAnnotation(text, spcaecraftPosition);
                AnnotationAttributes annotationAttributes = new AnnotationAttributes();
                annotationAttributes.setVisible(true);
                Font font = annotationAttributes.getFont();
                font = font.deriveFont(1, 16.0f);
                annotationAttributes.setFont(font);
                Color displayColor = WorldWindUtils.convertFrom((RGBA)this.getColor());
                Color transparent = new Color(0.0f, 0.0f, 1.0f, 0.3f);
                annotationAttributes.setBackgroundColor(transparent);
                annotationAttributes.setTextColor(displayColor);
                spacecraftAnnotation.setAttributes(annotationAttributes);
                layer.addRenderable((Renderable)spacecraftAnnotation);
                if (this.isShowGroundProjection()) {
                    Position groundPosition = new Position(latitude, longitude, 0.0);
                    BasicShapeAttributes attributes = new BasicShapeAttributes();
                    attributes.setDrawInterior(true);
                    Material mat = new Material(displayColor);
                    attributes.setInteriorMaterial(mat);
                    SurfaceCircle surfaceCircle = new SurfaceCircle((ShapeAttributes)attributes, (LatLon)groundPosition, this.getGroundProjectionRadius() * 1000.0, 24);
                    surfaceCircle.setVisible(true);
                    layer.addRenderable((Renderable)surfaceCircle);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.error(String.valueOf(this.getName()) + "Failed to update Renderable Layer.", (Throwable)e);
            }
        }
    }

    protected String getDisplayedText(SpacecraftState ss, GeographicCoordinates coord) {
        String text = this.getName();
        if (this.getSpacecraft() != null && this.getSpacecraft().getName() != null) {
            text = this.getSpacecraft().getName();
        }
        if (this.isShowLatLon()) {
            DecimalFormat latLongDecimalFormat = new DecimalFormat("0.000");
            double lat = Math.toDegrees(coord.getLatitude());
            double lon = Math.toDegrees(coord.getLongitude());
            DecimalFormat altitudeDecimalFormat = new DecimalFormat("0.0");
            double altitude = coord.getElevation() * 0.001;
            text = String.valueOf(text) + "\n lat " + latLongDecimalFormat.format(lat) + DEGREE_STRING + ", lon " + latLongDecimalFormat.format(lon) + DEGREE_STRING + ", alt " + altitudeDecimalFormat.format(altitude) + " km";
        }
        return text;
    }

    protected Adapter getActiveTimeSourceAdapter() {
        if (this.activeTimeSourceAdapter == null) {
            this.activeTimeSourceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId;
                    if (msg.getNotifier() instanceof ApogyCoreEnvironmentFacade && (featureId = msg.getFeatureID(ApogyCoreEnvironmentFacade.class)) == 2) {
                        AbstractTimeSource oldTimeSource;
                        if (SpacecraftLocationWorldWindLayerCustomImpl.this.timeSource != null) {
                            SpacecraftLocationWorldWindLayerCustomImpl.this.timeSource.eAdapters().remove((Object)SpacecraftLocationWorldWindLayerCustomImpl.this.getTimedAdapter());
                        }
                        if ((oldTimeSource = (AbstractTimeSource)msg.getOldValue()) != null) {
                            oldTimeSource.eAdapters().remove((Object)SpacecraftLocationWorldWindLayerCustomImpl.this.getTimedAdapter());
                        }
                        SpacecraftLocationWorldWindLayerCustomImpl.this.timeSource = null;
                        AbstractTimeSource newTimeSource = (AbstractTimeSource)msg.getNewValue();
                        if (newTimeSource != null) {
                            SpacecraftLocationWorldWindLayerCustomImpl.this.timeSource = newTimeSource;
                            SpacecraftLocationWorldWindLayerCustomImpl.this.timeSource.eAdapters().add((Object)SpacecraftLocationWorldWindLayerCustomImpl.this.getTimedAdapter());
                        }
                        try {
                            SpacecraftLocationWorldWindLayerCustomImpl.this.update();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
        }
        return this.activeTimeSourceAdapter;
    }

    protected Adapter getTimedAdapter() {
        if (this.timedAdapter == null) {
            this.timedAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Timed) {
                        int featureId = msg.getFeatureID(Timed.class);
                        switch (featureId) {
                            case 0: {
                                if (!SpacecraftLocationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) break;
                                try {
                                    SpacecraftLocationWorldWindLayerCustomImpl.this.update();
                                }
                                catch (Exception e) {
                                    Logger.error("Failed to update time.", (Throwable)e);
                                }
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.timedAdapter;
    }
}

