/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraftOrbitHistory;
import org.eclipse.apogy.core.environment.earth.orbit.Eclipse;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisResult;
import org.eclipse.apogy.core.environment.earth.orbit.ui.ApogyCoreEnvironmentEarthOrbitUIPackage;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.SpacecraftOrbitAnalysisWorldWindLayerImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.RGBA;

public class SpacecraftOrbitAnalysisWorldWindLayerCustomImpl
extends SpacecraftOrbitAnalysisWorldWindLayerImpl {
    private boolean initialized = false;
    protected Adapter orbitAnalysisDataAdapter;
    protected Adapter resultAdapter;
    protected Adapter eclipsesLayerAdapter;

    public void initialise() {
        super.initialise();
        this.initialized = true;
    }

    public void dispose() {
        if (this.getOrbitAnalysisData() != null) {
            this.getOrbitAnalysisData().eAdapters().remove((Object)this.getOrbitAnalysisDataAdapter());
        }
        super.dispose();
    }

    @Override
    public void setSpacecraft(EarthSpacecraft newSpacecraft) {
        super.setSpacecraft(newSpacecraft);
        if (this.initialized) {
            if (this.getSpacecraftOrbitLayer() != null) {
                this.getSpacecraftOrbitLayer().setSpacecraft(newSpacecraft);
                if (newSpacecraft != null) {
                    this.getSpacecraftOrbitLayer().setName("Orbit - " + newSpacecraft.getName());
                    this.getSpacecraftOrbitLayer().setDescription("Orbit for spacecraft <" + newSpacecraft.getName() + ">");
                }
            }
            if (this.getEclipseWorldWindLayer() != null) {
                this.getEclipseWorldWindLayer().setSpacecraft(newSpacecraft);
                if (newSpacecraft != null) {
                    this.getEclipseWorldWindLayer().setName("Eclipses - " + newSpacecraft.getName());
                    this.getEclipseWorldWindLayer().setDescription("Eclipses for spacecraft <" + newSpacecraft.getName() + ">");
                }
            }
            if (newSpacecraft != null) {
                this.setName("Orbit Analysis - " + newSpacecraft.getName());
            } else {
                this.setName("");
            }
            this.updateSubLayersInputs(this.getOrbitAnalysisData(), newSpacecraft);
        }
    }

    @Override
    public void setOrbitAnalysisData(OrbitAnalysisData newOrbitAnalysisData) {
        if (this.orbitAnalysisData != null) {
            this.orbitAnalysisData.eAdapters().remove((Object)this.getOrbitAnalysisDataAdapter());
        }
        super.setOrbitAnalysisData(newOrbitAnalysisData);
        if (newOrbitAnalysisData != null) {
            newOrbitAnalysisData.eAdapters().add((Object)this.getOrbitAnalysisDataAdapter());
        }
        if (this.initialized) {
            this.updateSubLayersInputs(newOrbitAnalysisData, this.getSpacecraft());
        }
    }

    @Override
    public void setOrbitColor(RGBA newOrbitColor) {
        super.setOrbitColor(newOrbitColor);
        if (this.getSpacecraftOrbitLayer() != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.getSpacecraftOrbitLayer(), (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitUIPackage.Literals.SPACECRAFT_ORBIT_SEGMENTS_WORLD_WIND_LAYER__COLOR, (Object)newOrbitColor, true);
        }
    }

    public void update() throws Exception {
        try {
            if (this.getEclipseWorldWindLayer() != null) {
                this.getEclipseWorldWindLayer().update();
            }
            if (this.getSpacecraftOrbitLayer() != null) {
                this.getSpacecraftOrbitLayer().update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateSubLayersInputs(OrbitAnalysisData newOrbitAnalysisData, EarthSpacecraft newSpacecraft) {
        if (newSpacecraft != null && newOrbitAnalysisData != null && newOrbitAnalysisData.getResult() != null) {
            EarthSpacecraftOrbitHistory earthSpacecraftOrbitHistory = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getApplicableEarthSpacecraftOrbitHistory((Collection)newOrbitAnalysisData.getResult().getSpacecraftTrajectories(), newSpacecraft);
            ArrayList<TimeInterval> eclipseIntervals = new ArrayList<TimeInterval>();
            List eclipses = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getApplicableEclipse((Collection)newOrbitAnalysisData.getResult().getEclipses(), newSpacecraft);
            for (Eclipse eclipse : eclipses) {
                TimeInterval umbraInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                TimeInterval penumbraEntryInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                TimeInterval penumbraExitInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getEclipseIntervals(eclipse, newOrbitAnalysisData.getFromDate(), newOrbitAnalysisData.getToDate(), umbraInterval, penumbraEntryInterval, penumbraExitInterval);
                if (umbraInterval.getFromDate() != null && umbraInterval.getToDate() != null) {
                    eclipseIntervals.add(umbraInterval);
                }
                if (penumbraEntryInterval.getFromDate() != null && penumbraEntryInterval.getToDate() != null) {
                    eclipseIntervals.add(penumbraEntryInterval);
                }
                if (penumbraExitInterval.getFromDate() == null || penumbraExitInterval.getToDate() == null) continue;
                eclipseIntervals.add(penumbraExitInterval);
            }
            TimeInterval dataTimeInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
            dataTimeInterval.setFromDate(newOrbitAnalysisData.getFromDate());
            dataTimeInterval.setToDate(newOrbitAnalysisData.getToDate());
            List orbitSegmentsIntervals = ApogyCommonEMFFacade.INSTANCE.getTimeIntervalInterstices(dataTimeInterval, eclipseIntervals);
            if (this.getSpacecraftOrbitLayer() != null) {
                this.getSpacecraftOrbitLayer().getIntervalsToShow().clear();
                this.getSpacecraftOrbitLayer().getIntervalsToShow().addAll((Collection)orbitSegmentsIntervals);
                this.getSpacecraftOrbitLayer().setSpacecraftOrbitHistory(earthSpacecraftOrbitHistory);
            }
            if (this.getEclipseWorldWindLayer() != null) {
                this.getEclipseWorldWindLayer().getEclipses().clear();
                this.getEclipseWorldWindLayer().getEclipses().addAll((Collection)newOrbitAnalysisData.getResult().getEclipses());
                this.getEclipseWorldWindLayer().setSpacecraftOrbitHistory(earthSpacecraftOrbitHistory);
            }
        } else {
            if (this.getEclipseWorldWindLayer() != null) {
                this.getEclipseWorldWindLayer().getEclipses().clear();
                this.getEclipseWorldWindLayer().setSpacecraftOrbitHistory(null);
            }
            if (this.getSpacecraftOrbitLayer() != null) {
                this.getSpacecraftOrbitLayer().getIntervalsToShow().clear();
                this.getSpacecraftOrbitLayer().setSpacecraftOrbitHistory(null);
            }
        }
    }

    protected Adapter getOrbitAnalysisDataAdapter() {
        if (this.orbitAnalysisDataAdapter == null) {
            this.orbitAnalysisDataAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof OrbitAnalysisData) {
                        int featureID = msg.getFeatureID(OrbitAnalysisData.class);
                        switch (featureID) {
                            case 10: {
                                if (msg.getOldValue() instanceof OrbitAnalysisResult) {
                                    ((OrbitAnalysisResult)msg.getOldValue()).eAdapters().remove((Object)SpacecraftOrbitAnalysisWorldWindLayerCustomImpl.this.getResultAdapter());
                                }
                                if (msg.getNewValue() instanceof OrbitAnalysisResult) {
                                    ((OrbitAnalysisResult)msg.getNewValue()).eAdapters().add((Object)SpacecraftOrbitAnalysisWorldWindLayerCustomImpl.this.getResultAdapter());
                                }
                                SpacecraftOrbitAnalysisWorldWindLayerCustomImpl.this.updateSubLayersInputs(SpacecraftOrbitAnalysisWorldWindLayerCustomImpl.this.getOrbitAnalysisData(), SpacecraftOrbitAnalysisWorldWindLayerCustomImpl.this.getSpacecraft());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.orbitAnalysisDataAdapter;
    }

    protected Adapter getResultAdapter() {
        if (this.resultAdapter == null) {
            this.resultAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof OrbitAnalysisResult) {
                        int featureID = msg.getFeatureID(OrbitAnalysisResult.class);
                        switch (featureID) {
                            case 3: 
                            case 4: {
                                SpacecraftOrbitAnalysisWorldWindLayerCustomImpl.this.updateSubLayersInputs(SpacecraftOrbitAnalysisWorldWindLayerCustomImpl.this.getOrbitAnalysisData(), SpacecraftOrbitAnalysisWorldWindLayerCustomImpl.this.getSpacecraft());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.resultAdapter;
    }
}

