/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFactory;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.SpacecraftSwathCorridor;
import org.eclipse.apogy.core.environment.earth.orbit.ui.SpacecraftOrbitSegmentsWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.orbit.ui.impl.SpacecraftOrbitSegmentsWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.orbit.ui.utils.WorldWindOrbitUtils;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacecraftOrbitSegmentsWorldWindLayerCustomImpl
extends SpacecraftOrbitSegmentsWorldWindLayerImpl {
    public static final short GROUND_TRACE_STIPPLE_PATTERN = 255;
    public static final int GROUND_TRACE_STIPPLE_FACTOR = 1;
    private static final Logger Logger = LoggerFactory.getLogger(SpacecraftOrbitSegmentsWorldWindLayerCustomImpl.class);
    private Adapter adapter;

    public void initialise() {
        super.initialise();
        this.eAdapters().add((Object)this.getAdapter());
    }

    public void dispose() {
        this.eAdapters().remove((Object)this.getAdapter());
        super.dispose();
    }

    @Override
    public void setColor(RGBA newColor) {
        super.setColor(newColor);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the color. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setShowOrbit(boolean newShowOrbit) {
        super.setShowOrbit(newShowOrbit);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the show orbit. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setShowGroundTrace(boolean newShowGroundTrace) {
        super.setShowGroundTrace(newShowGroundTrace);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the ShowGroundTrace. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setShowSwathCorridor(boolean newShowSwathCorridor) {
        super.setShowSwathCorridor(newShowSwathCorridor);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the ShowSwathCorridor. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setLeftSwathAngle(double newLeftSwathAngle) {
        super.setLeftSwathAngle(newLeftSwathAngle);
        if (this.isShowSwathCorridor() && this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the left swath angle. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setRightSwathAngle(double newLeftSwathAngle) {
        super.setRightSwathAngle(newLeftSwathAngle);
        if (this.isShowSwathCorridor() && this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the right swath angle. ", (Throwable)e);
            }
        }
    }

    @Override
    public void setMaximumNumberOfRenderedSegments(int newMaximumNumberOfRenderedSegments) {
        super.setMaximumNumberOfRenderedSegments(newMaximumNumberOfRenderedSegments);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the Maximum Number Of Rendered Segments. ", (Throwable)e);
            }
        }
    }

    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible()) {
            try {
                if (this.getSpacecraft() != null && this.getSpacecraftOrbitHistory() != null && !this.getSpacecraftOrbitHistory().getSpacecraftStates().isEmpty() && this.getIntervalsToShow() != null && !this.getIntervalsToShow().isEmpty()) {
                    int maximumSegmentSize = (int)Math.ceil((double)this.getMaximumNumberOfRenderedSegments() / (double)this.getIntervalsToShow().size());
                    if (this.getIntervalsToShow() != null) {
                        for (TimeInterval timeInterval : this.getIntervalsToShow()) {
                            SortedSet states = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getSpacecraftStatesInInterval((List)this.getSpacecraftOrbitHistory().getSpacecraftStates(), timeInterval.getFromDate(), timeInterval.getToDate());
                            if (states.isEmpty()) continue;
                            ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.refreshOreKitBackedSpacecraftState((EarthOrbitModel)this.spacecraft.getOrbitModel(), (Collection)states);
                            List<Polyline> polylines = WorldWindOrbitUtils.createPolyLineWithNoWrapAround(states, maximumSegmentSize);
                            Color color = WorldWindUtils.convertFrom((RGBA)this.getColor());
                            if (this.isShowOrbit()) {
                                for (Polyline line : polylines) {
                                    line.setColor(color);
                                    layer.addRenderable((Renderable)line);
                                }
                            }
                            if (!this.isShowGroundTrace()) continue;
                            for (Polyline line : polylines) {
                                Polyline groundTrace = new Polyline(line.getPositions());
                                groundTrace.setFollowTerrain(true);
                                groundTrace.setColor(color);
                                groundTrace.setStippleFactor(1);
                                groundTrace.setStipplePattern((short)255);
                                layer.addRenderable((Renderable)groundTrace);
                            }
                        }
                    }
                    if (this.isShowSwathCorridor()) {
                        SpacecraftSwathCorridor spacecraftSwathCorridor = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createSpacecraftSwathCorridor();
                        spacecraftSwathCorridor.setStartTime(this.getSpacecraftOrbitHistory().getFromDate());
                        spacecraftSwathCorridor.setEndTime(this.getSpacecraftOrbitHistory().getToDate());
                        spacecraftSwathCorridor.setOrbitModel(this.getSpacecraft().getOrbitModel());
                        spacecraftSwathCorridor.setTimeInterval(30.0);
                        spacecraftSwathCorridor.setLeftSwathAngle(this.getLeftSwathAngle());
                        spacecraftSwathCorridor.setRightSwathAngle(this.getRightSwathAngle());
                        spacecraftSwathCorridor.update();
                        List<Polyline> polylines = WorldWindOrbitUtils.createPolylines(spacecraftSwathCorridor.getCorridor(), 0.0, this.getMaximumNumberOfRenderedSegments());
                        Color color = WorldWindUtils.convertFrom((RGBA)this.getColor());
                        for (Polyline line : polylines) {
                            Polyline groundTrace = new Polyline(line.getPositions());
                            groundTrace.setFollowTerrain(true);
                            groundTrace.setColor(color);
                            layer.addRenderable((Renderable)groundTrace);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof SpacecraftOrbitSegmentsWorldWindLayer) {
                        int featureID = msg.getFeatureID(SpacecraftOrbitSegmentsWorldWindLayer.class);
                        switch (featureID) {
                            case 11: 
                            case 12: {
                                SpacecraftOrbitSegmentsWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

