/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.wizards;

import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.EObjectReferencesList;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.environment.earth.orbit.AbstractObservationTargetImporter;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.ObservationTarget;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.ui.composites.AbstractObservationTargetImporterListComposite;
import org.eclipse.apogy.core.environment.earth.orbit.ui.composites.ObservationTargetListComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationImporterWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.earth.orbit.ui.wizards.SelectObservationImporterWizardPage";
    private static final Logger Logger = LoggerFactory.getLogger(ObservationImporterWizardPage.class);
    private OrbitAnalysisData orbitAnalysisData;
    private AbstractObservationTargetImporterListComposite<OrbitAnalysisData> abstractObservationTargetImporterListComposite;
    private AbstractObservationTargetImporter selectedImporter = null;
    private List<ObservationTarget> importedTargets = null;
    private ObservationTargetListComposite<EObjectReferencesList<ObservationTarget>, EObjectReferencesList<ObservationTarget>, ObservationTarget> observationTargetListComposite;

    public ObservationImporterWizardPage(OrbitAnalysisData orbitAnalysisData) {
        super(WIZARD_PAGE_ID);
        this.setTitle("Select Importer and import Observation Targets.");
        this.orbitAnalysisData = orbitAnalysisData;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group importersGroup = new Group(container, 2048);
        importersGroup.setText("Available Importers");
        importersGroup.setLayout((Layout)new GridLayout(1, false));
        importersGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.abstractObservationTargetImporterListComposite = new AbstractObservationTargetImporterListComposite<OrbitAnalysisData>((Composite)importersGroup, 0, null, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__OBSERVATION_IMPORTERS){

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty()) {
                    ObservationImporterWizardPage.this.setSelectedImporter((AbstractObservationTargetImporter)selection.getFirstElement());
                } else {
                    ObservationImporterWizardPage.this.setSelectedImporter(null);
                }
            }

            protected void doNew() {
                MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                settings.getUserDataMap().put("name", ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)ObservationImporterWizardPage.this.orbitAnalysisData, null, (ETypedElement)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__OBSERVATION_IMPORTERS));
                EObjectWizard wizard = new EObjectWizard((EObject)ObservationImporterWizardPage.this.orbitAnalysisData, null, ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__OBSERVATION_IMPORTERS);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                dialog.open();
            }

            protected void doImport() {
                try {
                    ObservationImporterWizardPage.this.importedTargets = ObservationImporterWizardPage.this.selectedImporter.importTargets((IProgressMonitor)new NullProgressMonitor());
                    if (ObservationImporterWizardPage.this.importedTargets != null && ObservationImporterWizardPage.this.importedTargets.size() > 0) {
                        ObservationImporterWizardPage.this.updateLoadedObservation(ObservationImporterWizardPage.this.importedTargets);
                        String message = "Imported <" + ObservationImporterWizardPage.this.importedTargets.size() + "> Observation Target(s).";
                        Logger.info(message);
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"Import Completed", (String)message);
                    } else {
                        ObservationImporterWizardPage.this.importedTargets.clear();
                        ObservationImporterWizardPage.this.updateLoadedObservation(ObservationImporterWizardPage.this.importedTargets);
                        String message = "Could not import any Observation Targets!";
                        Logger.error(message);
                        MessageDialog.openError((Shell)this.getShell(), (String)"Import failed", (String)message);
                    }
                }
                catch (Exception e) {
                    ObservationImporterWizardPage.this.importedTargets = null;
                    ObservationImporterWizardPage.this.updateLoadedObservation(ObservationImporterWizardPage.this.importedTargets);
                    String message = "An exception occured during import : " + e.getMessage();
                    Logger.error(message, (Throwable)e);
                    MessageDialog.openError((Shell)this.getShell(), (String)"Import failed !", (String)message);
                }
                ObservationImporterWizardPage.this.setPageComplete(ObservationImporterWizardPage.this.importedTargets != null && ObservationImporterWizardPage.this.importedTargets.size() > 0);
            }
        };
        this.abstractObservationTargetImporterListComposite.setLayoutData(new GridData(4, 4, true, false));
        this.abstractObservationTargetImporterListComposite.setRootEObject((EObject)this.orbitAnalysisData);
        Group importedTargetsGroup = new Group(container, 2048);
        importedTargetsGroup.setText("Imported Targets");
        importedTargetsGroup.setLayout((Layout)new GridLayout(1, false));
        importedTargetsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setCollectionSectionTitle("Observation Targets");
        settings.setDetailSectionTitle("Details");
        settings.setButtonsSectionDisplayed(false);
        this.observationTargetListComposite = new ObservationTargetListComposite((Composite)importedTargetsGroup, 0, null, (EStructuralFeature)ApogyCommonEMFPackage.Literals.EOBJECT_REFERENCES_LIST__EOBJECTS, settings);
        this.observationTargetListComposite.setLayoutData(new GridData(4, 128, true, false, 2, 1));
        this.setControl((Control)container);
    }

    public boolean canFlipToNextPage() {
        return this.importedTargets != null;
    }

    public List<ObservationTarget> getImportedTargets() {
        return this.importedTargets;
    }

    public void setSelectedImporter(AbstractObservationTargetImporter selectedImporter) {
        this.selectedImporter = selectedImporter;
    }

    protected void observationsImported(List<ObservationTarget> importedTargets) {
    }

    private void updateLoadedObservation(List<ObservationTarget> importedTargets) {
        EObjectReferencesList eObjectReferencesList = ApogyCommonEMFFactory.eINSTANCE.createEObjectReferencesList();
        if (importedTargets != null) {
            eObjectReferencesList.getEObjects().addAll(importedTargets);
        }
        this.observationTargetListComposite.setRootEObject((EObject)eObjectReferencesList);
        this.observationsImported(importedTargets);
    }
}

