/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.JME3PrimitivesUtilities;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksiteNode;
import org.eclipse.apogy.core.environment.earth.surface.ui.jme3.EnvironmentUIJME3Utilities;
import org.eclipse.apogy.core.environment.earth.surface.ui.scene_objects.EarthSurfaceWorksiteSceneObject;
import org.eclipse.apogy.core.environment.surface.ui.jme3.SurfaceEnvironmentJMEConstants;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthSurfaceWorksiteNodeJME3Object
extends DefaultJME3SceneObject<EarthSurfaceWorksiteNode>
implements EarthSurfaceWorksiteSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(EarthSurfaceWorksiteNodeJME3Object.class);
    private static ColorRGBA HORIZON_COLOR = new ColorRGBA(0.0753f, 0.04414f, 0.015686f, 1.0f);
    private Adapter adapter;
    private boolean axisVisible = true;
    private float axisLength = 1.0f;
    private boolean planeVisible = true;
    private float gridSize = 10.0f;
    private float planeSize = 100.0f;
    private boolean azimuthVisible = true;
    private boolean azimuthLinesVisible = true;
    private boolean elevationLinesVisible = true;
    private boolean horizonMaskVisible = true;
    private final AssetManager assetManager = this.jme3Application.getAssetManager();
    private Geometry gridGeometry = null;
    private Geometry axisGeometry = null;
    private Geometry horizon;
    private com.jme3.scene.Node skyNode = null;
    private com.jme3.scene.Node azimuthDisplayNode = null;
    private com.jme3.scene.Node azimuthDisplayCirclesNode = null;
    private com.jme3.scene.Node elevationDisplayCirclesNode = null;

    public EarthSurfaceWorksiteNodeJME3Object(EarthSurfaceWorksiteNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.createGeometry();
        node.eAdapters().add((Object)this.getAdapter());
        if (node.getWorksite() instanceof EarthSurfaceWorksite) {
            EarthSurfaceWorksite earthSurfaceWorksite = (EarthSurfaceWorksite)node.getWorksite();
            earthSurfaceWorksite.eAdapters().add((Object)this.getAdapter());
            this.updateSkyTransform(earthSurfaceWorksite.getXAxisAzimuth());
        }
    }

    public void updateGeometry(float tpf) {
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.gridGeometry);
        geometries.add(this.axisGeometry);
        geometries.add(this.horizon);
        return geometries;
    }

    public void setPlaneVisible(boolean newPlaneVisible) {
        this.planeVisible = newPlaneVisible;
        Logger.info("Setting Plane visibility to <" + newPlaneVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry != null) {
                    if (EarthSurfaceWorksiteNodeJME3Object.this.planeVisible) {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry);
                    } else {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry);
                    }
                }
                return null;
            }
        });
    }

    public void setPlaneParameters(double newGridSize, double newPlaneSize) {
        Logger.info("Setting Plane grid size to <" + newGridSize + "> and grid size to <" + newPlaneSize + ">");
        if (newGridSize > 0.0 && newPlaneSize > 0.0) {
            this.gridSize = (float)newGridSize;
            this.planeSize = (float)newPlaneSize;
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry != null) {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry);
                    }
                    EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry = EarthSurfaceWorksiteNodeJME3Object.this.createGridGeometry();
                    if (EarthSurfaceWorksiteNodeJME3Object.this.planeVisible) {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry);
                    } else {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry);
                    }
                    return null;
                }
            });
        } else {
            Logger.error("Failed to set Plane grid size to <" + newGridSize + "> and grid size to <" + newPlaneSize + ">.");
        }
    }

    public void setAxisVisible(final boolean newAxisVisible) {
        this.axisVisible = newAxisVisible;
        Logger.info("Setting Axis visibility to <" + newAxisVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry != null) {
                    if (EarthSurfaceWorksiteNodeJME3Object.this.axisVisible) {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry);
                    } else {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry);
                    }
                } else {
                    Logger.error("Failed to set Axis visibility to <" + newAxisVisible + ">.");
                }
                return null;
            }
        });
    }

    public void setAxisLength(final double newLength) {
        this.axisLength = (float)newLength;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Logger.info("Setting Axis Length to <" + newLength + ">.");
                try {
                    if (EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry != null) {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry);
                    }
                    EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry = JME3Utilities.createAxis3D((float)EarthSurfaceWorksiteNodeJME3Object.this.axisLength, (AssetManager)EarthSurfaceWorksiteNodeJME3Object.this.assetManager);
                    if (EarthSurfaceWorksiteNodeJME3Object.this.axisVisible) {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Failed to setAxisLength(" + newLength + ").", t);
                }
                return null;
            }
        });
    }

    public void setAzimuthVisible(final boolean newAzimuthVisible) {
        this.azimuthVisible = newAzimuthVisible;
        Logger.info("Setting Azimuth visibility to <" + newAzimuthVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthSurfaceWorksiteNodeJME3Object.this.skyNode != null) {
                    if (EarthSurfaceWorksiteNodeJME3Object.this.azimuthVisible) {
                        EarthSurfaceWorksiteNodeJME3Object.this.skyNode.attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.azimuthDisplayNode);
                    } else {
                        EarthSurfaceWorksiteNodeJME3Object.this.skyNode.detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.azimuthDisplayNode);
                    }
                } else {
                    Logger.error("Failed to set Azimuth visibility to <" + newAzimuthVisible + ">.");
                }
                return null;
            }
        });
    }

    public void setElevationLinesVisible(final boolean newElevationLinesVisible) {
        this.elevationLinesVisible = newElevationLinesVisible;
        Logger.info("Setting Elevation Lines visibility to <" + newElevationLinesVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthSurfaceWorksiteNodeJME3Object.this.skyNode != null) {
                    if (EarthSurfaceWorksiteNodeJME3Object.this.elevationLinesVisible) {
                        EarthSurfaceWorksiteNodeJME3Object.this.skyNode.attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.elevationDisplayCirclesNode);
                    } else {
                        EarthSurfaceWorksiteNodeJME3Object.this.skyNode.detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.elevationDisplayCirclesNode);
                    }
                } else {
                    Logger.error("Failed to set Elevation Lines visibility to <" + newElevationLinesVisible + ">.");
                }
                return null;
            }
        });
    }

    public void setAzimuthLinesVisible(final boolean newAzimuthLinesVisible) {
        this.azimuthLinesVisible = newAzimuthLinesVisible;
        Logger.info("Setting Azimuth Lines visibility to <" + newAzimuthLinesVisible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthSurfaceWorksiteNodeJME3Object.this.skyNode != null) {
                    if (EarthSurfaceWorksiteNodeJME3Object.this.azimuthLinesVisible) {
                        EarthSurfaceWorksiteNodeJME3Object.this.skyNode.attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.azimuthDisplayCirclesNode);
                    } else {
                        EarthSurfaceWorksiteNodeJME3Object.this.skyNode.detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.azimuthDisplayCirclesNode);
                    }
                } else {
                    Logger.error("Failed to set Azimuth Lines visibility to <" + newAzimuthLinesVisible + ">.");
                }
                return null;
            }
        });
    }

    public void setHorizonMaskVisible(final boolean visible) {
        this.horizonMaskVisible = visible;
        Logger.info("Setting Horizon Mask visibility to <" + visible + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthSurfaceWorksiteNodeJME3Object.this.skyNode != null) {
                    if (EarthSurfaceWorksiteNodeJME3Object.this.horizonMaskVisible) {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.horizon);
                    } else {
                        EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.horizon);
                    }
                } else {
                    Logger.error("Failed to set Horizon Mask visibility to <" + visible + ">.");
                }
                return null;
            }
        });
    }

    public boolean isHorizonMaskVisible() {
        return this.horizonMaskVisible;
    }

    private void createGeometry() {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (EarthSurfaceWorksiteNodeJME3Object.this.horizon != null) {
                    EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.horizon);
                }
                if (EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry != null) {
                    EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry);
                }
                if (EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry != null) {
                    EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry);
                }
                if (EarthSurfaceWorksiteNodeJME3Object.this.skyNode != null) {
                    EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.skyNode);
                }
                EarthSurfaceWorksiteNodeJME3Object.this.horizon = EarthSurfaceWorksiteNodeJME3Object.this.createHorizon();
                EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.horizon);
                EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry = JME3Utilities.createAxis3D((float)EarthSurfaceWorksiteNodeJME3Object.this.axisLength, (AssetManager)EarthSurfaceWorksiteNodeJME3Object.this.assetManager);
                EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry.setShadowMode(RenderQueue.ShadowMode.Off);
                EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.axisGeometry);
                EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry = EarthSurfaceWorksiteNodeJME3Object.this.createGridGeometry();
                EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.gridGeometry);
                EarthSurfaceWorksiteNodeJME3Object.this.skyNode = EarthSurfaceWorksiteNodeJME3Object.this.createSkyNode();
                EarthSurfaceWorksiteNodeJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthSurfaceWorksiteNodeJME3Object.this.skyNode);
                return null;
            }
        });
    }

    private com.jme3.scene.Node createSkyNode() {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Worksite Sky");
        this.azimuthDisplayNode = EnvironmentUIJME3Utilities.createAzimuthDisplay(this.assetManager);
        node.attachChild((Spatial)this.azimuthDisplayNode);
        this.azimuthDisplayCirclesNode = EnvironmentUIJME3Utilities.createAzimuthCirclesDisplay(this.assetManager);
        node.attachChild((Spatial)this.azimuthDisplayCirclesNode);
        this.elevationDisplayCirclesNode = EnvironmentUIJME3Utilities.createElevationCirclesDisplay(this.assetManager);
        node.attachChild((Spatial)this.elevationDisplayCirclesNode);
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        if (((EarthSurfaceWorksiteNode)this.getTopologyNode()).getWorksite() instanceof EarthSurfaceWorksite) {
            EarthSurfaceWorksite earthSurfaceWorksite = (EarthSurfaceWorksite)((EarthSurfaceWorksiteNode)this.getTopologyNode()).getWorksite();
            m.rotZ(-earthSurfaceWorksite.getXAxisAzimuth());
        }
        node.setLocalTransform(JME3Utilities.createTransform((Matrix4d)m));
        return node;
    }

    private void updateSkyTransform(double newXAxisAzimuthDegrees) {
        if (this.skyNode != null) {
            Matrix4d m = new Matrix4d();
            m.setIdentity();
            m.rotZ(-newXAxisAzimuthDegrees);
            this.skyNode.setLocalTransform(JME3Utilities.createTransform((Matrix4d)m));
        }
    }

    private Geometry createGridGeometry() {
        Mesh gridMesh = EnvironmentUIJME3Utilities.createGrid(this.gridSize, this.planeSize);
        Geometry geometry = new Geometry("Grid", gridMesh);
        geometry.setShadowMode(RenderQueue.ShadowMode.Off);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", SurfaceEnvironmentJMEConstants.DEFAULT_GRID_COLOR.clone());
        geometry.setMaterial(mat);
        return geometry;
    }

    private Geometry createHorizon() {
        Mesh horizonMesh = JME3PrimitivesUtilities.createSphericalCap((float)17000.0f, (float)((float)Math.toRadians(-90.0)), (float)0.0f, (int)32);
        horizonMesh.updateBound();
        horizonMesh.updateCounts();
        Geometry geometry = new Geometry("Horizon", horizonMesh);
        geometry.setMaterial(this.createHorizonMaterial());
        geometry.setShadowMode(RenderQueue.ShadowMode.Off);
        return geometry;
    }

    private Material createHorizonMaterial() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", HORIZON_COLOR.clone());
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        return mat;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof EarthSurfaceWorksiteNode) {
                        if (msg.getFeatureID(EarthSurfaceWorksiteNode.class) == 6) {
                            if (msg.getOldValue() instanceof Worksite) {
                                Worksite oldWorksite = (Worksite)msg.getOldValue();
                                oldWorksite.eAdapters().remove((Object)EarthSurfaceWorksiteNodeJME3Object.this.getAdapter());
                            }
                            if (msg.getNewValue() instanceof Worksite) {
                                Worksite newWorksite = (Worksite)msg.getNewValue();
                                newWorksite.eAdapters().add((Object)EarthSurfaceWorksiteNodeJME3Object.this.getAdapter());
                                if (newWorksite instanceof EarthSurfaceWorksite) {
                                    EarthSurfaceWorksite earthSurfaceWorksite = (EarthSurfaceWorksite)newWorksite;
                                    EarthSurfaceWorksiteNodeJME3Object.this.updateSkyTransform(earthSurfaceWorksite.getXAxisAzimuth());
                                }
                            }
                        }
                    } else if (msg.getNotifier() instanceof EarthSurfaceWorksite && msg.getFeatureID(EarthSurfaceWorksite.class) == 10) {
                        double newXAxisAzimuthDegrees = msg.getNewDoubleValue();
                        EarthSurfaceWorksiteNodeJME3Object.this.updateSkyTransform(newXAxisAzimuthDegrees);
                    }
                }
            };
        }
        return this.adapter;
    }
}

