/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.composites;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.WorksitesList;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.ui.ApogyCoreEnvironmentSurfaceEarthUIFactory;
import org.eclipse.apogy.core.environment.earth.surface.ui.EarthSurfaceWorksiteSettings;
import org.eclipse.apogy.core.environment.earth.surface.ui.wizards.ImportEarthSurfaceWorksiteWizard;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthSurfaceWorksiteListComposite
extends EMFFormsEListComposite<ApogyEnvironment, WorksitesList, EarthSurfaceWorksite> {
    private static final Logger Logger = LoggerFactory.getLogger(EarthSurfaceWorksiteListComposite.class);

    public EarthSurfaceWorksiteListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__WORKSITES_LIST}), (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.WORKSITES_LIST__WORKSITES, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createActivateButton(parent, style);
        this.createImportButton(parent, style);
        this.createExportButton(parent, style);
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return EarthSurfaceWorksiteListComposite.this.getEStructuralFeature();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof WorksitesList) {
                    WorksitesList worksitesList = (WorksitesList)parentElement;
                    return this.filterEarthSurfaceWorksite(worksitesList).toArray();
                }
                return null;
            }

            private List<EarthSurfaceWorksite> filterEarthSurfaceWorksite(WorksitesList worksitesList) {
                ArrayList<EarthSurfaceWorksite> earthSurfaceWorksites = new ArrayList<EarthSurfaceWorksite>();
                for (AbstractWorksite worksite : worksitesList.getWorksites()) {
                    if (!(worksite instanceof EarthSurfaceWorksite)) continue;
                    earthSurfaceWorksites.add((EarthSurfaceWorksite)worksite);
                }
                return earthSurfaceWorksites;
            }
        };
    }

    protected AdapterFactoryLabelProvider.StyledLabelProvider createLabelProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryLabelProvider.StyledLabelProvider(adapterFactory, (Viewer)this.getViewer()){

            public String getText(Object object) {
                String text = super.getText(object);
                if (object instanceof EarthSurfaceWorksite) {
                    EarthSurfaceWorksite earthSurfaceWorksite = (EarthSurfaceWorksite)object;
                    if (EarthSurfaceWorksiteListComposite.this.getRootEObject() != null && ((ApogyEnvironment)EarthSurfaceWorksiteListComposite.this.getRootEObject()).getActiveWorksite() == earthSurfaceWorksite) {
                        text = "<Active> " + text;
                    }
                }
                return text;
            }
        };
    }

    protected void doNew() {
        EarthSurfaceWorksiteSettings earthSurfaceWorksiteSettings = ApogyCoreEnvironmentSurfaceEarthUIFactory.eINSTANCE.createEarthSurfaceWorksiteSettings();
        earthSurfaceWorksiteSettings.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName(this.getResolvedEObject(), null, (ETypedElement)ApogyCoreEnvironmentPackage.Literals.WORKSITES_LIST__WORKSITES));
        EObjectWizard wizard = new EObjectWizard((EObject)((WorksitesList)this.getResolvedEObject()), null, ApogyCoreEnvironmentPackage.Literals.WORKSITES_LIST__WORKSITES, ApogySurfaceEnvironmentPackage.Literals.SURFACE_WORKSITE, (EClassSettings)earthSurfaceWorksiteSettings);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void doDelete(EarthSurfaceWorksite worksite) {
        try {
            ApogyEnvironment apogyEnvironment;
            if (worksite.getWorksitesList().eContainer() instanceof ApogyEnvironment && (apogyEnvironment = (ApogyEnvironment)worksite.getWorksitesList().eContainer()).getActiveWorksite() == worksite) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)apogyEnvironment, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_WORKSITE, null, true);
            }
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)worksite.getWorksitesList(), (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.WORKSITES_LIST__WORKSITES, (Object)worksite, true);
        }
        catch (Exception e) {
            Logger.error("Unable to delete the Earth Surface Worksite <" + worksite.getName() + ">.", (Throwable)e);
        }
    }

    protected void doActivate(List<EarthSurfaceWorksite> list) {
        if (list.size() > 0) {
            EarthSurfaceWorksite worksite = list.get(0);
            ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getRootEObject(), (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_WORKSITE, (Object)worksite);
        }
        this.getViewer().refresh(true);
    }

    protected void doImport() {
        ApogyEnvironment env = ApogyCoreEnvironmentFacade.INSTANCE.getActiveApogyEnvironment();
        ImportEarthSurfaceWorksiteWizard wizard = new ImportEarthSurfaceWorksiteWizard(env.getWorksitesList());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void doExport() {
        if (this.getSelectedItemObjects().size() > 0) {
            EarthSurfaceWorksite tmp = (EarthSurfaceWorksite)this.getSelectedItemObjects().get(0);
            EarthSurfaceWorksite worksite = (EarthSurfaceWorksite)EcoreUtil.copy((EObject)tmp);
            try {
                FileDialog fileChooser = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                String defaultFilename = worksite.getName();
                if (defaultFilename != null) {
                    fileChooser.setFileName(defaultFilename);
                }
                String currentDir = System.getProperty("user.dir");
                fileChooser.setText("Save Worksite to File");
                fileChooser.setFilterPath(currentDir);
                fileChooser.setFilterExtensions(new String[]{"*.ws"});
                String filename = fileChooser.open();
                if (filename != null) {
                    Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
                    Map m = reg.getExtensionToFactoryMap();
                    m.put("key", new XMIResourceFactoryImpl());
                    ResourceSetImpl resSet = new ResourceSetImpl();
                    Resource resource = resSet.createResource(URI.createFileURI((String)filename));
                    resource.getContents().add((Object)worksite);
                    resource.save(Collections.EMPTY_MAP);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

