/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface;

import java.util.Date;
import javax.vecmath.Point3d;
import org.eclipse.apogy.core.environment.EquatorialCoordinates;
import org.eclipse.apogy.core.environment.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.EclipticCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFactory;
import org.eclipse.emf.ecore.EObject;

public interface AstronomyUtils
extends EObject {
    public static final AstronomyUtils INSTANCE = ApogyEarthSurfaceEnvironmentFactory.eINSTANCE.createAstronomyUtils();

    public EquatorialCoordinates getSunEquatorialPosition(double var1);

    public HorizontalCoordinates getHorizontalSunPosition(Date var1, double var2, double var4);

    public EquatorialCoordinates getMoonEquatorialPosition(double var1);

    public EquatorialCoordinates getMoonTopocentricEquatorialPosition(Date var1, double var2, double var4);

    public HorizontalCoordinates getHorizontalMoonPosition(Date var1, double var2, double var4);

    public double getTimeSinceJ2000(double var1);

    public double getLocalSideralTime(Date var1, double var2);

    public double getUTCDecimalHours(Date var1);

    public HorizontalCoordinates convertToHorizontalCoordinates(EquatorialCoordinates var1, double var2, double var4, Date var6);

    public double convertTimeToAngle(int var1, int var2, int var3);

    public double clampAngleToZero2PI(double var1);

    public EquatorialCoordinates convertToEquatorialCoordinates(EclipticCoordinates var1);

    public EclipticCoordinates convertToEclipticCoordinates(EquatorialCoordinates var1);

    public Point3d convertFromEquatorialRectangularToEclipticRectangular(Point3d var1);

    public Point3d convertFromEclipticRectangularToEquatorialRectangular(Point3d var1);

    public EclipticCoordinates convertFromEclipticRectangularToEclipticCoordinates(Point3d var1);

    public EquatorialCoordinates convertFromEquatorialRectangularToEquatorialCoordinates(Point3d var1);

    public Point3d convertFromEquatorialCoordinatesToEquatorialRectangular(EquatorialCoordinates var1);

    public double convertAUtoMeters(double var1);

    public double getMaximumSunAltitude(double var1);

    public String convertToHHmmssString(double var1);

    public Date getSunRiseTime(Date var1, double var2, double var4);

    public Date getSunSetTime(Date var1, double var2, double var4);

    public Date getSunHighestElevationTime(Date var1, double var2, double var4);
}

