/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.impl;

import org.eclipse.apogy.core.environment.earth.surface.impl.AtmosphereUtilsImpl;

public class AtmosphereUtilsCustomImpl
extends AtmosphereUtilsImpl {
    public static final double MEAN_SUN_APPARENT_ANGULAR_DIAMETER = Math.toRadians(0.5);

    @Override
    public double getAirMass(double sunAltitudeAngle) {
        double altitude = sunAltitudeAngle;
        if (sunAltitudeAngle >= 0.0) {
            double theta = Math.toRadians(90.0) - altitude;
            double airMass = 1.0 / (Math.cos(theta) + 0.50572 * Math.pow(96.07995 - Math.toDegrees(theta), -1.6364));
            return airMass;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getDirectSunIntensity(double sunAltitudeAngle, double heightAboveSeaLevel) {
        double airMass = 0.0;
        airMass = sunAltitudeAngle > 0.0 ? this.getAirMass(sunAltitudeAngle) : this.getAirMass(0.0);
        if (sunAltitudeAngle >= -(MEAN_SUN_APPARENT_ANGULAR_DIAMETER / 2.0)) {
            double heightInKm = heightAboveSeaLevel / 1000.0;
            double a = 0.14;
            double directSunIntensity = 1353.0 * ((1.0 - a * heightInKm) * Math.pow(0.7, Math.pow(airMass, 0.678)) + a * heightInKm);
            if (sunAltitudeAngle <= MEAN_SUN_APPARENT_ANGULAR_DIAMETER / 2.0) {
                double r = MEAN_SUN_APPARENT_ANGULAR_DIAMETER / 2.0;
                double sunDiskArea = Math.PI * r * r;
                double visibleSunDiskArea = 0.0;
                double d = Math.abs(sunAltitudeAngle);
                double theta = 2.0 * Math.acos(d / r);
                if (sunAltitudeAngle >= 0.0) {
                    double hiddenSunDiskArea = r * r / 2.0 * (theta - Math.sin(theta));
                    visibleSunDiskArea = sunDiskArea - hiddenSunDiskArea;
                } else {
                    visibleSunDiskArea = r * r / 2.0 * (theta - Math.sin(theta));
                }
                double sunApparentFraction = visibleSunDiskArea / sunDiskArea;
                directSunIntensity *= sunApparentFraction;
            }
            return directSunIntensity;
        }
        return 0.0;
    }

    @Override
    public double getDiffuseSunIntensity(double sunAltitudeAngle, double heightAboveSeaLevel) {
        return 0.1 * this.getDirectSunIntensity(sunAltitudeAngle, heightAboveSeaLevel);
    }

    @Override
    public double getAtmosphereRefractionCorrection(double geometricAltitude) {
        double atmosphereRefractionCorrection = 0.0;
        if (geometricAltitude >= Math.toRadians(85.0)) {
            atmosphereRefractionCorrection = 0.0;
        } else if (geometricAltitude >= Math.toRadians(5.0) && geometricAltitude < Math.toRadians(85.0)) {
            double correctionInArcSeconds = 58.1 / Math.tan(geometricAltitude) - 0.07 / Math.pow(Math.tan(geometricAltitude), 3.0) + 8.6E-5 / Math.pow(Math.tan(geometricAltitude), 5.0);
            atmosphereRefractionCorrection = Math.toRadians(correctionInArcSeconds / 3600.0);
        } else if (geometricAltitude >= Math.toRadians(-0.575) && geometricAltitude < Math.toRadians(5.0)) {
            double elevationInDegrees = Math.toDegrees(geometricAltitude);
            double correctionInArcSeconds = 1735.0 - 518.2 * elevationInDegrees + 103.4 * Math.pow(elevationInDegrees, 2.0) - 12.79 * Math.pow(elevationInDegrees, 3.0) + 0.711 * Math.pow(elevationInDegrees, 4.0);
            atmosphereRefractionCorrection = Math.toRadians(correctionInArcSeconds / 3600.0);
        } else {
            double correctionInArcSeconds = -20.774 / Math.tan(geometricAltitude);
            atmosphereRefractionCorrection = Math.toRadians(correctionInArcSeconds / 3600.0);
        }
        return atmosphereRefractionCorrection;
    }
}

