/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.composites;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.awt.WorldWindowGLJPanel;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.view.firstperson.BasicFlyView;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.AbstractEarthViewPoint;
import org.eclipse.apogy.core.environment.earth.ui.AbstractWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfigurationList;
import org.eclipse.apogy.core.environment.earth.ui.composites.EarthViewConfigurationComposite;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthViewComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(EarthViewComposite.class);
    private EarthViewMode mode = EarthViewMode.ROUND;
    private WorldWindowGLJPanel worldWindowGLJPanel;
    private EarthViewConfigurationComposite earthViewConfigurationComposite;
    private EarthViewConfigurationList earthViewConfigurationList;
    private EarthViewConfiguration earthViewConfiguration;
    private AbstractEarthViewPoint activeViewPoint;
    private Adapter earthViewConfigurationAdapter;
    private Adapter viewPointAdapter;
    private final List<AbstractWorldWindLayer> layers = new ArrayList<AbstractWorldWindLayer>();

    public EarthViewComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 2304);
        Composite left = new Composite((Composite)sashForm, 0x1000000);
        left.setLayout((Layout)new FillLayout());
        Frame worldFrame = SWT_AWT.new_Frame((Composite)left);
        Panel panel = new Panel(new BorderLayout());
        worldFrame.add(panel);
        panel.add((Component)this.getWorldWindowGLJPanel(), "Center");
        worldFrame.requestFocus();
        this.getWorldWindowGLJPanel().addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent event) {
            }

            @Override
            public void mousePressed(MouseEvent event) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                if (EarthViewComposite.this.getEarthViewConfiguration() != null) {
                    Point p = event.getPoint();
                    Vec4 screenCoords = new Vec4((double)p.x, (double)p.y);
                    Vec4 cartesian = EarthViewComposite.this.getWorldWindowGLJPanel().getView().unProject(screenCoords);
                    Globe g = EarthViewComposite.this.getWorldWindowGLJPanel().getView().getGlobe();
                    Position position = g.computePositionFromPoint(cartesian);
                    GeographicCoordinates latestPosition = WorldWindUtils.convertToGeographicCoordinates(position);
                    latestPosition.setElevation(0.0);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)EarthViewComposite.this.getEarthViewConfiguration(), (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.EARTH_VIEW_CONFIGURATION__LAST_SELECTED_POSITION, (Object)latestPosition, true);
                    EarthViewComposite.this.newPositionSelected(latestPosition);
                }
            }
        });
        Composite right = new Composite((Composite)sashForm, 0);
        right.setLayout((Layout)new FillLayout(512));
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setDetailSectionTitle("Earth View Layer Details");
        settings.setCollectionSectionTitle("Earth View Layers");
        this.earthViewConfigurationComposite = new EarthViewConfigurationComposite(right, 0, settings);
        this.earthViewConfigurationComposite.setRootEObject((EObject)this.getEarthViewConfiguration());
        sashForm.setWeights(new int[]{7, 3});
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (EarthViewComposite.this.activeViewPoint != null) {
                    EarthViewComposite.this.activeViewPoint.eAdapters().remove((Object)EarthViewComposite.this.getViewPointAdapter());
                    if (EarthViewComposite.this.activeViewPoint.getEyePosition() != null) {
                        EarthViewComposite.this.activeViewPoint.getEyePosition().eAdapters().remove((Object)EarthViewComposite.this.getViewPointAdapter());
                    }
                }
            }
        });
    }

    protected void newPositionSelected(GeographicCoordinates newGeographicCoordinates) {
    }

    public void setEarthViewConfiguration(EarthViewConfiguration newEarthViewConfiguration) {
        if (this.earthViewConfiguration != null) {
            this.earthViewConfiguration.eAdapters().remove((Object)this.getEarthViewConfigurationAdapter());
        }
        this.removeAllLayers();
        this.earthViewConfiguration = newEarthViewConfiguration;
        if (newEarthViewConfiguration != null) {
            this.initializeEarthViewConfiguration(newEarthViewConfiguration);
            newEarthViewConfiguration.eAdapters().add((Object)this.getEarthViewConfigurationAdapter());
        }
        if (this.earthViewConfigurationComposite != null && !this.earthViewConfigurationComposite.isDisposed()) {
            this.earthViewConfigurationComposite.setRootEObject((EObject)newEarthViewConfiguration);
        }
        this.newEarthViewConfigurationSelected(newEarthViewConfiguration);
    }

    public EarthViewConfiguration getEarthViewConfiguration() {
        return this.earthViewConfiguration;
    }

    public EarthViewConfigurationList getEarthViewConfigurationList() {
        return this.earthViewConfigurationList;
    }

    public void setEarthViewConfigurationList(EarthViewConfigurationList earthViewConfigurationList) {
        this.earthViewConfigurationList = earthViewConfigurationList;
    }

    public EarthViewMode getEarthViewMode() {
        return this.mode;
    }

    public void setEarthViewMode(EarthViewMode mode) {
        this.mode = mode;
        if (mode == EarthViewMode.FLAT) {
            Configuration.setValue((String)"gov.nasa.worldwind.avkey.GlobeClassName", (Object)EarthFlat.class.getName());
            Configuration.setValue((String)"gov.nasa.worldwind.avkey.ViewClassName", (Object)FlatOrbitView.class.getName());
        } else {
            Configuration.setValue((String)"gov.nasa.worldwind.avkey.GlobeClassName", (Object)Earth.class.getName());
            Configuration.setValue((String)"gov.nasa.worldwind.avkey.ViewClassName", (Object)BasicOrbitView.class.getName());
        }
        this.getWorldWindowGLJPanel().setModel((Model)new BasicModel());
        this.getWorldWindowGLJPanel().redraw();
        this.removeAllLayers();
        this.initializeEarthViewConfiguration(this.getEarthViewConfiguration());
        this.updateAllLayers();
    }

    public void setActiveViewPoint(AbstractEarthViewPoint newViewPoint) {
        if (this.activeViewPoint != null) {
            this.activeViewPoint.eAdapters().remove((Object)this.getViewPointAdapter());
            if (this.activeViewPoint.getEyePosition() != null) {
                this.activeViewPoint.getEyePosition().eAdapters().remove((Object)this.getViewPointAdapter());
            }
        }
        this.activeViewPoint = newViewPoint;
        if (newViewPoint != null) {
            this.moveSmoothlyToViewpoint(newViewPoint.getEyePosition());
            try {
                newViewPoint.initialize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            newViewPoint.eAdapters().add((Object)this.getViewPointAdapter());
            if (newViewPoint.getEyePosition() != null) {
                newViewPoint.getEyePosition().eAdapters().add((Object)this.getViewPointAdapter());
            }
            switch (newViewPoint.getNavigationType().getValue()) {
                case 0: {
                    this.getWorldWindowGLJPanel().setView((View)new BasicOrbitView());
                    break;
                }
                case 1: {
                    this.getWorldWindowGLJPanel().setView((View)new BasicFlyView());
                    break;
                }
            }
        }
    }

    public AbstractEarthViewPoint getActiveViewPoint() {
        return this.activeViewPoint;
    }

    protected void moveSmoothlyToViewpoint(final GeographicCoordinates geographicCoordinates) {
        if (geographicCoordinates != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Position newPosition = Position.fromRadians((double)geographicCoordinates.getLatitude(), (double)geographicCoordinates.getLongitude(), (double)0.0);
                    EarthViewComposite.this.getWorldWindowGLJPanel().getView().goTo(newPosition, geographicCoordinates.getElevation());
                }
            });
        }
    }

    protected void jumpTo(final GeographicCoordinates geographicCoordinates) {
        if (geographicCoordinates != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Position newPosition = Position.fromRadians((double)geographicCoordinates.getLatitude(), (double)geographicCoordinates.getLongitude(), (double)geographicCoordinates.getElevation());
                    EarthViewComposite.this.getWorldWindowGLJPanel().getView().setEyePosition(newPosition);
                    EarthViewComposite.this.getWorldWindowGLJPanel().redrawNow();
                }
            });
        }
    }

    protected void updateOrientation(final double heading, final double pitch, final double roll) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EarthViewComposite.this.getWorldWindowGLJPanel().getView().setHeading(Angle.fromDegrees((double)heading));
                EarthViewComposite.this.getWorldWindowGLJPanel().getView().setPitch(Angle.fromDegrees((double)pitch));
                EarthViewComposite.this.getWorldWindowGLJPanel().getView().setRoll(Angle.fromDegrees((double)roll));
                EarthViewComposite.this.getWorldWindowGLJPanel().redraw();
            }
        });
    }

    protected void newEarthViewConfigurationSelected(EarthViewConfiguration newEarthViewConfiguration) {
    }

    protected void addLayer(AbstractWorldWindLayer abstractWorldWindLayer, boolean redraw) {
        abstractWorldWindLayer.initialise();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)abstractWorldWindLayer, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__WORLD_WINDOW, (Object)this.getWorldWindowGLJPanel(), true);
        if (abstractWorldWindLayer.getRenderableLayer() != null) {
            try {
                abstractWorldWindLayer.update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getWorldWindowGLJPanel().getModel().getLayers().add((Layer)abstractWorldWindLayer.getRenderableLayer());
            if (redraw) {
                this.getWorldWindowGLJPanel().redraw();
            }
        }
        this.layers.add(abstractWorldWindLayer);
    }

    protected void removeLayer(AbstractWorldWindLayer abstractWorldWindLayer) {
        if (abstractWorldWindLayer.getRenderableLayer() != null) {
            this.getWorldWindowGLJPanel().getModel().getLayers().remove((Layer)abstractWorldWindLayer.getRenderableLayer());
        }
    }

    protected void removeAllLayers() {
        for (AbstractWorldWindLayer layer : this.layers) {
            this.removeLayer(layer);
        }
        this.layers.clear();
    }

    protected void updateAllLayers() {
        for (AbstractWorldWindLayer layer : this.layers) {
            try {
                layer.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void initializeEarthViewConfiguration(EarthViewConfiguration newEarthViewConfiguration) {
        if (newEarthViewConfiguration != null) {
            for (AbstractWorldWindLayer layer : newEarthViewConfiguration.getLayers()) {
                this.addLayer(layer, false);
            }
            this.updateAllLayers();
        }
        this.getWorldWindowGLJPanel().redraw();
    }

    protected WorldWindowGLJPanel getWorldWindowGLJPanel() {
        if (this.worldWindowGLJPanel == null) {
            this.worldWindowGLJPanel = new WorldWindowGLJPanel();
            this.worldWindowGLJPanel.setModel((Model)new BasicModel());
        }
        return this.worldWindowGLJPanel;
    }

    protected Adapter getEarthViewConfigurationAdapter() {
        if (this.earthViewConfigurationAdapter == null) {
            this.earthViewConfigurationAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    block17: {
                        if (!(msg.getNotifier() instanceof EarthViewConfiguration)) break block17;
                        int featureId = msg.getFeatureID(EarthViewConfiguration.class);
                        block2 : switch (featureId) {
                            case 3: {
                                int eventType = msg.getEventType();
                                switch (eventType) {
                                    case 3: {
                                        if (msg.getNewValue() instanceof AbstractWorldWindLayer) {
                                            EarthViewComposite.this.addLayer((AbstractWorldWindLayer)msg.getNewValue(), true);
                                            break block2;
                                        }
                                        break block17;
                                    }
                                    case 5: {
                                        try {
                                            List layers = (List)msg.getNewValue();
                                            for (AbstractWorldWindLayer layer : layers) {
                                                EarthViewComposite.this.addLayer(layer, true);
                                            }
                                            break block17;
                                        }
                                        catch (Throwable t) {
                                            Logger.error(t.getMessage(), t);
                                        }
                                        break block17;
                                    }
                                    case 4: {
                                        if (msg.getOldValue() instanceof AbstractWorldWindLayer) {
                                            EarthViewComposite.this.removeLayer((AbstractWorldWindLayer)msg.getOldValue());
                                            break block2;
                                        }
                                        break block17;
                                    }
                                    case 6: {
                                        try {
                                            List layers = (List)msg.getOldValue();
                                            for (AbstractWorldWindLayer layer : layers) {
                                                EarthViewComposite.this.removeLayer(layer);
                                            }
                                        }
                                        catch (Throwable t) {
                                            Logger.error(t.getMessage(), t);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            };
        }
        return this.earthViewConfigurationAdapter;
    }

    protected Adapter getViewPointAdapter() {
        if (this.viewPointAdapter == null) {
            this.viewPointAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    block8: {
                        block7: {
                            super.notifyChanged(msg);
                            if (!(msg.getNotifier() instanceof AbstractEarthViewPoint)) break block7;
                            AbstractEarthViewPoint abstractEarthViewPoint = (AbstractEarthViewPoint)msg.getNotifier();
                            int featureID = msg.getFeatureID(AbstractEarthViewPoint.class);
                            switch (featureID) {
                                case 3: {
                                    GeographicCoordinates geographicCoordinates;
                                    if (msg.getOldValue() instanceof GeographicCoordinates) {
                                        geographicCoordinates = (GeographicCoordinates)msg.getOldValue();
                                        geographicCoordinates.eAdapters().remove((Object)this);
                                    }
                                    if (msg.getNewValue() instanceof GeographicCoordinates) {
                                        geographicCoordinates = (GeographicCoordinates)msg.getNewValue();
                                        EarthViewComposite.this.jumpTo(geographicCoordinates);
                                        geographicCoordinates.eAdapters().add((Object)EarthViewComposite.this.getViewPointAdapter());
                                        break;
                                    }
                                    break block8;
                                }
                                case 4: 
                                case 5: 
                                case 6: {
                                    EarthViewComposite.this.updateOrientation(abstractEarthViewPoint.getHeadingAngle(), abstractEarthViewPoint.getPitchAngle(), abstractEarthViewPoint.getRoolAngle());
                                    break;
                                }
                            }
                            break block8;
                        }
                        if (msg.getNotifier() instanceof GeographicCoordinates) {
                            GeographicCoordinates geographicCoordinates = (GeographicCoordinates)msg.getNotifier();
                            EarthViewComposite.this.jumpTo(geographicCoordinates);
                        }
                    }
                }
            };
        }
        return this.viewPointAdapter;
    }

    public static enum EarthViewMode {
        ROUND,
        FLAT;

    }
}

