/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.handlers;

import org.eclipse.apogy.core.environment.earth.ui.AbstractEarthViewPoint;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.apogy.core.environment.earth.ui.dialogs.EditViewPointsDialog;
import org.eclipse.apogy.core.environment.earth.ui.parts.EarthViewPart;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EditViewPointsHandler {
    @CanExecute
    public boolean canExecute(MPart part) {
        return ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() != null;
    }

    @Execute
    public void execute(final MPart part) {
        if (part.getObject() instanceof EarthViewPart) {
            final EarthViewPart earthViewPart = (EarthViewPart)((Object)part.getObject());
            Shell shell = Display.getCurrent().getActiveShell();
            EarthViewConfiguration earthViewConfiguration = earthViewPart.getEarthViewConfiguration();
            AbstractEarthViewPoint abstractEarthViewPoint = earthViewPart.getActiveViewPoint();
            EditViewPointsDialog dialog = new EditViewPointsDialog(shell, earthViewConfiguration, abstractEarthViewPoint){

                @Override
                protected void newViewPointActivated(AbstractEarthViewPoint viewPoint) {
                    if (viewPoint != null) {
                        earthViewPart.setActiveViewPoint(viewPoint);
                        String newPartName = EarthViewPart.getPartName(earthViewPart.getEarthViewConfiguration(), viewPoint);
                        part.setLabel(newPartName);
                    }
                }
            };
            try {
                dialog.open();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

