/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.EarthOutlook;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIFactory;
import org.eclipse.apogy.core.environment.earth.ui.EarthOutlookWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.impl.SelectedEarthOutlooksWorldWindLayerImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectedEarthOutlooksWorldWindLayerCustomImpl
extends SelectedEarthOutlooksWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SelectedEarthOutlooksWorldWindLayerCustomImpl.class);
    private boolean busy = false;

    @Override
    public void selectionChanged(final List<EObject> items) {
        if (!(this.isLockSelection() || this.isUpdating() || this.busy)) {
            this.busy = true;
            TransactionalEditingDomain transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this);
            RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

                protected void doExecute() {
                    try {
                        SelectedEarthOutlooksWorldWindLayerCustomImpl.this.setUpdating(true);
                        ArrayList<EarthOutlook> earthOutlooks = new ArrayList<EarthOutlook>();
                        for (EObject eObject : items) {
                            if (!(eObject instanceof EarthOutlook)) continue;
                            earthOutlooks.add((EarthOutlook)eObject);
                        }
                        Logger.info("Selected <" + earthOutlooks.size() + "> Earth Outlook(s).");
                        if (earthOutlooks.size() > 0 || SelectedEarthOutlooksWorldWindLayerCustomImpl.this.isAllowZeroSizeSelection()) {
                            SelectedEarthOutlooksWorldWindLayerCustomImpl.this.getEarthOutlookWorldWindLayers().clear();
                            SelectedEarthOutlooksWorldWindLayerCustomImpl.this.getLayers().clear();
                            ArrayList<EarthOutlookWorldWindLayer> layers = new ArrayList<EarthOutlookWorldWindLayer>();
                            for (EarthOutlook earthOutlook : earthOutlooks) {
                                if (earthOutlook == null) continue;
                                EarthOutlookWorldWindLayer layer = SelectedEarthOutlooksWorldWindLayerCustomImpl.this.createEarthOutlookWorldWindLayer(earthOutlook);
                                layers.add(layer);
                            }
                            SelectedEarthOutlooksWorldWindLayerCustomImpl.this.getEarthOutlookWorldWindLayers().addAll(layers);
                            SelectedEarthOutlooksWorldWindLayerCustomImpl.this.getLayers().addAll(layers);
                        }
                    }
                    catch (Exception e) {
                        Logger.error("Selection changed failed !", (Throwable)e);
                    }
                    SelectedEarthOutlooksWorldWindLayerCustomImpl.this.setUpdating(false);
                    SelectedEarthOutlooksWorldWindLayerCustomImpl.this.busy = false;
                }
            };
            try {
                transactionalEditingDomain.getCommandStack().execute((Command)cmd);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void setColor(RGBA newColor) {
        super.setColor(newColor);
        for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
            layer.setColor(newColor);
        }
    }

    @Override
    public void setShowOutline(boolean newShowOutline) {
        super.setShowOutline(newShowOutline);
        for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
            layer.setShowOutline(newShowOutline);
        }
    }

    @Override
    public void setDisplayBalloon(boolean newDisplayBalloon) {
        super.setDisplayBalloon(newDisplayBalloon);
        for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
            layer.setDisplayBalloon(newDisplayBalloon);
        }
    }

    @Override
    public void setDisplayLocation(boolean newDisplayLocation) {
        super.setDisplayLocation(newDisplayLocation);
        for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
            layer.setDisplayLocation(newDisplayLocation);
        }
    }

    @Override
    public void setOpacity(double newOpacity) {
        super.setOpacity(newOpacity);
        for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
            layer.setOpacity(newOpacity);
        }
    }

    @Override
    public void setShowVisibilityCircle(boolean newShowVisibilityCircle) {
        super.setShowVisibilityCircle(newShowVisibilityCircle);
        for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
            layer.setShowVisibilityCircle(newShowVisibilityCircle);
        }
    }

    @Override
    public void setShowVisibilityCone(boolean newShowVisibilityCone) {
        super.setShowVisibilityCone(newShowVisibilityCone);
        for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
            layer.setShowVisibilityCone(newShowVisibilityCone);
        }
    }

    @Override
    public void setTargetRadius(double newTargetRadius) {
        super.setTargetRadius(newTargetRadius);
        for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
            layer.setTargetRadius(newTargetRadius);
        }
    }

    public void setAutoUpdateEnabled(boolean newAutoUpdateEnabled) {
        super.setAutoUpdateEnabled(newAutoUpdateEnabled);
        for (EarthOutlookWorldWindLayer layer : this.getEarthOutlookWorldWindLayers()) {
            layer.setAutoUpdateEnabled(newAutoUpdateEnabled);
        }
    }

    @Override
    protected void updateRenderableLayer() {
    }

    protected EarthOutlookWorldWindLayer createEarthOutlookWorldWindLayer(EarthOutlook earthOutlook) {
        EarthOutlookWorldWindLayer layer = ApogyEarthEnvironmentUIFactory.eINSTANCE.createEarthOutlookWorldWindLayer();
        String layerName = String.valueOf(this.getName()) + " - " + earthOutlook.getName();
        layer.setAutoUpdateEnabled(false);
        layer.setName(layerName);
        layer.setDisplayBalloon(this.isDisplayBalloon());
        layer.setDisplayLocation(this.isDisplayLocation());
        layer.setColor(this.getColor());
        layer.setOpacity(this.getOpacity());
        layer.setTargetRadius(this.getTargetRadius());
        layer.setShowVisibilityCircle(this.isShowVisibilityCircle());
        layer.setShowVisibilityCone(this.isShowVisibilityCone());
        layer.setReferenceAltitude(this.getReferenceAltitude());
        layer.setAutoUpdateEnabled(true);
        layer.setEarthSurfaceLocation(earthOutlook);
        layer.setVisible(true);
        layer.setDescription("Layer representing location <" + earthOutlook.getName() + ">.");
        return layer;
    }
}

