/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.moon.surface;

import java.util.Date;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFactory;
import org.eclipse.apogy.core.environment.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.moon.surface.impl.MoonSurfaceUtilsImpl;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UTCScale;
import org.orekit.utils.TimeStampedPVCoordinates;

public class MoonSurfaceUtilsCustomImpl
extends MoonSurfaceUtilsImpl {
    public static final double MOON_FLATTENING = 0.0012;
    private static UTCScale utcScale;

    @Override
    public HorizontalCoordinates getHorizontalEarthPosition(Date date, double observerLongitude, double observerLatitude, double observerAltitude) {
        HorizontalCoordinates earthCoordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createHorizontalCoordinates();
        try {
            CelestialBody earth = CelestialBodyFactory.getEarth();
            CelestialBody moon = CelestialBodyFactory.getMoon();
            GeodeticPoint geodeticPoint = new GeodeticPoint(observerLatitude, observerLongitude, observerAltitude);
            Frame moonFrame = moon.getBodyOrientedFrame();
            OneAxisEllipsoid moonBodyShape = new OneAxisEllipsoid(1737400.0, 0.0012, moonFrame);
            TopocentricFrame moonCentricLocation = new TopocentricFrame((BodyShape)moonBodyShape, geodeticPoint, "location");
            AbsoluteDate absoluteDate = new AbsoluteDate(date, (TimeScale)this.getUTCScale());
            TimeStampedPVCoordinates earthCoordinatesInMoonFrame = earth.getPVCoordinates(absoluteDate, (Frame)moonCentricLocation);
            earthCoordinates = this.convertToHorizontalCoordinates(earthCoordinatesInMoonFrame.getPosition());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return earthCoordinates;
    }

    @Override
    public Matrix3x3 getEarthOrientation(Date date, double observerLongitude, double observerLatitude, double observerAltitude) {
        Matrix3x3 rotationMatrix = null;
        return rotationMatrix;
    }

    @Override
    public HorizontalCoordinates getHorizontalSunPosition(Date date, double observerLongitude, double observerLatitude, double observerAltitude) {
        HorizontalCoordinates sunCoordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createHorizontalCoordinates();
        try {
            CelestialBody sun = CelestialBodyFactory.getSun();
            CelestialBody moon = CelestialBodyFactory.getMoon();
            GeodeticPoint geodeticPoint = new GeodeticPoint(observerLatitude, observerLongitude, observerAltitude);
            Frame moonFrame = moon.getBodyOrientedFrame();
            OneAxisEllipsoid moonBodyShape = new OneAxisEllipsoid(1737400.0, 0.0012, moonFrame);
            TopocentricFrame moonCentricLocation = new TopocentricFrame((BodyShape)moonBodyShape, geodeticPoint, "location");
            AbsoluteDate absoluteDate = new AbsoluteDate(date, (TimeScale)this.getUTCScale());
            TimeStampedPVCoordinates sunCoordinatesInMoonFrame = sun.getPVCoordinates(absoluteDate, (Frame)moonCentricLocation);
            sunCoordinates = this.convertToHorizontalCoordinates(sunCoordinatesInMoonFrame.getPosition());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sunCoordinates;
    }

    private HorizontalCoordinates convertToHorizontalCoordinates(Vector3D positionInTopocentricFrame) {
        double r = positionInTopocentricFrame.getNorm();
        double rXY = Math.sqrt(positionInTopocentricFrame.getX() * positionInTopocentricFrame.getX() + positionInTopocentricFrame.getY() * positionInTopocentricFrame.getY());
        double elevation = Math.atan(positionInTopocentricFrame.getZ() / rXY);
        double azimuth = Math.toRadians(90.0) - Math.atan2(positionInTopocentricFrame.getY(), positionInTopocentricFrame.getX());
        HorizontalCoordinates coordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createHorizontalCoordinates();
        coordinates.setAltitude(elevation);
        coordinates.setAzimuth(azimuth);
        coordinates.setRadius(r);
        return coordinates;
    }

    private UTCScale getUTCScale() {
        if (utcScale == null) {
            try {
                utcScale = TimeScalesFactory.getUTC();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return utcScale;
    }
}

