/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.moon.surface;

import java.util.Date;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.WorksiteNode;
import org.eclipse.apogy.core.environment.moon.surface.ApogyMoonSurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.moon.surface.MoonSky;
import org.eclipse.apogy.core.environment.moon.surface.MoonSurfaceUtils;
import org.eclipse.apogy.core.environment.moon.surface.MoonSurfaceWorksiteNode;
import org.eclipse.apogy.core.environment.moon.surface.impl.MoonSurfaceWorksiteImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MoonSurfaceWorksiteCustomImpl
extends MoonSurfaceWorksiteImpl {
    @Override
    public MoonSky getMoonSky() {
        MoonSky sky = super.getMoonSky();
        if (sky == null) {
            sky = ApogyMoonSurfaceEnvironmentFactory.eINSTANCE.createMoonSky();
            this.setSky(sky);
        }
        return sky;
    }

    @Override
    public MoonSky basicGetMoonSky() {
        return (MoonSky)super.getSky();
    }

    public void setSky(Sky newSky) {
        MoonSurfaceWorksiteNode moonSurfaceWorksiteNode;
        if (this.getSky() != null && this.getWorksiteNode() instanceof MoonSurfaceWorksiteNode) {
            moonSurfaceWorksiteNode = (MoonSurfaceWorksiteNode)this.getWorksiteNode();
            moonSurfaceWorksiteNode.getSkyTransformNode().getChildren().remove((Object)this.getSky().getSkyNode());
            moonSurfaceWorksiteNode.getChildren().remove((Object)this.getSky().getSkyNode());
        }
        super.setSky(newSky);
        if (newSky != null && this.getWorksiteNode() instanceof MoonSurfaceWorksiteNode) {
            moonSurfaceWorksiteNode = (MoonSurfaceWorksiteNode)this.getWorksiteNode();
            moonSurfaceWorksiteNode.getSkyTransformNode().getChildren().add((Object)newSky.getSkyNode());
        }
    }

    public WorksiteNode getWorksiteNode() {
        if (!(super.getWorksiteNode() instanceof MoonSurfaceWorksiteNode)) {
            this.worksiteNode = ApogyMoonSurfaceEnvironmentFactory.eINSTANCE.createMoonSurfaceWorksiteNode();
            this.worksiteNode.setWorksite((Worksite)this);
            if (this.getName() != null) {
                this.worksiteNode.setNodeId(this.getName().replaceAll(" ", "_"));
            }
            this.worksiteNode.setDescription("Root Node of the Worksite");
        }
        return this.worksiteNode;
    }

    public void setTime(Date newTime) {
        super.setTime(newTime);
        this.updateSunIntensity(newTime);
    }

    private void updateSunIntensity(Date newTime) {
        if (this.getSelenographicCoordinates() != null && this.getMoonSky() != null) {
            HorizontalCoordinates sunCoordinates = MoonSurfaceUtils.INSTANCE.getHorizontalSunPosition(newTime, this.getSelenographicCoordinates().getLongitude(), this.getSelenographicCoordinates().getLatitude(), this.getSelenographicCoordinates().getElevation());
            double intensity = 0.0;
            if (sunCoordinates.getAltitude() > 0.0) {
                intensity = 1353.0;
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.WORKSITE__SUN_IRRADIANCE, (Object)intensity, true);
        }
    }
}

