/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.moon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.moon.ApogyCoreEnvironmentMoonFactory;
import org.eclipse.apogy.core.environment.moon.MoonWorksite;
import org.eclipse.apogy.core.environment.moon.SelenographicCoordinates;
import org.eclipse.apogy.core.environment.moon.SelenographicCoordinatesRectangle;
import org.eclipse.apogy.core.environment.moon.impl.ApogyCoreEnvironmentMoonFacadeImpl;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;

public class ApogyCoreEnvironmentMoonFacadeCustomImpl
extends ApogyCoreEnvironmentMoonFacadeImpl {
    private Adapter activeWorksiteAdapter = null;

    public ApogyCoreEnvironmentMoonFacadeCustomImpl() {
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getWorksiteAdapter());
        AbstractWorksite abstractWorksite = ApogyCoreEnvironmentFacade.INSTANCE.getActiveWorksite();
        if (abstractWorksite instanceof MoonWorksite) {
            MoonWorksite newActiveMoonWorksite = (MoonWorksite)abstractWorksite;
            this.setActiveMoonWorksite(newActiveMoonWorksite);
        }
    }

    @Override
    public SelenographicCoordinates createSelenographicCoordinates(double longitude, double latitude, double altitude) {
        SelenographicCoordinates coord = ApogyCoreEnvironmentMoonFactory.eINSTANCE.createSelenographicCoordinates();
        coord.setLongitude(longitude);
        coord.setLatitude(latitude);
        coord.setElevation(altitude);
        return coord;
    }

    @Override
    public List<SelenographicCoordinates> loadSelenographicCoordinatesFromURL(String urlString) throws Exception {
        ArrayList<SelenographicCoordinates> coords = new ArrayList<SelenographicCoordinates>();
        URL url = new URL(urlString);
        File tempFile = this.copyURLContent(url);
        BufferedReader reader = new BufferedReader(new FileReader(tempFile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            SelenographicCoordinates coord = this.parserCSVLine(line);
            coords.add(coord);
        }
        reader.close();
        return coords;
    }

    @Override
    public SelenographicCoordinatesRectangle createSelenographicCoordinatesRectangle(double fromLatitude, double fromLongitude, double toLatitude, double toLongitude) {
        SelenographicCoordinatesRectangle rect = ApogyCoreEnvironmentMoonFactory.eINSTANCE.createSelenographicCoordinatesRectangle();
        SelenographicCoordinates corner1 = ApogyCoreEnvironmentMoonFactory.eINSTANCE.createSelenographicCoordinates();
        corner1.setLongitude(Math.toRadians(fromLongitude));
        corner1.setLatitude(Math.toRadians(fromLatitude));
        corner1.setElevation(0.0);
        rect.setNorthWestCorner(corner1);
        SelenographicCoordinates corner2 = ApogyCoreEnvironmentMoonFactory.eINSTANCE.createSelenographicCoordinates();
        corner2.setLongitude(Math.toRadians(toLongitude));
        corner2.setLatitude(Math.toRadians(toLatitude));
        corner2.setElevation(0.0);
        rect.setSouthEastCorner(corner2);
        return rect;
    }

    @Override
    public Tuple3d getEarthVector(Node node, Environment environment) {
        if (environment instanceof ApogyEnvironment) {
            Node universeRoot = null;
            EList earths = ApogyCommonTopologyFacade.INSTANCE.findNodesByID("EARTH", universeRoot);
            if (earths.size() > 0) {
                Node earth = (Node)earths.get(0);
                Matrix4d matrix = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(earth, node);
                Vector3d v = new Vector3d();
                matrix.get(v);
                v.normalize();
                return ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)v);
            }
            return null;
        }
        return null;
    }

    @Override
    public Tuple3d getEarthVector(ApogySystem apogySystem, String nodeID, Environment environment) {
        EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByID(nodeID, apogySystem.getTopologyRoot().getOriginNode());
        if (!nodes.isEmpty()) {
            Node node = (Node)nodes.get(0);
            return this.getEarthVector(node, environment);
        }
        return null;
    }

    private File copyURLContent(URL url) throws Exception {
        File tempFile = null;
        String fileName = this.getFileName(url);
        String fileExtension = this.getFileExtension(url);
        tempFile = File.createTempFile(fileName, fileExtension);
        url.openConnection();
        InputStream reader = url.openStream();
        FileOutputStream writer = new FileOutputStream(tempFile);
        byte[] buffer = new byte[153600];
        int bytesRead = 0;
        while ((bytesRead = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, bytesRead);
            buffer = new byte[153600];
        }
        writer.close();
        reader.close();
        if (tempFile != null) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    private String getFileName(URL url) {
        String fileName = url.getFile();
        int startIndex = fileName.lastIndexOf(File.separator);
        int endIndex = fileName.lastIndexOf(".");
        if (startIndex > 0 && endIndex > 0) {
            fileName = fileName.substring(startIndex + 1, endIndex);
        }
        return fileName;
    }

    private String getFileExtension(URL url) {
        String fileExtension = url.getFile();
        int index = fileExtension.lastIndexOf(".");
        if (index > 0) {
            fileExtension = fileExtension.substring(index);
        }
        return fileExtension;
    }

    private SelenographicCoordinates parserCSVLine(String line) throws Exception {
        SelenographicCoordinates coords = null;
        String[] entries = line.split(",");
        if (entries.length < 3) {
            throw new Exception("Line <" + line + "> contains too few entries !");
        }
        double longitude = Math.toRadians(Double.parseDouble(entries[0]));
        double lattitude = Math.toRadians(Double.parseDouble(entries[1]));
        double altitude = Double.parseDouble(entries[2]);
        coords = ApogyCoreEnvironmentMoonFactory.eINSTANCE.createSelenographicCoordinates();
        coords.setElevation(altitude);
        coords.setLatitude(lattitude);
        coords.setLongitude(longitude);
        return coords;
    }

    private Adapter getWorksiteAdapter() {
        if (this.activeWorksiteAdapter == null) {
            this.activeWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyCoreEnvironmentFacade) {
                        int featureID = msg.getFeatureID(ApogyCoreEnvironmentFacade.class);
                        switch (featureID) {
                            case 1: {
                                if (msg.getNewValue() instanceof MoonWorksite) {
                                    ApogyCoreEnvironmentMoonFacadeCustomImpl.this.setActiveMoonWorksite((MoonWorksite)msg.getNewValue());
                                    break;
                                }
                                ApogyCoreEnvironmentMoonFacadeCustomImpl.this.setActiveMoonWorksite(null);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.activeWorksiteAdapter;
    }
}

