/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.composites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.core.ApogyCoreFacade;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogyTopology;
import org.eclipse.apogy.core.FeatureOfInterestListNode;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.FeaturesOfInterestMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesOfInterestMapLayersListComposite
extends EMFFormsEListComposite<Map, Map, FeaturesOfInterestMapLayer> {
    public static String path = System.getProperty("user.home");
    private static final Logger Logger = LoggerFactory.getLogger(FeaturesOfInterestMapLayersListComposite.class);

    public FeaturesOfInterestMapLayersListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS, settings);
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return FeaturesOfInterestMapLayersListComposite.this.getEStructuralFeature();
            }

            public boolean hasChildren(Object element) {
                if (element instanceof Map) {
                    Map map = (Map)element;
                    return !this.filterMap(map).isEmpty();
                }
                return false;
            }

            public Object[] getElements(Object object) {
                if (object instanceof Map) {
                    Map map = (Map)object;
                    return this.filterMap(map).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Map) {
                    Map map = (Map)parentElement;
                    return this.filterMap(map).toArray();
                }
                return null;
            }

            private List<FeaturesOfInterestMapLayer> filterMap(Map map) {
                ArrayList<FeaturesOfInterestMapLayer> maps = new ArrayList<FeaturesOfInterestMapLayer>();
                for (AbstractMapLayer layer : map.getLayers()) {
                    if (!(layer instanceof FeaturesOfInterestMapLayer)) continue;
                    maps.add((FeaturesOfInterestMapLayer)layer);
                }
                return maps;
            }
        };
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createShowButton(parent, style).setToolTipText("Has the selected Feature Of Interest Layer visible in the 3D viewer.");
        this.createHideButton(parent, style).setToolTipText("Has the selected Feature Of Interest Layer invisible in the 3D viewer.");
        new Label(parent, 0);
        this.createSeparator(parent, style);
        this.createImportButton(parent, style);
        this.createExportButton(parent, style);
    }

    protected void doNew() {
        EObjectWizard wizard = new EObjectWizard((EObject)((Map)this.getResolvedEObject()), null, ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS, ApogySurfaceEnvironmentPackage.Literals.FEATURES_OF_INTEREST_MAP_LAYER, null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void doDelete(FeaturesOfInterestMapLayer layer) {
        ApogySurfaceEnvironmentFacade.INSTANCE.deleteLayerFromMap(layer.getMap(), (AbstractMapLayer)layer);
    }

    protected void doImport() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        fd.setFilterPath(path);
        fd.setFilterExtensions(new String[]{"*.csv"});
        fd.setOverwrite(true);
        String filePath = fd.open();
        if (filePath != null) {
            String urlString = "file://localhost/" + filePath.replace("\\", "/");
            try {
                List foiList = ApogyCoreFacade.INSTANCE.loadFeatureOfInterestFromFile(urlString);
                if (foiList.size() > 0) {
                    Logger.info("Loaded <" + foiList.size() + "> Feature of Interest from file<" + urlString + ">.");
                    FeaturesOfInterestMapLayer layer = ApogySurfaceEnvironmentFactory.eINSTANCE.createFeaturesOfInterestMapLayer();
                    layer.setFeatures(ApogyCoreFactory.eINSTANCE.createFeatureOfInterestList());
                    layer.getFeatures().getFeaturesOfInterest().addAll((Collection)foiList);
                    layer.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName(this.getResolvedEObject(), (EObject)layer, (ETypedElement)ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS));
                    layer.setDescription("Feature Of Interest imported from file <" + filePath + ">.");
                    ApogyCommonTransactionFacade.INSTANCE.basicAdd(this.getResolvedEObject(), (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS, (Object)layer, true);
                } else {
                    Logger.error("Could not load any Feature of Interest from file<" + urlString + ">.");
                }
            }
            catch (Exception ex) {
                Logger.error("Failed to import Feature of Interests from file<" + urlString + ">.", (Throwable)ex);
            }
        }
    }

    protected void doExport() {
        for (FeaturesOfInterestMapLayer foiMapLayer : this.getSelectedItemObjects()) {
            FileDialog fd = new FileDialog(this.getShell(), 8192);
            fd.setText("Save Features Of Interest Map Layer named <" + foiMapLayer.getName() + ">.");
            fd.setFilterPath(path);
            fd.setFilterExtensions(new String[]{"*.csv"});
            if (foiMapLayer.getName() != null) {
                fd.setFileName(String.valueOf(foiMapLayer.getName()) + ".csv");
            } else {
                fd.setFileName("unamed.csv");
            }
            fd.setOverwrite(true);
            String filePath = fd.open();
            if (filePath == null) continue;
            String urlString = "file://localhost/" + filePath.replace("\\", "/");
            try {
                ApogyCoreFacade.INSTANCE.saveFeatureOfInterestToFile(filePath, (List)foiMapLayer.getFeatures().getFeaturesOfInterest());
            }
            catch (Exception ex) {
                Logger.error("Failed to export Feature of Interests from file<" + urlString + ">.", (Throwable)ex);
            }
        }
    }

    protected Button createShowButton(Composite parent, int style) {
        Button button = FeaturesOfInterestMapLayersListComposite.createButton((Composite)parent, (int)0, (String)"Show", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doShow();
            this.refreshViewer();
        }));
        this.createShowButtonBindings(button);
        return button;
    }

    protected void createShowButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doShow() {
        for (FeaturesOfInterestMapLayer layer : this.getSelectedItemObjects()) {
            this.setNodeVisibility(layer, true);
        }
    }

    protected Button createHideButton(Composite parent, int style) {
        Button button = FeaturesOfInterestMapLayersListComposite.createButton((Composite)parent, (int)0, (String)"Hide", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doHide();
            this.refreshViewer();
        }));
        this.createHideButtonBindings(button);
        return button;
    }

    protected void createHideButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doHide() {
        for (FeaturesOfInterestMapLayer layer : this.getSelectedItemObjects()) {
            this.setNodeVisibility(layer, false);
        }
    }

    protected void setNodeVisibility(FeaturesOfInterestMapLayer featuresOfInterestMapLayer, boolean visible) {
        ApogyTopology apogyTopology = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology();
        if (apogyTopology != null) {
            GroupNode root = apogyTopology.getRootNode();
            EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST_NODE, (Node)root);
            for (Node node : nodes) {
                NodePresentation nodePresentation;
                FeatureOfInterestListNode listNode = (FeatureOfInterestListNode)node;
                if (listNode.getFeatureOfInterestList() != featuresOfInterestMapLayer.getFeatures() || (nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)listNode)) == null) continue;
                nodePresentation.setVisible(visible);
            }
        }
    }

    protected boolean isVisible(FeaturesOfInterestMapLayer featuresOfInterestMapLayer) {
        boolean visible = true;
        ApogyTopology apogyTopology = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology();
        if (apogyTopology != null) {
            GroupNode root = apogyTopology.getRootNode();
            EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST_NODE, (Node)root);
            for (Node node : nodes) {
                FeatureOfInterestListNode listNode = (FeatureOfInterestListNode)node;
                if (listNode.getFeatureOfInterestList() != featuresOfInterestMapLayer.getFeatures()) continue;
                NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)listNode);
                visible = nodePresentation.isVisible();
            }
        }
        return visible;
    }
}

