/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.composites;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ui.ImagesUiUtilities;
import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.apogy.core.environment.surface.ImageMapLayer;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMapLayerPreviewComposite
extends AbstractEObjectComposite<ImageMapLayer, ImageMapLayer, AbstractEImage> {
    private static final Logger Logger = LoggerFactory.getLogger(ImageMapLayerPreviewComposite.class);
    private Label lblImageWidthValue;
    private Button btnGenerateImage;
    private Label lblImageHeightValue;
    private Button btnExportImage;
    private Composite containerComposite;
    private ImageDisplayComposite imageDisplayComposite;
    private IValueChangeListener<AbstractEImage> iValueChangeListener;

    public ImageMapLayerPreviewComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(parent, style, featurePath, eStructuralFeature);
    }

    public void setRootEObject(ImageMapLayer rootEObject) {
        super.setRootEObject((EObject)rootEObject);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        Composite top = new Composite(parent, style);
        top.setLayout((Layout)new GridLayout(3, false));
        Label lblImageWidth = new Label(top, 0);
        lblImageWidth.setText("Image Width (pixels):");
        lblImageWidth.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.lblImageWidthValue = new Label(top, 2048);
        GridData gd_lblImageWidthValue = new GridData(16384, 128, false, false, 1, 1);
        gd_lblImageWidthValue.widthHint = 100;
        gd_lblImageWidthValue.minimumWidth = 100;
        this.lblImageWidthValue.setLayoutData((Object)gd_lblImageWidthValue);
        this.btnGenerateImage = new Button(top, 8);
        GridData gd_btnGenerateImage = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnGenerateImage.minimumWidth = 120;
        gd_btnGenerateImage.widthHint = 120;
        this.btnGenerateImage.setLayoutData((Object)gd_btnGenerateImage);
        this.btnGenerateImage.setText("Update Image");
        this.btnGenerateImage.setToolTipText("Update the image based on the selected setting. Note that this can take several minutes depending on the processing involved.");
        this.btnGenerateImage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final ImageMapLayer imageMapLayer = (ImageMapLayer)ImageMapLayerPreviewComposite.this.getRootEObject();
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (imageMapLayer != null) {
                            imageMapLayer.updateImage(monitor);
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(ImageMapLayerPreviewComposite.this.getDisplay().getActiveShell()).run(true, true, runnable);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblImageHeight = new Label(top, 0);
        lblImageHeight.setText("Image Height (pixels):");
        lblImageHeight.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.lblImageHeightValue = new Label(top, 2048);
        GridData gd_lblImageHeightValue = new GridData(16384, 128, false, false, 1, 1);
        gd_lblImageHeightValue.widthHint = 100;
        gd_lblImageHeightValue.minimumWidth = 100;
        this.lblImageHeightValue.setLayoutData((Object)gd_lblImageHeightValue);
        this.btnExportImage = new Button(top, 8);
        GridData gd_btnExportImage = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnExportImage.minimumWidth = 120;
        gd_btnExportImage.widthHint = 120;
        this.btnExportImage.setLayoutData((Object)gd_btnExportImage);
        this.btnExportImage.setText("Export Image...");
        this.btnExportImage.setToolTipText("Exports the layer image to file.");
        this.btnExportImage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImageMapLayer imageMapLayer = (ImageMapLayer)ImageMapLayerPreviewComposite.this.getRootEObject();
                try {
                    if (imageMapLayer != null) {
                        ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(imageMapLayer.getImage().asBufferedImage());
                        String defaultName = null;
                        if (imageMapLayer.getName() != null && imageMapLayer.getName().length() > 1) {
                            defaultName = String.valueOf(imageMapLayer.getName()) + ".jpg";
                        }
                        ImagesUiUtilities.export((ImageData)imageData, defaultName);
                    }
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.containerComposite = new Composite(top, 0);
        GridData gd_compositeDetails = new GridData(4, 4, false, true, 3, 1);
        gd_compositeDetails.widthHint = 398;
        gd_compositeDetails.minimumWidth = 398;
        this.containerComposite.setLayoutData((Object)gd_compositeDetails);
        this.containerComposite.setLayout((Layout)new GridLayout(1, false));
        this.imageDisplayComposite = new ImageDisplayComposite(this.containerComposite, 2048);
        GridData gd_imageDisplayComposite = new GridData(4, 4, true, true, 1, 1);
        gd_imageDisplayComposite.heightHint = 200;
        gd_imageDisplayComposite.minimumHeight = 200;
        gd_imageDisplayComposite.widthHint = 200;
        gd_imageDisplayComposite.minimumWidth = 200;
        this.imageDisplayComposite.setLayoutData((Object)gd_imageDisplayComposite);
        this.imageDisplayComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ImageMapLayerPreviewComposite.this.imageDisplayComposite.fitImage();
            }
        });
        this.iValueChangeListener = new IValueChangeListener<AbstractEImage>(){

            public void handleValueChange(ValueChangeEvent<? extends AbstractEImage> event) {
                ImageMapLayerPreviewComposite.this.updateImage((AbstractEImage)ImageMapLayerPreviewComposite.this.getItemObject());
            }
        };
        this.getItemObjectWritableValue().addValueChangeListener(this.iValueChangeListener);
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageMapLayerPreviewComposite.this.getItemObjectWritableValue().removeValueChangeListener(ImageMapLayerPreviewComposite.this.iValueChangeListener);
            }
        });
        return top;
    }

    private void updateImage(AbstractEImage abstractEImage) {
        if (abstractEImage != null) {
            this.lblImageWidthValue.setText("0");
            this.lblImageHeightValue.setText("0");
            ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(abstractEImage.asBufferedImage());
            if (imageData != null) {
                this.lblImageWidthValue.setText(Integer.toString(abstractEImage.getWidth()));
                this.lblImageHeightValue.setText(Integer.toString(abstractEImage.getHeight()));
                this.setImagePreview(imageData);
            } else {
                this.setNoImageToDisplayMessage("Map layer contains no image.");
            }
        } else {
            this.setNoImageToDisplayMessage("Map layer contains no image.");
        }
    }

    private void setImagePreview(ImageData imageData) {
        Control[] controlArray = this.containerComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.imageDisplayComposite = new ImageDisplayComposite(this.containerComposite, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.minimumWidth = 200;
        gd.widthHint = 200;
        gd.heightHint = 200;
        gd.minimumWidth = 200;
        this.imageDisplayComposite.setLayoutData((Object)gd);
        this.imageDisplayComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ImageMapLayerPreviewComposite.this.imageDisplayComposite.fitImage();
            }
        });
        this.imageDisplayComposite.setImageData(imageData);
        this.imageDisplayComposite.fitImage();
        this.containerComposite.layout();
        this.containerComposite.redraw();
    }

    private void setNoImageToDisplayMessage(final String message) {
        Control[] controlArray = this.containerComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        NoContentComposite noContentComposite = new NoContentComposite(this.containerComposite, 0){

            protected String getMessage() {
                return message;
            }
        };
        GridData gd = new GridData(4, 4, false, true, 1, 1);
        gd.minimumWidth = 200;
        gd.widthHint = 200;
        gd.heightHint = 200;
        gd.minimumWidth = 200;
        noContentComposite.setLayoutData((Object)gd);
        this.containerComposite.layout();
    }
}

