/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.wizards;

import java.util.ArrayList;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractECollectionContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsETreeComposite;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.ImageMapLayer;
import org.eclipse.apogy.core.environment.surface.ImageMapLayerPresentation;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.MapsList;
import org.eclipse.apogy.core.environment.surface.ui.MapLayerPresentationUISettings;
import org.eclipse.apogy.core.environment.surface.ui.composites.ImageMapLayerPresentationComposite;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImageMapLayerPresentationWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.ImageMapLayerPresentationWizardPage";
    private final MapLayerPresentationUISettings mapLayerPresentationUISettings;
    private EMFFormsETreeComposite<MapsList, Map, Map> mapsListComposite;
    private ImageMapLayerPresentationComposite imageMapLayerPresentationComposite;

    public ImageMapLayerPresentationWizardPage(MapLayerPresentationUISettings mapLayerPresentationUISettings) {
        super(WIZARD_PAGE_ID);
        this.mapLayerPresentationUISettings = mapLayerPresentationUISettings;
        this.setTitle("Image Map Layer Presentation Settings");
        this.setDescription("Configure the Image Map Layer Presentation settings");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Group imageLayersGroup = new Group(container, 0);
        imageLayersGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        imageLayersGroup.setText("Image Layers");
        imageLayersGroup.setLayout((Layout)new GridLayout(1, false));
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setButtonsSectionDisplayed(false);
        settings.setDetailSectionDisplayed(false);
        settings.setMultiSelection(false);
        this.mapsListComposite = new EMFFormsETreeComposite<MapsList, Map, Map>((Composite)imageLayersGroup, 0, null, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.MAPS_LIST__MAPS, settings){

            protected ITreeContentProvider createContentProvider(AdapterFactory adapterFactory) {
                return new AbstractECollectionContentProvider(adapterFactory){

                    public EStructuralFeature getEStructuralFeature() {
                        return null;
                    }

                    public Object[] getElements(Object object) {
                        if (object instanceof MapsList) {
                            MapsList mapsList = (MapsList)object;
                            return mapsList.getMaps().toArray();
                        }
                        if (object instanceof Map) {
                            Map map = (Map)object;
                            ArrayList<ImageMapLayer> imageMapLayers = new ArrayList<ImageMapLayer>();
                            for (AbstractMapLayer layer : map.getLayers()) {
                                if (!(layer instanceof ImageMapLayer)) continue;
                                imageMapLayers.add((ImageMapLayer)layer);
                            }
                            return imageMapLayers.toArray();
                        }
                        return new Object[0];
                    }

                    public boolean hasChildren(Object object) {
                        return this.getChildren(object).length > 0;
                    }

                    public Object[] getChildren(Object object) {
                        if (object instanceof MapsList) {
                            MapsList mapsList = (MapsList)object;
                            return mapsList.getMaps().toArray();
                        }
                        if (object instanceof Map) {
                            Map map = (Map)object;
                            ArrayList<ImageMapLayer> imageMapLayers = new ArrayList<ImageMapLayer>();
                            for (AbstractMapLayer layer : map.getLayers()) {
                                if (!(layer instanceof ImageMapLayer)) continue;
                                imageMapLayers.add((ImageMapLayer)layer);
                            }
                            return imageMapLayers.toArray();
                        }
                        return new Object[0];
                    }
                };
            }

            protected void selectionChanged(IStructuredSelection selection) {
                if (selection.getFirstElement() instanceof ImageMapLayer) {
                    ImageMapLayer layer = (ImageMapLayer)selection.getFirstElement();
                    ImageMapLayerPresentation imageMapLayerPresentation = ImageMapLayerPresentationWizardPage.this.mapLayerPresentationUISettings.getImageMapLayerPresentation();
                    if (imageMapLayerPresentation != null) {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)imageMapLayerPresentation, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.MAP_LAYER_PRESENTATION__MAP_LAYER, (Object)layer, true);
                    }
                    ImageMapLayerPresentationWizardPage.this.validate();
                }
            }
        };
        this.mapsListComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        MapsList mapList = (MapsList)this.mapLayerPresentationUISettings.getCartesianTriangularMeshMapLayer().getMap().eContainer();
        this.mapsListComposite.setRootEObject((EObject)mapList);
        Group presentationSettingsGroup = new Group(container, 0);
        presentationSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        presentationSettingsGroup.setText("Settings");
        presentationSettingsGroup.setLayout((Layout)new GridLayout(2, false));
        this.imageMapLayerPresentationComposite = new ImageMapLayerPresentationComposite((Composite)presentationSettingsGroup, 0);
        this.imageMapLayerPresentationComposite.setImageMapLayerPresentation(this.mapLayerPresentationUISettings.getImageMapLayerPresentation());
        new Label((Composite)presentationSettingsGroup, 0);
        this.setControl((Control)container);
    }

    protected void validate() {
        ImageMapLayerPresentation imageMapLayerPresentation = this.mapLayerPresentationUISettings.getImageMapLayerPresentation();
        if (imageMapLayerPresentation != null && imageMapLayerPresentation.getMapLayer() != null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage("The Image Map Layer is not set !");
            this.setPageComplete(false);
        }
    }
}

