/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ShaderBasedMeshToolType implements Enumerator
{
    NONE(0, "NONE", "None"),
    DISCRETE_SLOPES(1, "DISCRETE_SLOPES", "Discrete Slopes"),
    GRID(2, "GRID", "Grid"),
    BULLSEYE(3, "BULLSEYE", "Bullseye"),
    ANGULAR(4, "ANGULAR", "Angular"),
    IMAGE(5, "IMAGE", "Image");

    public static final int NONE_VALUE = 0;
    public static final int DISCRETE_SLOPES_VALUE = 1;
    public static final int GRID_VALUE = 2;
    public static final int BULLSEYE_VALUE = 3;
    public static final int ANGULAR_VALUE = 4;
    public static final int IMAGE_VALUE = 5;
    private static final ShaderBasedMeshToolType[] VALUES_ARRAY;
    public static final List<ShaderBasedMeshToolType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ShaderBasedMeshToolType[]{NONE, DISCRETE_SLOPES, GRID, BULLSEYE, ANGULAR, IMAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ShaderBasedMeshToolType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShaderBasedMeshToolType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShaderBasedMeshToolType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShaderBasedMeshToolType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShaderBasedMeshToolType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return DISCRETE_SLOPES;
            }
            case 2: {
                return GRID;
            }
            case 3: {
                return BULLSEYE;
            }
            case 4: {
                return ANGULAR;
            }
            case 5: {
                return IMAGE;
            }
        }
        return null;
    }

    private ShaderBasedMeshToolType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

